/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.context.ModelContext;
import org.eclipse.ocl.pivot.internal.context.OperationContext;
import org.eclipse.ocl.pivot.internal.context.PropertyContext;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractCustomizable;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationEnvironment;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.PivotModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.library.ImplementationManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.ICSI2ASMapping;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.options.EnumeratedOption;
import org.eclipse.ocl.pivot.options.PivotValidationOptions;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.ocl.pivot.values.ObjectValue;

public abstract class AbstractEnvironmentFactory
extends AbstractCustomizable
implements EnvironmentFactoryInternal {
    private boolean traceEvaluation;
    @NonNull
    protected final ProjectManager projectManager;
    @NonNull
    protected final ResourceSet externalResourceSet;
    protected final boolean externalResourceSetWasNull;
    private PivotMetamodelManager metamodelManager;
    @NonNull
    private final CompleteEnvironmentInternal completeEnvironment;
    @NonNull
    private final StandardLibraryInternal standardLibrary;
    @Nullable
    private ICSI2ASMapping csi2asMapping;
    @NonNull
    private final CompleteModelInternal completeModel;
    private IdResolver idResolver;
    private int attachCount = 0;
    @NonNull
    private Technology technology = ASResourceFactoryRegistry.INSTANCE.getTechnology();
    private Map<Object, StatusCodes.Severity> validationKey2severity = null;

    protected AbstractEnvironmentFactory(@NonNull ProjectManager projectManager, @Nullable ResourceSet externalResourceSet) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            PivotStandaloneSetup.doSetup();
        }
        this.projectManager = projectManager;
        if (externalResourceSet != null) {
            this.externalResourceSetWasNull = false;
            this.externalResourceSet = externalResourceSet;
        } else {
            this.externalResourceSetWasNull = true;
            this.externalResourceSet = externalResourceSet = new ResourceSetImpl();
            projectManager.initializeResourceSet(externalResourceSet);
            externalResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emof", new EMOFResourceFactoryImpl());
            ASResourceFactoryRegistry.INSTANCE.configureResourceSet(externalResourceSet);
        }
        this.adapt((Notifier)externalResourceSet);
        this.metamodelManager = null;
        this.completeEnvironment = this.createCompleteEnvironment();
        this.standardLibrary = this.completeEnvironment.getOwnedStandardLibrary();
        this.completeModel = this.completeEnvironment.getOwnedCompleteModel();
    }

    @NonNull
    public EnvironmentFactoryAdapter adapt(@NonNull Notifier notifier) {
        List eAdapters = (List)ClassUtil.nonNullEMF(notifier.eAdapters());
        EnvironmentFactoryAdapter adapter = ClassUtil.getAdapter(EnvironmentFactoryAdapter.class, eAdapters);
        if (adapter == null) {
            adapter = new EnvironmentFactoryAdapter(this, notifier);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    @Override
    public void addExternal2AS(@NonNull External2AS external2as) {
        Resource resource = external2as.getResource();
        if (resource != null && ClassUtil.isRegistered(resource)) {
            ResourceSet externalResourceSet2 = this.getResourceSet();
            this.projectManager.useGeneratedResource(resource, externalResourceSet2);
        }
        this.getMetamodelManager().addExternal2AS(external2as);
    }

    @Override
    public void addExternalResources(@NonNull ResourceSet resourceSet) {
        Map uriResourceMap;
        ResourceSet externalResourceSet = this.getResourceSet();
        if (externalResourceSet instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)externalResourceSet).getURIResourceMap()) != null) {
            Map contextResourceMap;
            for (Resource eResource : resourceSet.getResources()) {
                URI uri = eResource.getURI();
                if (uri == null) continue;
                uriResourceMap.put(uri, eResource);
            }
            if (resourceSet instanceof ResourceSetImpl && (contextResourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap()) != null && contextResourceMap != uriResourceMap) {
                for (URI uri : contextResourceMap.keySet()) {
                    uriResourceMap.put(uri, (Resource)contextResourceMap.get(uri));
                }
            }
        }
    }

    @Override
    public synchronized void attach(Object object) {
        if (this.attachCount < 0) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " disposed");
        }
        ++this.attachCount;
    }

    @Nullable
    protected PivotMetamodelManager basicGetMetamodelManager() {
        return this.metamodelManager;
    }

    @Override
    public void configureLoadFirstStrategy() {
        this.configureLoadStrategy(StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
    }

    @Override
    public void configureLoadStrategy(@NonNull ProjectManager.IResourceLoadStrategy packageLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
        ResourceSet externalResourceSet = this.getResourceSet();
        this.projectManager.configure(externalResourceSet, packageLoadStrategy, conflictHandler);
    }

    @Override
    @NonNull
    public ResourceSetImpl createASResourceSet() {
        ResourceSetImpl asResourceSet = new ResourceSetImpl();
        StandaloneProjectMap.initializeURIResourceMap((ResourceSet)asResourceSet);
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)asResourceSet);
        EPackage.Registry packageRegistry = asResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
        asResourceSet.eAdapters().add((Object)this.projectManager);
        this.projectManager.initializeResourceSet((ResourceSet)asResourceSet);
        return asResourceSet;
    }

    @Override
    @NonNull
    public CompleteEnvironmentInternal createCompleteEnvironment() {
        CompleteEnvironmentInternal completeEnvironment = (CompleteEnvironmentInternal)PivotFactory.eINSTANCE.createCompleteEnvironment();
        completeEnvironment.init(this);
        return completeEnvironment;
    }

    @Override
    @NonNull
    public EvaluationEnvironment createEvaluationEnvironment(@NonNull NamedElement executableObject, @NonNull ModelManager modelManager) {
        return new BasicEvaluationEnvironment(this, executableObject, modelManager);
    }

    @Override
    @NonNull
    public EvaluationEnvironment createEvaluationEnvironment(@NonNull EvaluationEnvironment parent, @NonNull NamedElement executableObject) {
        return new BasicEvaluationEnvironment(parent, executableObject);
    }

    @Override
    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@Nullable Object context, @NonNull ExpressionInOCL expression, @Nullable ModelManager modelManager) {
        if (modelManager == null) {
            modelManager = this.createModelManager(context);
        }
        EvaluationEnvironment evaluationEnvironment = this.createEvaluationEnvironment(expression, modelManager);
        Variable contextVariable = expression.getOwnedContext();
        if (contextVariable != null) {
            IdResolver idResolver = this.getIdResolver();
            Object value = idResolver.boxedValueOf(context);
            evaluationEnvironment.add(contextVariable, value);
        }
        for (Variable parameterVariable : expression.getOwnedParameters()) {
            if (parameterVariable == null) continue;
            evaluationEnvironment.add(parameterVariable, null);
        }
        return this.createEvaluationVisitor(evaluationEnvironment);
    }

    @Override
    @NonNull
    public EvaluationVisitor createEvaluationVisitor(@NonNull EvaluationEnvironment evalEnv) {
        AbstractExtendingVisitor result = new OCLEvaluationVisitor(evalEnv);
        if (this.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor((EvaluationVisitor)((Object)result));
        }
        return result;
    }

    @Override
    @NonNull
    public IdResolver createIdResolver() {
        return this.technology.createIdResolver(this);
    }

    @Override
    @NonNull
    public ImplementationManager createImplementationManager() {
        return new ImplementationManager(this);
    }

    @Override
    @NonNull
    public PivotMetamodelManager createMetamodelManager() {
        assert (this.metamodelManager == null);
        this.metamodelManager = new PivotMetamodelManager(this, (ResourceSet)this.createASResourceSet());
        assert (this.metamodelManager != null);
        return this.metamodelManager;
    }

    @NonNull
    protected ModelManager createModelManager() {
        return ModelManager.NULL;
    }

    @Override
    @NonNull
    public ModelManager createModelManager(@Nullable Object object) {
        if (object instanceof ObjectValue) {
            object = ((ObjectValue)object).getObject();
        }
        if (object instanceof EObject) {
            return new PivotModelManager(this, (EObject)object);
        }
        return ModelManager.NULL;
    }

    @Override
    @NonNull
    public OCLInternal createOCL() {
        return new OCLInternal(this);
    }

    @Override
    @NonNull
    public ParserContext createParserContext(@Nullable EObject context) {
        Property asProperty;
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        if (context instanceof Class) {
            return new ClassContext(this, null, (Class)context, null);
        }
        if (context instanceof Operation) {
            return new OperationContext((EnvironmentFactory)this, null, (Operation)context, null);
        }
        if (context instanceof Property) {
            return new PropertyContext(this, null, (Property)context);
        }
        if (context instanceof EClassifier) {
            Class contextClass = metamodelManager.getASOfEcore(Class.class, context);
            return new ClassContext(this, null, contextClass, null);
        }
        if (context instanceof EOperation) {
            Operation asOperation = metamodelManager.getASOfEcore(Operation.class, context);
            if (asOperation != null) {
                return new OperationContext((EnvironmentFactory)this, null, asOperation, null);
            }
        } else if (context instanceof EStructuralFeature && (asProperty = metamodelManager.getASOfEcore(Property.class, context)) != null) {
            return new PropertyContext(this, null, asProperty);
        }
        return new ModelContext(this, null);
    }

    @NonNull
    protected HashMap<Object, StatusCodes.Severity> createValidationKey2severityMap() {
        HashMap<Object, StatusCodes.Severity> map = new HashMap<Object, StatusCodes.Severity>();
        Set<Map.Entry<String, EnumeratedOption<StatusCodes.Severity>>> entrySet = PivotValidationOptions.safeValidationName2severityOption.entrySet();
        for (Map.Entry<String, EnumeratedOption<StatusCodes.Severity>> entry : entrySet) {
            EnumeratedOption<StatusCodes.Severity> value = entry.getValue();
            if (value == null) continue;
            map.put(entry.getKey(), this.getValue(value));
        }
        return map;
    }

    @Override
    public synchronized void detach(Object object) {
        if (this.attachCount < 0) {
            return;
        }
        if (this.attachCount == 0) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " not attached");
        }
        if (--this.attachCount <= 0) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.attachCount < 0) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " already disposed");
        }
        this.attachCount = -1;
        this.disposeInternal();
    }

    protected void disposeInternal() {
        boolean isGlobal;
        assert (this.attachCount == -1);
        boolean bl = isGlobal = this == GlobalEnvironmentFactory.basicGetInstance();
        if (this.metamodelManager != null) {
            this.metamodelManager.dispose();
            this.metamodelManager = null;
        }
        EList externalResourceSetAdapters = this.externalResourceSet.eAdapters();
        if (this.externalResourceSetWasNull || isGlobal) {
            this.projectManager.unload(this.externalResourceSet);
            externalResourceSetAdapters.remove((Object)this.projectManager);
            this.externalResourceSet.setPackageRegistry(null);
            this.externalResourceSet.setResourceFactoryRegistry(null);
            this.externalResourceSet.setURIConverter(null);
            if (this.externalResourceSet instanceof ResourceSetImpl) {
                ((ResourceSetImpl)this.externalResourceSet).setURIResourceMap(null);
            }
            for (Resource resource : new ArrayList(this.externalResourceSet.getResources())) {
                if (Thread.currentThread().getContextClassLoader() == null) {
                    if (!resource.getContents().isEmpty()) {
                        resource.getContents().clear();
                    }
                    resource.getErrors().clear();
                    resource.getWarnings().clear();
                } else {
                    resource.unload();
                }
                resource.eAdapters().clear();
            }
            externalResourceSetAdapters.clear();
        } else {
            for (Adapter adapter : externalResourceSetAdapters) {
                if (!(adapter instanceof EnvironmentFactoryAdapter) || ((EnvironmentFactoryAdapter)adapter).getEnvironmentFactory() != this) continue;
                externalResourceSetAdapters.remove((Object)adapter);
                break;
            }
        }
        if (this.idResolver != null) {
            this.idResolver.dispose();
            this.idResolver = null;
        }
        if (this.csi2asMapping != null) {
            this.csi2asMapping.dispose();
            this.csi2asMapping = null;
        }
    }

    @Override
    public <T> T getAdapter(java.lang.Class<T> adapterType) {
        AbstractEnvironmentFactory result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }

    @NonNull
    protected Class getClassifier(@NonNull Object context) {
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        Class dClass = this.getIdResolver().getStaticTypeOf(context);
        return metamodelManager.getPrimaryClass(dClass);
    }

    @Override
    @NonNull
    public CompleteEnvironmentInternal getCompleteEnvironment() {
        return this.completeEnvironment;
    }

    @Override
    @NonNull
    public CompleteModelInternal getCompleteModel() {
        return this.completeModel;
    }

    @Override
    @Nullable
    public ICSI2ASMapping getCSI2ASMapping() {
        return this.csi2asMapping;
    }

    @Override
    @Nullable
    public String getDoSetupName(@NonNull URI uri) {
        String fileExtension = uri.fileExtension();
        if ("essentialocl".equals(fileExtension)) {
            return "EssentialOCLStandaloneSetup.doSetup()";
        }
        if ("ocl".equals(fileExtension)) {
            return "CompleteOCLStandaloneSetup.doSetup()";
        }
        if ("oclinecore".equals(fileExtension)) {
            return "OCLinEcoreStandaloneSetup.doSetup()";
        }
        if ("oclstdlib".equals(fileExtension)) {
            return "OCLstdlibStandaloneSetup.doSetup()";
        }
        return null;
    }

    @Override
    @NonNull
    public IdResolver getIdResolver() {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2;
    }

    @Override
    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        PivotMetamodelManager metamodelManager2 = this.metamodelManager;
        if (metamodelManager2 == null) {
            this.metamodelManager = metamodelManager2 = this.createMetamodelManager();
        }
        return metamodelManager2;
    }

    @Override
    @Nullable
    protected EnvironmentFactoryInternal getParent() {
        return null;
    }

    @Override
    @NonNull
    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    @Override
    @NonNull
    public ResourceSet getResourceSet() {
        return this.externalResourceSet;
    }

    @Override
    @Nullable
    public StatusCodes.Severity getSeverity(@Nullable Object validationKey) {
        Map<Object, StatusCodes.Severity> validationKey2severity2 = this.validationKey2severity;
        if (validationKey2severity2 == null) {
            this.validationKey2severity = validationKey2severity2 = this.createValidationKey2severityMap();
        }
        return validationKey2severity2.get(validationKey);
    }

    @Override
    @NonNull
    public StandardLibraryInternal getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @NonNull
    public Technology getTechnology() {
        return this.technology;
    }

    protected boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    @Override
    public EPackage loadEPackage(@NonNull EPackage ePackage) {
        return this.externalResourceSet.getPackageRegistry().getEPackage(ePackage.getNsURI());
    }

    @Override
    @Nullable
    public Element loadResource(@NonNull Resource resource, @Nullable URI uri) throws ParserException {
        ASResourceFactory bestFactory = ASResourceFactoryRegistry.INSTANCE.getASResourceFactory(resource);
        if (bestFactory != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && resourceSet != this.externalResourceSet) {
                this.addExternalResources(resourceSet);
            }
            return bestFactory.importFromResource(this, resource, uri);
        }
        throw new ParserException("Cannot create pivot from '" + uri + "'");
    }

    public void resetSeverities() {
        this.validationKey2severity = null;
    }

    @Override
    public void setCSI2ASMapping(ICSI2ASMapping csi2asMapping) {
        this.csi2asMapping = csi2asMapping;
    }

    @Override
    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }

    @Override
    public void setProject(@Nullable IProject project) {
    }

    @Override
    public void setSafeNavigationValidationSeverity(@NonNull StatusCodes.Severity severity) {
        for (String key : PivotValidationOptions.safeValidationName2severityOption.keySet()) {
            if (key == null) continue;
            this.setSeverity(key, severity);
        }
    }

    @Override
    @Nullable
    public synchronized StatusCodes.Severity setSeverity(@NonNull Object validationKey, StatusCodes.Severity severity) {
        Map<Object, StatusCodes.Severity> validationKey2severity2 = this.validationKey2severity;
        if (validationKey2severity2 == null) {
            this.validationKey2severity = validationKey2severity2 = this.createValidationKey2severityMap();
        }
        return validationKey2severity2.put(validationKey, severity);
    }
}

