/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClassUtil {
    public static <T> T asClassOrNull(Object object, Class<T> requiredClass) {
        if (object == null) {
            return null;
        }
        if (requiredClass == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAssignableFrom(objectClass)) {
            return null;
        }
        return (T)object;
    }

    public static <T> T asClassUnchecked(Object object, T requiredClassObject) {
        return (T)object;
    }

    public static <T> T asClassUnchecked(Object object) {
        return (T)object;
    }

    @Nullable
    public static EAnnotation basicGetMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation asMetamodelAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        return asMetamodelAnnotation;
    }

    public static <T> Class<T> getClass(T object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    @NonNull
    public static EAnnotation getEAnnotation(@NonNull EModelElement eModelElement, String sourceURI) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(sourceURI);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    @NonNull
    public static EAnnotation getMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/OCL/ASMetamodel");
            ePackage.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static <T> T isInstanceOf(Object anObject, Class<T> aClass) {
        if (anObject == null) {
            return null;
        }
        Class<?> objectClass = anObject.getClass();
        if (aClass.isAssignableFrom(objectClass)) {
            return (T)anObject;
        }
        return null;
    }

    public static boolean isRegistered(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceSet() == null;
    }

    @NonNull
    public static <T> T nonNullEMF(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullModel(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullPivot(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    @NonNull
    public static <T> T nonNullState(@Nullable T aT) {
        if (aT == null) {
            throw new IllegalStateException();
        }
        return aT;
    }

    public static <T extends Comparable<T>> int safeCompareTo(@Nullable T object, @Nullable T otherObject) {
        if (object == null) {
            return otherObject == null ? 1 : 0;
        }
        return otherObject == null ? -1 : object.compareTo(otherObject);
    }

    public static boolean safeEquals(@Nullable Object object, @Nullable Object otherObject) {
        return object == null ? otherObject == null : object.equals(otherObject);
    }

    public static <T> void sort(@NonNull List<T> aList, @NonNull Comparator<T> comparator) {
        if (aList.size() > 1) {
            if (aList instanceof EList) {
                ECollections.sort((EList)((EList)aList), comparator);
            } else {
                Collections.sort(aList, comparator);
            }
        }
    }

    public static <T> T getAdapter(@NonNull Class<T> adapterClass, @NonNull Notifier notifier) {
        List eAdapters = (List)ClassUtil.nonNullEMF(notifier.eAdapters());
        return ClassUtil.getAdapter(adapterClass, eAdapters);
    }

    public static <T> T getAdapter(@NonNull Class<T> adapterClass, @NonNull List<Adapter> eAdapters) {
        Adapter adapter = EcoreUtil.getAdapter(eAdapters, adapterClass);
        if (adapter == null) {
            return null;
        }
        if (!adapterClass.isAssignableFrom(adapter.getClass())) {
            throw new ClassCastException(String.valueOf(adapter.getClass().getName()) + " is not assignable to " + adapterClass.getName());
        }
        Adapter castAdapter = adapter;
        return (T)castAdapter;
    }
}

