/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;

public class NameUtil {
    public static final NameableComparator NAMEABLE_COMPARATOR = NameableComparator.INSTANCE;

    public static String debugFullName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String debugSimpleName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    @Nullable
    public static <T extends ENamedElement> T getENamedElement(@Nullable Iterable<T> elements, @Nullable String name) {
        if (elements == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!ClassUtil.safeEquals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static <T extends ENamedElement, R extends T> R getENamedElement(@Nullable Iterable<T> elements, @Nullable String name, @Nullable Class<R> returnClass) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (returnClass == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!returnClass.isAssignableFrom(element.getClass()) || !ClassUtil.safeEquals(name, element.getName())) continue;
            return (R)element;
        }
        return null;
    }

    public static <T extends Nameable> T getNameable(@Nullable Iterable<T> elements, @Nullable String name) {
        if (elements == null) {
            return null;
        }
        for (Nameable element : elements) {
            if (!ClassUtil.safeEquals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static String getOriginalName(@NonNull ENamedElement eNamedElement) {
        String originalName;
        EAnnotation eAnnotation = eNamedElement.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && (originalName = (String)eAnnotation.getDetails().get((Object)"originalName")) != null) {
            return originalName;
        }
        return eNamedElement.getName();
    }

    @NonNull
    public static String getSafeName(@Nullable Nameable aNameable) {
        if (aNameable == null) {
            return "";
        }
        String name = aNameable.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    @NonNull
    public static String qualifiedNameFor(@Nullable Object object) {
        if (object == null) {
            return "<<null>>";
        }
        HashMap options = new HashMap();
        options.put(ILabelGenerator.Builder.SHOW_QUALIFIER, "::");
        return LabelUtil.QUALIFIED_NAME_REGISTRY.labelFor(object, options);
    }

    @NonNull
    public static String simpleNameFor(@Nullable Object object) {
        if (object == null) {
            return "<<null>>";
        }
        return LabelUtil.SIMPLE_NAME_REGISTRY.labelFor(object);
    }

    public static final class EAnnotationComparator
    implements Comparator<EAnnotation> {
        @NonNull
        public static final EAnnotationComparator INSTANCE = new EAnnotationComparator();

        @Override
        public int compare(EAnnotation o1, EAnnotation o2) {
            String n1 = o1.getSource();
            String n2 = o2.getSource();
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }

    public static final class ENamedElementComparator
    implements Comparator<ENamedElement> {
        @NonNull
        public static final ENamedElementComparator INSTANCE = new ENamedElementComparator();

        @Override
        public int compare(ENamedElement o1, ENamedElement o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }

    public static final class NameableComparator
    implements Comparator<Nameable> {
        @NonNull
        public static final NameableComparator INSTANCE = new NameableComparator();

        @Override
        public int compare(Nameable o1, Nameable o2) {
            String n1 = NameUtil.getSafeName(o1);
            String n2 = NameUtil.getSafeName(o2);
            return ClassUtil.safeCompareTo(n1, n2);
        }
    }
}

