/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.osgi.util.NLS;

public class StringUtil {
    private static final String maxIntValue = Integer.toString(Integer.MAX_VALUE);
    private static final int maxIntSize = maxIntValue.length();
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void appendMultiplicity(@NonNull StringBuilder s, long lower, long upper, boolean isNullFree) {
        s.append("[");
        if (upper < 0L) {
            if (lower == 1L) {
                s.append("+");
            } else {
                if (lower != 0L) {
                    s.append(lower);
                    s.append("..");
                }
                s.append("*");
            }
        } else if (lower == 0L && upper == 1L) {
            s.append("?");
        } else {
            s.append(lower);
            if (lower != upper) {
                s.append("..");
                s.append(upper);
            }
        }
        s.append("|");
        s.append(isNullFree ? "1" : "?");
        s.append("]");
    }

    @Deprecated
    public static void appendMultiplicity(@NonNull StringBuilder s, long lower, long upper) {
        StringUtil.appendMultiplicity(s, lower, upper, false);
    }

    @NonNull
    public static String bind(String messageTemplate, Object ... bindings) {
        String result = NLS.bind((String)messageTemplate, (Object[])bindings);
        return result;
    }

    @NonNull
    public static String convertFromOCLString(@NonNull String javaString) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                if ((aChar = in[off++]) == 'u') {
                    int value = 0;
                    if (off + 4 > end) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToOCLString(String theString) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(StringUtil.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(StringUtil.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(StringUtil.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(StringUtil.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    @NonNull
    public static Number createNumberFromString(@NonNull String aValue) throws NumberFormatException {
        if ("*".equals(aValue)) {
            return Unlimited.INSTANCE;
        }
        int len = aValue.length();
        if (len < maxIntSize || len == maxIntSize && maxIntValue.compareTo(aValue) >= 0) {
            Integer result = Integer.valueOf(aValue);
            assert (result != null);
            return result;
        }
        if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
            Long result = Long.valueOf(aValue);
            assert (result != null);
            return result;
        }
        return new BigInteger(aValue);
    }

    @NonNull
    public static String formatMultiplicity(@Nullable ETypedElement typedElement) {
        int upper;
        if (typedElement == null) {
            return "";
        }
        int lower = typedElement.getLowerBound();
        if (lower == (upper = typedElement.getUpperBound())) {
            return Integer.toString(lower);
        }
        if (lower == 0) {
            if (upper < 0) {
                return "*";
            }
            if (upper == 1) {
                return "?";
            }
        } else if (lower == 1 && upper < 0) {
            return "+";
        }
        return String.valueOf(Integer.toString(lower)) + ".." + (upper >= 0 ? Integer.toString(upper) : "*");
    }

    @NonNull
    public static String formatOrdered(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isOrdered() && typedElement.isMany() : false;
        return isOrdered ? "{ordered}" : "";
    }

    @NonNull
    public static String formatString(@Nullable String name) {
        return name != null ? name : "<null>";
    }

    @NonNull
    public static String formatUnique(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isUnique() && typedElement.isMany() : false;
        return isOrdered ? "{unique}" : "";
    }

    public static String getIndentation(int depth, @NonNull String string) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
        return s.toString();
    }

    public static String splice(List<String> strings, String separator) {
        if (strings == null) {
            return null;
        }
        int iMax = strings.size();
        if (iMax <= 0) {
            return "";
        }
        if (iMax == 1) {
            return strings.get(0);
        }
        StringBuilder s = new StringBuilder();
        s.append(strings.get(0));
        int i = 1;
        while (i < iMax) {
            s.append(separator);
            s.append(strings.get(i));
            ++i;
        }
        return s.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

