/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TracingOption
implements Appendable {
    public static final TracingOption DEBUG = new TracingOption("org.eclipse.ocl.pivot", "debug");
    @NonNull
    private final String option;
    private boolean resolved = false;
    private boolean state = false;

    public static void println(@NonNull Appendable appendable, @NonNull String string) {
        try {
            appendable.append(string);
            appendable.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TracingOption(@NonNull String option) {
        this("org.eclipse.ocl.pivot", option);
    }

    public TracingOption(String pluginId, String option) {
        this.option = String.valueOf(pluginId) + "/" + option;
    }

    @Override
    @NonNull
    public Appendable append(CharSequence csq) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.append(csq);
        }
        return this;
    }

    @Override
    @NonNull
    public Appendable append(CharSequence csq, int start, int end) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.append(csq, start, end);
        }
        return this;
    }

    @Override
    @NonNull
    public Appendable append(char c) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.append(c);
        }
        return this;
    }

    public boolean isActive() {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        return this.state;
    }

    public void println(@Nullable String string) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.println(String.valueOf(this.option) + " : " + string);
        }
    }

    public void println(@NonNull Class<?> clazz, @Nullable String string) {
        if (!this.resolved) {
            this.state = this.resolveState();
            this.resolved = true;
        }
        if (this.state) {
            System.out.println(String.valueOf(this.option) + " : " + clazz.getSimpleName() + " : " + string);
        }
    }

    public boolean resolveState() {
        try {
            String debugOption = Platform.getDebugOption((String)this.option);
            return Boolean.TRUE.toString().equalsIgnoreCase(debugOption);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void setState(boolean state) {
        this.state = state;
        this.resolved = true;
    }
}

