/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionKind;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterTypes;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.values.CollectionTypeParametersImpl;
import org.eclipse.ocl.pivot.internal.values.MapTypeParametersImpl;
import org.eclipse.ocl.pivot.types.ParameterTypesImpl;
import org.eclipse.ocl.pivot.types.TemplateParametersImpl;
import org.eclipse.ocl.pivot.values.CollectionTypeParameters;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.MapTypeParameters;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class TypeUtil {
    public static boolean conformsToCollectionType(@NonNull StandardLibrary standardLibrary, @NonNull CollectionType firstCollectionType, @NonNull CollectionType secondCollectionType) {
        UnlimitedNaturalValue secondUpper;
        IntegerValue secondLower;
        IntegerValue firstLower;
        Type secondElementType;
        Type firstElementType;
        Class secondContainerType;
        Class firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType())) {
            CompleteInheritance firstInheritance = firstContainerType.getInheritance(standardLibrary);
            CompleteInheritance secondInheritance = secondContainerType.getInheritance(standardLibrary);
            if (!secondInheritance.isSuperInheritanceOf(firstInheritance)) {
                return false;
            }
        }
        if ((firstElementType = firstCollectionType.getElementType()) != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null || secondElementType == null) {
                return false;
            }
            if (!firstElementType.conformsTo(standardLibrary, secondElementType)) {
                return false;
            }
        }
        if ((firstLower = firstCollectionType.getLowerValue()).compareTo(secondLower = secondCollectionType.getLowerValue()) < 0) {
            return false;
        }
        UnlimitedNaturalValue firstUpper = firstCollectionType.getUpperValue();
        return firstUpper.compareTo(secondUpper = secondCollectionType.getUpperValue()) <= 0;
    }

    public static boolean conformsToLambdaType(@NonNull StandardLibrary standardLibrary, @NonNull LambdaType firstLambdaType, @NonNull LambdaType secondLambdaType) {
        throw new UnsupportedOperationException();
    }

    public static boolean conformsToMapType(@NonNull StandardLibrary standardLibrary, @NonNull MapType firstMapType, @NonNull MapType secondMapType) {
        Type secondValueType;
        Type firstValueType;
        Type secondKeyType;
        Type firstKeyType = firstMapType.getKeyType();
        if (firstKeyType != (secondKeyType = secondMapType.getKeyType())) {
            if (firstKeyType == null || secondKeyType == null) {
                return false;
            }
            if (!firstKeyType.conformsTo(standardLibrary, secondKeyType)) {
                return false;
            }
        }
        if ((firstValueType = firstMapType.getValueType()) != (secondValueType = secondMapType.getValueType())) {
            if (firstValueType == null || secondValueType == null) {
                return false;
            }
            if (!firstValueType.conformsTo(standardLibrary, secondValueType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean conformsToTupleType(@NonNull StandardLibrary standardLibrary, @NonNull TupleType firstTupleType, @NonNull TupleType secondTupleType) {
        if (TypeUtil.isEqualToTupleType(standardLibrary, firstTupleType, secondTupleType)) {
            return true;
        }
        CompleteInheritance firstInheritance = firstTupleType.getInheritance(standardLibrary);
        CompleteInheritance secondInheritance = secondTupleType.getInheritance(standardLibrary);
        return firstInheritance.isSuperInheritanceOf(secondInheritance);
    }

    @Deprecated
    @NonNull
    public static CollectionTypeParameters<Type> createCollectionTypeParameters(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return new CollectionTypeParametersImpl<Type>(elementType, false, lower, upper);
    }

    @NonNull
    public static CollectionTypeParameters<Type> createCollectionTypeParameters(@NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return new CollectionTypeParametersImpl<Type>(elementType, isNullFree, lower, upper);
    }

    @NonNull
    public static MapTypeParameters<Type, Type> createMapTypeParameters(@NonNull Type keyType, @NonNull Type valueType) {
        return new MapTypeParametersImpl<Type, Type>(keyType, valueType);
    }

    @NonNull
    public static ParameterTypes createParameterTypes(Type ... parameterTypes) {
        return new ParameterTypesImpl(parameterTypes);
    }

    @NonNull
    public static TemplateParameters createTemplateParameters(TemplateParameter ... parameters) {
        return new TemplateParametersImpl(parameters);
    }

    @NonNull
    public static TemplateParameters createTemplateParameters(@NonNull List<? extends Type> parameters) {
        return new TemplateParametersImpl(parameters);
    }

    @NonNull
    public static Type[] getLambdaParameterTypes(@NonNull LambdaType lambdaType) {
        int iParameter = 0;
        List<? extends Type> ownedParameters = lambdaType.getParameterTypes();
        Type[] parameterTypes = new Type[ownedParameters.size() + 2];
        parameterTypes[iParameter++] = lambdaType.getContextType();
        parameterTypes[iParameter++] = lambdaType.getResultType();
        for (Type type : ownedParameters) {
            parameterTypes[iParameter++] = type;
        }
        return parameterTypes;
    }

    @NonNull
    public static Type[] getOperationParameterTypes(@NonNull Operation anOperation) {
        Type[] parameterTypes;
        int iParameter = 0;
        List<Parameter> ownedParameters = anOperation.getOwnedParameters();
        if (anOperation instanceof Iteration) {
            Iteration iteration = (Iteration)anOperation;
            List<Parameter> ownedIterators = iteration.getOwnedIterators();
            List<Parameter> ownedAccumulators = iteration.getOwnedAccumulators();
            parameterTypes = new Type[ownedIterators.size() + ownedAccumulators.size() + ownedParameters.size()];
            for (TypedElement typedElement : ownedIterators) {
                parameterTypes[iParameter++] = typedElement.getType();
            }
            for (TypedElement typedElement : ownedAccumulators) {
                parameterTypes[iParameter++] = typedElement.getType();
            }
        } else {
            parameterTypes = new Type[ownedParameters.size()];
        }
        for (TypedElement typedElement : ownedParameters) {
            parameterTypes[iParameter++] = typedElement.getType();
        }
        return parameterTypes;
    }

    @Nullable
    public static Type getPrimitiveType(@NonNull StandardLibrary standardLibrary, @NonNull PrimitiveTypeId typeId) {
        if (typeId == TypeId.BOOLEAN) {
            return standardLibrary.getBooleanType();
        }
        if (typeId == TypeId.INTEGER) {
            return standardLibrary.getIntegerType();
        }
        if (typeId == TypeId.REAL) {
            return standardLibrary.getRealType();
        }
        if (typeId == TypeId.STRING) {
            return standardLibrary.getStringType();
        }
        if (typeId == TypeId.UNLIMITED_NATURAL) {
            return standardLibrary.getUnlimitedNaturalType();
        }
        if (typeId == TypeId.OCL_ANY) {
            return standardLibrary.getOclAnyType();
        }
        if (typeId == TypeId.OCL_COMPARABLE) {
            return standardLibrary.getOclComparableType();
        }
        if (typeId == TypeId.OCL_SELF) {
            return standardLibrary.getOclSelfType();
        }
        if (typeId == TypeId.OCL_SUMMABLE) {
            return standardLibrary.getOclSummableType();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isEqualToCollectionType(@NonNull StandardLibrary standardLibrary, @NonNull CollectionType firstCollectionType, @NonNull CollectionType secondCollectionType) {
        Type secondElementType;
        Class secondContainerType;
        Class firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType()) && !firstContainerType.isEqualToUnspecializedType(standardLibrary, secondContainerType)) {
            return false;
        }
        Type firstElementType = firstCollectionType.getElementType();
        if (firstElementType != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null || secondElementType == null) {
                return false;
            }
            if (!firstElementType.isEqualTo(standardLibrary, secondElementType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEqualToMapType(@NonNull StandardLibrary standardLibrary, @NonNull MapType firstMapType, @NonNull MapType secondMapType) {
        Type secondValueType;
        Type firstValueType;
        Type secondKeyType;
        Type firstKeyType = firstMapType.getKeyType();
        if (firstKeyType != (secondKeyType = secondMapType.getKeyType())) {
            if (firstKeyType == null || secondKeyType == null) {
                return false;
            }
            if (!firstKeyType.isEqualTo(standardLibrary, secondKeyType)) {
                return false;
            }
        }
        if ((firstValueType = firstMapType.getValueType()) != (secondValueType = secondMapType.getValueType())) {
            if (firstValueType == null || secondValueType == null) {
                return false;
            }
            if (!firstValueType.isEqualTo(standardLibrary, secondValueType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEqualToTupleType(@NonNull StandardLibrary standardLibrary, @NonNull TupleType firstTupleType, @NonNull TupleType secondTupleType) {
        TupleTypeId secondParts;
        TupleTypeId firstParts = firstTupleType.getTypeId();
        return firstParts == (secondParts = secondTupleType.getTypeId());
    }

    public static CollectionKind getCollectionKind(CollectionType collectionType) {
        if (collectionType instanceof OrderedSetType) {
            return CollectionKind.ORDERED_SET;
        }
        if (collectionType instanceof SequenceType) {
            return CollectionKind.SEQUENCE;
        }
        if (collectionType instanceof SetType) {
            return CollectionKind.SET;
        }
        if (collectionType instanceof BagType) {
            return CollectionKind.BAG;
        }
        return CollectionKind.COLLECTION;
    }
}

