/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.internal.values.BagValueImpl;
import org.eclipse.ocl.pivot.internal.values.BigIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntegerRangeImpl;
import org.eclipse.ocl.pivot.internal.values.JavaObjectValueImpl;
import org.eclipse.ocl.pivot.internal.values.LongIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.MapEntryImpl;
import org.eclipse.ocl.pivot.internal.values.MapValueImpl;
import org.eclipse.ocl.pivot.internal.values.NullValueImpl;
import org.eclipse.ocl.pivot.internal.values.OrderedSetImpl;
import org.eclipse.ocl.pivot.internal.values.RangeSequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.RealValueImpl;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseOrderedSetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.TupleValueImpl;
import org.eclipse.ocl.pivot.internal.values.UnlimitedValueImpl;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.types.AbstractInheritance;
import org.eclipse.ocl.pivot.types.ParameterTypesImpl;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapEntry;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.ocl.pivot.values.ObjectValue;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.TupleValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public abstract class ValueUtil {
    @NonNull
    private static final String METAMODEL_NAME_PREFIX = "$metamodel$::";
    @NonNull
    public static final String NULL_STRING = "null";
    private static final int NEGATIVE_INTEGERS = 256;
    private static final int POSITIVE_INTEGERS = 1025;
    @NonNull
    private static final IntegerValue[] INTEGER_VALUES = new IntegerValue[1281];
    @NonNull
    public static Bag<?> EMPTY_BAG = new BagImpl();
    @NonNull
    public static final Set<Object> EMPTY_SET = Collections.emptySet();
    @NonNull
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    @NonNull
    public static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    @NonNull
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    @NonNull
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    @NonNull
    public static final Boolean FALSE_VALUE = Boolean.FALSE;
    @NonNull
    public static final InvalidValueException INVALID_VALUE = new InvalidValueException("invalid", new Object[0]);
    @NonNull
    public static final NullValue NULL_VALUE = new NullValueImpl();
    @NonNull
    public static final IntegerValue ONE_VALUE = ValueUtil.integerValueOf(1);
    @NonNull
    public static final UnlimitedNaturalValue UNLIMITED_ONE_VALUE = (UnlimitedNaturalValue)((Object)ONE_VALUE);
    @NonNull
    public static final Boolean TRUE_VALUE = Boolean.TRUE;
    @NonNull
    public static final UnlimitedValue UNLIMITED_VALUE = new UnlimitedValueImpl();
    @NonNull
    public static final IntegerValue ZERO_VALUE = ValueUtil.integerValueOf(0);
    private static boolean allStaticsInitialized = false;

    @NonNull
    public static BagValue asBagValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asBagValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Bag", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static Boolean asBoolean(@Nullable Object value) {
        if (value == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        if (value == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Boolean", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static Class asClass(@Nullable Object value) {
        if (value instanceof Class) {
            return (Class)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Class", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static CollectionType asCollectionType(@Nullable Object value) {
        if (value instanceof CollectionType) {
            return (CollectionType)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "CollectionType", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static CollectionValue asCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Collection", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static Integer asInteger(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asInteger();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static IntegerValue asIntegerValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asIntegerValue();
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return ValueUtil.integerValueOf((BigInteger)value);
            }
            return ValueUtil.integerValueOf(((Number)value).longValue());
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static MapType asMapType(@Nullable Object value) {
        if (value instanceof MapType) {
            return (MapType)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "MapType", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static MapValue asMapValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asMapValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Map", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static EObject asNavigableObject(@Nullable Object value, @NonNull Object navigation, @Nullable Evaluator evaluator) {
        Object unboxedValue;
        if (value instanceof Value) {
            return ((Value)value).asNavigableObject();
        }
        if (value instanceof EObject) {
            return (EObject)value;
        }
        if (value == null) {
            if (navigation instanceof ElementId) {
                throw new InvalidValueException(PivotMessages.NullNavigation, "source", ValueUtil.getElementIdName((ElementId)navigation));
            }
            String qualifiedName = NameUtil.qualifiedNameFor(navigation);
            int index = qualifiedName.indexOf("::");
            if (index > 0) {
                qualifiedName = qualifiedName.substring(index + 2);
            }
            throw new InvalidValueException(PivotMessages.NullNavigation, "source", qualifiedName);
        }
        if (evaluator != null && value instanceof ElementId && (unboxedValue = evaluator.getIdResolver().unboxedValueOf(value)) instanceof EObject) {
            return (EObject)unboxedValue;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "NavigableObject", ValueUtil.getTypeName(value));
    }

    @Nullable
    public static Object asObject(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asObject();
        }
        return value;
    }

    @NonNull
    public static OrderedCollectionValue asOrderedCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asOrderedCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedCollection", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static OrderedSetValue asOrderedSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asOrderedSetValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedSet", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static RealValue asRealValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asRealValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Real", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static SequenceValue asSequenceValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSequenceValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Sequence", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static SetValue asSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSetValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Set", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static String asString(@Nullable Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "String", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static TupleValue asTupleValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asTupleValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Tuple", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static Type asType(@Nullable Object value) {
        if (value instanceof Type) {
            return (Type)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Type", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static UniqueCollectionValue asUniqueCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUniqueCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UniqueCollection", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static UnlimitedNaturalValue asUnlimitedNaturalValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUnlimitedNaturalValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UnlimitedNatural", ValueUtil.getTypeName(value));
    }

    public static Object asValue(Object value) {
        if (value != null) {
            return value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OclAny", ValueUtil.getTypeName(value));
    }

    @NonNull
    public static BigDecimal bigDecimalValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigDecimal) {
            return (BigDecimal)anObject;
        }
        if (anObject instanceof Number) {
            return BigDecimal.valueOf(((Number)anObject).doubleValue());
        }
        if (anObject instanceof Character) {
            return BigDecimal.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, anObject);
    }

    @NonNull
    public static BigInteger bigIntegerValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigInteger) {
            return (BigInteger)anObject;
        }
        if (anObject instanceof Number) {
            return BigInteger.valueOf(((Number)anObject).longValue());
        }
        if (anObject instanceof Character) {
            return BigInteger.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    @NonNull
    public static Character characterValueOf(@NonNull Object anObject) {
        if (anObject instanceof Character) {
            return (Character)anObject;
        }
        if (anObject instanceof Number) {
            return Character.valueOf((char)((Number)anObject).longValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidCharacter, anObject);
    }

    @NonNull
    public static BagValue.Accumulator createBagAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new BagValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static BagValue createBagOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new BagValueImpl(typeId, BagValueImpl.createBagOfEach(boxedValues));
    }

    @NonNull
    public static BagValue createBagRange(@NonNull CollectionTypeId typeId, Object ... values) {
        BagImpl<Object> allValues = new BagImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new BagValueImpl(typeId, (Bag<? extends Object>)allValues);
    }

    @NonNull
    public static BagValue createBagValue(@NonNull CollectionTypeId typeId, @NonNull Bag<? extends Object> boxedValues) {
        return new BagValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static CollectionValue.Accumulator createCollectionAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        CollectionTypeId collectionId = collectedId.getGeneralizedId();
        if (collectionId == TypeId.BAG) {
            return new BagValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.ORDERED_SET) {
            return new SparseOrderedSetValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.SEQUENCE) {
            return new SparseSequenceValueImpl.Accumulator(collectedId);
        }
        return new SetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static InvalidValueException createInvalidValue(@NonNull Exception e) {
        if (e instanceof InvalidValueException) {
            return (InvalidValueException)e;
        }
        return new InvalidValueException(e);
    }

    @NonNull
    public static MapValue createMapOfEach(@NonNull MapTypeId typeId, MapEntry ... mapEntries) {
        return MapValueImpl.createMapValueOfEach(typeId, mapEntries);
    }

    @NonNull
    public static MapEntry createMapEntry(@NonNull Object key, @NonNull Object value) {
        return new MapEntryImpl(key, value);
    }

    @NonNull
    public static MapValue createMapValue(@NonNull TypeId keyTypeId, @NonNull TypeId valueTypeId, @NonNull Map<Object, Object> boxedValues) {
        return new MapValueImpl(TypeId.MAP.getSpecializedId(keyTypeId, valueTypeId), boxedValues);
    }

    @NonNull
    public static ObjectValue createObjectValue(@NonNull TypeId typeId, @NonNull Object object) {
        return new JavaObjectValueImpl(typeId, object);
    }

    @NonNull
    public static OrderedSetValue.Accumulator createOrderedSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseOrderedSetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static OrderedSetValue createOrderedSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, SparseOrderedSetValueImpl.createOrderedSetOfEach(boxedValues));
    }

    @NonNull
    public static OrderedSetValue createOrderedSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        OrderedSetImpl<Object> allValues = new OrderedSetImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseOrderedSetValueImpl(typeId, allValues);
    }

    @NonNull
    public static OrderedSetValue createOrderedSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static IntegerRange createRange(@NonNull IntegerValue firstInteger, @NonNull IntegerValue lastInteger) {
        return new IntegerRangeImpl(firstInteger, lastInteger);
    }

    @NonNull
    public static SequenceValue.Accumulator createSequenceAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseSequenceValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static SequenceValue createSequenceOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseSequenceValueImpl(typeId, SparseSequenceValueImpl.createSequenceOfEach(boxedValues));
    }

    @NonNull
    public static SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        return new RangeSequenceValueImpl(typeId, range);
    }

    @NonNull
    public static SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, Object ... values) {
        ArrayList<Object> allValues = new ArrayList<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseSequenceValueImpl(typeId, (List<? extends Object>)allValues);
    }

    @NonNull
    public static SequenceValue createSequenceValue(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> boxedValues) {
        return new SparseSequenceValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static SetValue.Accumulator createSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static SetValue createSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SetValueImpl(typeId, SetValueImpl.createSetOfEach(boxedValues));
    }

    @NonNull
    public static SetValue createSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        HashSet<Object> allValues = new HashSet<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SetValueImpl(typeId, allValues);
    }

    @NonNull
    public static SetValue createSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SetValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static TupleValue createTupleValue(@NonNull TupleTypeId typeId, @NonNull Map<? extends TuplePartId, Object> values) {
        return new TupleValueImpl(typeId, values);
    }

    @NonNull
    public static TupleValue createTupleOfEach(@NonNull TupleTypeId typeId, Object ... values) {
        return new TupleValueImpl(typeId, values);
    }

    @NonNull
    public static String getElementIdName(@NonNull ElementId elementId) {
        String name = elementId.toString();
        if (name.startsWith(METAMODEL_NAME_PREFIX)) {
            name = name.substring(METAMODEL_NAME_PREFIX.length());
        }
        return name;
    }

    public static String getTypeName(@Nullable Object value) {
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Value) {
            return ((Value)value).getTypeId().getDisplayName();
        }
        if (value == null) {
            return "OclVoid";
        }
        return "Object";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initAllStatics() {
        if (allStaticsInitialized) return false;
        java.lang.Class<ValueUtil> clazz = ValueUtil.class;
        synchronized (ValueUtil.class) {
            block4: {
                if (allStaticsInitialized) break block4;
                allStaticsInitialized = true;
                ParameterTypesImpl.EMPTY_LIST.getClass();
                TemplateParameters.EMPTY_LIST.getClass();
                ModelManager.NULL.getClass();
                TemplateableId.NULL_TEMPLATEABLE_ID_ARRAY.getClass();
                TypeId.INTEGER.getClass();
                AbstractInheritance.initStatics();
                UnsupportedOperation.INSTANCE.getClass();
                PivotMessages.InvalidOperation.getClass();
                new StatusCodes();
                AbstractInheritance.initStatics();
                StringUtil.createNumberFromString("0");
                StandaloneProjectMap.initStatics();
                LabelUtil.SUBSTITUTION_LABEL_PROVIDER.getClass();
                ValuesPackage.eINSTANCE.getClass();
                CollectionValueImpl.initStatics();
                RealValueImpl.initStatics();
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static IntegerValue integerValueOf(int value) {
        if (value > -256 && value < 1025) {
            int index = value + 256;
            IntegerValue integerValue = INTEGER_VALUES[index];
            if (integerValue != null) {
                return integerValue;
            }
            IntegerValue[] integerValueArray = INTEGER_VALUES;
            synchronized (INTEGER_VALUES) {
                integerValue = INTEGER_VALUES[index];
                if (integerValue != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return integerValue;
                }
                ValueUtil.INTEGER_VALUES[index] = new IntIntegerValueImpl(value);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ValueUtil.INTEGER_VALUES[index];
            }
        }
        return new IntIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return ValueUtil.integerValueOf((int)value);
        }
        return new LongIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(@Nullable BigInteger value) {
        if (value == null) {
            throw new InvalidValueException(PivotMessages.InvalidInteger, value);
        }
        if (value.signum() >= 0) {
            if (value.compareTo(INTEGER_MAX_VALUE) <= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MAX_VALUE) <= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        } else {
            if (value.compareTo(INTEGER_MIN_VALUE) >= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MIN_VALUE) >= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        }
        return new BigIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(@Nullable Object aValue) {
        if (aValue instanceof BigInteger) {
            return new BigIntegerValueImpl((BigInteger)aValue);
        }
        if (aValue instanceof Number) {
            return ValueUtil.integerValueOf(((Number)aValue).longValue());
        }
        if (aValue instanceof Character) {
            return ValueUtil.integerValueOf(((Character)aValue).charValue());
        }
        if (aValue instanceof IntegerValue) {
            return (IntegerValue)aValue;
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, aValue);
    }

    @NonNull
    public static IntegerValue integerValueOf(@NonNull String aValue) {
        try {
            int len = aValue.length();
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                BigInteger result = BigInteger.valueOf(Long.parseLong(aValue));
                return ValueUtil.integerValueOf(result);
            }
            return ValueUtil.integerValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, aValue);
        }
    }

    public static boolean isBoxed(@Nullable Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof EnumerationLiteral) {
            return false;
        }
        if (object instanceof EEnumLiteral) {
            return false;
        }
        if (object instanceof Enumerator) {
            return false;
        }
        if (object instanceof Number && !(object instanceof RealValue) && !(object instanceof UnlimitedNaturalValue)) {
            return false;
        }
        return !(object instanceof Iterable) || object instanceof CollectionValue;
    }

    @Nullable
    public static CollectionValue isCollectionValue(@Nullable Object value) {
        if (value instanceof CollectionValue && !(value instanceof NullValue)) {
            return (CollectionValue)value;
        }
        return null;
    }

    public static boolean isEcore(Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof ElementId) {
            return false;
        }
        if (object instanceof RealValue) {
            return false;
        }
        if (object instanceof CollectionValue) {
            return false;
        }
        return !(object instanceof Collection) || object instanceof List;
    }

    public static boolean isIntegerNumber(@NonNull Number aNumber) {
        return aNumber instanceof BigInteger || aNumber instanceof Long || aNumber instanceof Integer || aNumber instanceof Short || aNumber instanceof Byte;
    }

    public static IntegerValue isIntegerValue(@Nullable Object value) {
        if (value instanceof IntegerValue && !(value instanceof NullValue)) {
            return (IntegerValue)value;
        }
        return null;
    }

    public static boolean isRealNumber(@NonNull Number aNumber) {
        return aNumber instanceof BigDecimal || aNumber instanceof Double || aNumber instanceof Float;
    }

    public static boolean isUnboxed(Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof ElementId) {
            return false;
        }
        if (object instanceof RealValue) {
            return false;
        }
        return !(object instanceof CollectionValue);
    }

    public static boolean isUnlimited(@Nullable Object value) {
        return value instanceof UnlimitedValue && !(value instanceof NullValue);
    }

    @NonNull
    public static String oclToString(@NonNull Object value) {
        String result = value.toString();
        return result;
    }

    @NonNull
    public static RealValue realValueOf(double value) {
        return new RealValueImpl(value);
    }

    @NonNull
    public static RealValue realValueOf(@Nullable BigDecimal value) {
        if (value != null) {
            return new RealValueImpl(value);
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, value);
    }

    @NonNull
    public static RealValue realValueOf(@Nullable IntegerValue integerValue) {
        if (integerValue == null) {
            throw new InvalidValueException(PivotMessages.InvalidInteger, integerValue);
        }
        try {
            return ValueUtil.realValueOf(integerValue.bigDecimalValue());
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, integerValue);
        }
    }

    @NonNull
    public static RealValue realValueOf(@Nullable Number aNumber) {
        if (aNumber instanceof RealValue) {
            return (RealValue)((Object)aNumber);
        }
        if (aNumber instanceof BigDecimal) {
            return new RealValueImpl((BigDecimal)aNumber);
        }
        if (aNumber instanceof BigInteger) {
            return new RealValueImpl(new BigDecimal((BigInteger)aNumber));
        }
        if (aNumber != null) {
            return new RealValueImpl(aNumber.doubleValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, aNumber);
    }

    @NonNull
    public static RealValue realValueOf(@NonNull String aValue) {
        try {
            return new RealValueImpl(new BigDecimal(aValue.trim()));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidReal, aValue);
        }
    }

    @NonNull
    public static String stringValueOf(@Nullable Object aValue) {
        String stringValue = null;
        if (aValue == null) {
            stringValue = NULL_STRING;
        } else if (aValue instanceof String) {
            stringValue = "'" + StringUtil.convertToOCLString((String)aValue) + "'";
        } else if (aValue instanceof EObject && !(aValue instanceof Element) && !(aValue instanceof EEnumLiteral)) {
            stringValue = LabelUtil.getLabel(aValue);
        } else {
            if (aValue.getClass().isArray()) {
                throw new UnsupportedOperationException();
            }
            if (aValue instanceof Iterable) {
                throw new UnsupportedOperationException();
            }
            stringValue = String.valueOf(aValue);
        }
        return stringValue != null ? stringValue : "<<null>>";
    }

    public static boolean throwBooleanInvalidValueException(@NonNull String string) {
        throw new InvalidValueException(string, new Object[0]);
    }

    public static Object throwInvalidValueException() {
        throw new InvalidValueException("invalid", new Object[0]);
    }

    public static int throwUnsupportedCompareTo(@Nullable Object left, @Nullable Object right) {
        throw new InvalidValueException(PivotMessages.UnsupportedCompareTo, left != null ? left.getClass().getName() : NULL_STRING, right != null ? right.getClass().getName() : NULL_STRING);
    }

    public static void toString(@Nullable Object value, @NonNull StringBuilder s, int sizeLimit) {
        if (value instanceof Value) {
            ((Value)value).toString(s, sizeLimit);
        } else if (value instanceof String) {
            s.append("'");
            ValueUtil.toStringWithLimit(s, (String)value, sizeLimit);
            s.append("'");
        } else if (value != null) {
            ValueUtil.toStringWithLimit(s, value.toString(), sizeLimit);
        } else {
            ValueUtil.toStringWithLimit(s, NULL_STRING, sizeLimit);
        }
    }

    private static void toStringWithLimit(@NonNull StringBuilder s, String string, int sizeLimit) {
        int available;
        int length = string.length();
        if (length <= (available = sizeLimit - (length + 1))) {
            s.append(string);
        } else {
            if (available > 0) {
                s.append(string.substring(0, available));
            }
            s.append("...");
        }
    }

    @NonNull
    public static UnlimitedNaturalValue unlimitedNaturalValueOf(@Nullable BigInteger value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    @NonNull
    public static UnlimitedNaturalValue unlimitedNaturalValueOf(int value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    @NonNull
    public static UnlimitedNaturalValue unlimitedNaturalValueOf(long value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    @NonNull
    public static UnlimitedNaturalValue unlimitedNaturalValueOf(@Nullable Object aValue) {
        if (aValue instanceof BigInteger) {
            return new BigIntegerValueImpl((BigInteger)aValue);
        }
        if (aValue instanceof Unlimited) {
            return UNLIMITED_VALUE;
        }
        if (aValue instanceof Number) {
            return ValueUtil.unlimitedNaturalValueOf(((Number)aValue).longValue());
        }
        if (aValue instanceof Character) {
            return ValueUtil.unlimitedNaturalValueOf(((Character)aValue).charValue());
        }
        if (aValue instanceof UnlimitedNaturalValue) {
            return (UnlimitedNaturalValue)aValue;
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, aValue);
    }

    @NonNull
    public static UnlimitedNaturalValue unlimitedNaturalValueOf(@NonNull String aValue) {
        try {
            int len = aValue.length();
            if (len == 1 && "*".equals(aValue)) {
                return UNLIMITED_VALUE;
            }
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                BigInteger result = BigInteger.valueOf(Long.parseLong(aValue));
                return ValueUtil.unlimitedNaturalValueOf(result);
            }
            return ValueUtil.unlimitedNaturalValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, aValue);
        }
    }
}

