/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.ValidityUtils;

public final class RunValidityAction
extends Action {
    @NonNull
    protected final ValidityView validityView;
    @Nullable
    protected final ISelectionProvider selectionProvider;

    public RunValidityAction(@NonNull ValidityView validityView, @Nullable ISelectionProvider selectionProvider) {
        super(ValidityUIMessages.ValidityView_Action_RunValidity_Title);
        this.validityView = validityView;
        this.selectionProvider = selectionProvider;
        this.setToolTipText(ValidityUIMessages.ValidityView_Action_RunValidity_ToolTipText);
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_RunValidity_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
    }

    public void run() {
        ISelection selection;
        HashSet<ResultConstrainingNode> selectedNodes = null;
        ISelectionProvider selectionProvider2 = this.selectionProvider;
        if (selectionProvider2 != null && (selection = selectionProvider2.getSelection()) instanceof StructuredSelection) {
            selectedNodes = new HashSet<ResultConstrainingNode>();
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof ConstrainingNode) {
                List enabledResultConstrainingNodes = ValidityUtils.getEnabledResultConstrainingNodes((ConstrainingNode)((ConstrainingNode)selectedObject));
                selectedNodes.addAll(enabledResultConstrainingNodes);
            } else if (selectedObject instanceof ValidatableNode) {
                List enabledResultValidatableNodes = ValidityUtils.getEnabledResultValidatableNodes((ValidatableNode)((ValidatableNode)selectedObject));
                for (ResultValidatableNode enabledResultValidatableNode : enabledResultValidatableNodes) {
                    selectedNodes.add(enabledResultValidatableNode.getResultConstrainingNode());
                }
            }
        }
        this.validityView.getValidityManager().runValidation(this.validityView, selectedNodes);
    }
}

