/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.validation;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class CompleteOCLEObjectValidator
extends PivotEObjectValidator {
    private static final Logger logger = Logger.getLogger(CompleteOCLEObjectValidator.class);
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final EPackage ePackage;
    @NonNull
    protected final URI oclURI;
    private Ecore2AS ecore2as = null;

    public CompleteOCLEObjectValidator(@NonNull EPackage ePackage, @NonNull URI oclURI, @NonNull EnvironmentFactory environmentFactory) {
        super(null);
        this.environmentFactory = (EnvironmentFactoryInternal)environmentFactory;
        this.ePackage = ePackage;
        this.oclURI = oclURI;
        ResourceSet resourceSet = ePackage.eResource().getResourceSet();
        if (resourceSet != null) {
            CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (EnvironmentFactoryInternal)this.environmentFactory);
        } else {
            this.environmentFactory.loadEPackage(ePackage);
        }
    }

    protected EPackage getEPackage() {
        return this.ePackage;
    }

    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public boolean initialize() {
        Resource ecoreResource = this.ePackage.eResource();
        if (ecoreResource == null) {
            return false;
        }
        this.ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)this.environmentFactory);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.environmentFactory.adapt((Notifier)resourceSet);
        EList errors = ecoreResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Ecore '" + ecoreResource.getURI() + message));
            return false;
        }
        Model pivotModel = this.ecore2as.getASModel();
        errors = pivotModel.eResource().getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + ecoreResource.getURI() + message));
            return false;
        }
        CSResource xtextResource = null;
        try {
            xtextResource = (CSResource)resourceSet.getResource(this.oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && this.oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)this.oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (CSResource)resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        errors = xtextResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + this.oclURI + message));
            return false;
        }
        ASResource asResource = xtextResource.getASResource();
        errors = asResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + this.oclURI + message));
            return false;
        }
        return true;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.ecore2as == null && object instanceof EObject) {
            ResourceSet resourceSet;
            this.initialize();
            Resource eResource = ((EObject)object).eResource();
            if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
                CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (EnvironmentFactoryInternal)this.environmentFactory);
            }
        }
        return super.validatePivot(eClassifier, object, diagnostics, context);
    }
}

