/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.attributes;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.osgi.util.NLS;

public class ImportCSAttribution
extends AbstractAttribution
implements CS2AS.UnresolvedProxyMessageProvider {
    public static final ImportCSAttribution INSTANCE = new ImportCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        ImportCS targetElement = (ImportCS)target;
        ImportAdapter adapter = (ImportAdapter)((Object)ClassUtil.getAdapter(ImportAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new ImportAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    @Override
    @NonNull
    public EReference getEReference() {
        EReference importCsNamespace = BaseCSPackage.Literals.IMPORT_CS__REFERRED_NAMESPACE;
        return importCsNamespace;
    }

    @Override
    @Nullable
    public String getMessage(@NonNull EObject context, @NonNull String linkText) {
        ImportAdapter adapter = (ImportAdapter)((Object)ClassUtil.getAdapter(ImportAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class ImportAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private ImportAdapter() {
        }

        public ScopeView computeLookup(ImportCS targetElement, EnvironmentView environmentView, ScopeView scopeView) {
            String name = environmentView.getName();
            if (name != null) {
                EList errors;
                Resource importedResource;
                this.importModel(targetElement, environmentView);
                Element importedElement2 = this.importedElement;
                if (importedElement2 != null && (importedResource = importedElement2.eResource()) != null && (errors = importedResource.getErrors()).size() == 0) {
                    environmentView.addElement(name, importedElement2);
                }
            } else {
                Map ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                for (String key : ePackageNsURIToGenModelLocationMap.keySet()) {
                    environmentView.addElement(key, (Element)environmentView.getStandardLibrary().getOclVoidType());
                }
            }
            return null;
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.toString() : null;
        }

        protected void importModel(ImportCS target, EnvironmentView environmentView) {
            URI uri2;
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            EnvironmentFactoryInternal environmentFactory = environmentView.getEnvironmentFactory();
            CompletePackageInternal completePackage = environmentFactory.getCompleteModel().getCompletePackageByURI(name);
            if (completePackage != null) {
                Package pivotPackage = completePackage.getPrimaryPackage();
                if (pivotPackage != this.importedElement) {
                    this.importedElement = pivotPackage;
                    this.throwable = null;
                }
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                newURI = csResource.resolve(newURI);
                if (newURI.equals(this.uri)) {
                    return;
                }
                uri2 = this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            try {
                this.importedElement = environmentFactory.getMetamodelManager().loadResource(uri2, target.getName(), null);
                Resource importedResource = this.importedElement.eResource();
                if (importedResource != null) {
                    EList errors = importedResource.getErrors();
                    if (errors.size() > 0) {
                        String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInURI, (Object[])new Object[]{this.uri}), (String)"\n\t");
                        throw new IOException(errorMessage);
                    }
                    EList warnings = importedResource.getWarnings();
                    if (warnings.size() > 0) {
                        String warningMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)StringUtil.bind((String)PivotMessagesInternal.WarningsInURI, (Object[])new Object[]{uri2}), (String)"\n\t");
                        throw new IOException(warningMessage);
                    }
                }
            }
            catch (WrappedException e) {
                e.fillInStackTrace();
                this.throwable = e.exception();
            }
            catch (Throwable e) {
                e.fillInStackTrace();
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == ImportAdapter.class;
        }
    }
}

