/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.cs2as;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.executor.ExecutorTuplePart;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.cs2as.Continuations;
import org.eclipse.ocl.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.xtext.base.cs2as.PivotDependency;
import org.eclipse.ocl.xtext.base.cs2as.PivotHasSuperClassesDependency;
import org.eclipse.ocl.xtext.base.cs2as.SingleContinuation;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.AnnotationCS;
import org.eclipse.ocl.xtext.basecs.ClassCS;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.DataTypeCS;
import org.eclipse.ocl.xtext.basecs.DocumentationCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.EnumerationCS;
import org.eclipse.ocl.xtext.basecs.EnumerationLiteralCS;
import org.eclipse.ocl.xtext.basecs.LambdaTypeCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementRefCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityBoundsCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityStringCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.OperationCS;
import org.eclipse.ocl.xtext.basecs.PackageCS;
import org.eclipse.ocl.xtext.basecs.PackageOwnerCS;
import org.eclipse.ocl.xtext.basecs.ParameterCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.PivotableElementCS;
import org.eclipse.ocl.xtext.basecs.PrimitiveTypeRefCS;
import org.eclipse.ocl.xtext.basecs.StructuralFeatureCS;
import org.eclipse.ocl.xtext.basecs.StructuredClassCS;
import org.eclipse.ocl.xtext.basecs.TemplateBindingCS;
import org.eclipse.ocl.xtext.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.xtext.basecs.TemplateSignatureCS;
import org.eclipse.ocl.xtext.basecs.TemplateableElementCS;
import org.eclipse.ocl.xtext.basecs.TuplePartCS;
import org.eclipse.ocl.xtext.basecs.TupleTypeCS;
import org.eclipse.ocl.xtext.basecs.TypeParameterCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.basecs.TypedElementCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.basecs.WildcardTypeRefCS;
import org.eclipse.ocl.xtext.basecs.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.xtext.basecs.util.VisitableCS;

public class BaseCSPreOrderVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2ASConversion> {
    public BaseCSPreOrderVisitor(@NonNull CS2ASConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visiting(@NonNull VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2AS PreOrder pass");
    }

    @Override
    public Continuation<?> visitAnnotationCS(@NonNull AnnotationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csConstraint) {
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(@NonNull DataTypeCS csDataType) {
        DataType pivotElement = (DataType)PivotUtil.getPivot(DataType.class, (Pivotable)csDataType);
        if (pivotElement != null) {
            List pivotSuperClasses = pivotElement.getSuperClasses();
            pivotSuperClasses.clear();
            Class oclElementType = ((CS2ASConversion)((Object)this.context)).getStandardLibrary().getOclElementType();
            pivotSuperClasses.add(oclElementType);
        }
        return null;
    }

    @Override
    public Continuation<?> visitDocumentationCS(@NonNull DocumentationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(@NonNull EnumerationCS csEnumeration) {
        Enumeration pivotElement = (Enumeration)PivotUtil.getPivot(Enumeration.class, (Pivotable)csEnumeration);
        if (pivotElement != null) {
            List pivotSuperClasses = pivotElement.getSuperClasses();
            pivotSuperClasses.clear();
            Class oclElementType = ((CS2ASConversion)((Object)this.context)).getStandardLibrary().getOclElementType();
            pivotSuperClasses.add(oclElementType);
        }
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(@NonNull EnumerationLiteralCS csEnumerationLiteral) {
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(@NonNull LambdaTypeCS csLambdaType) {
        return new LambdaContinuation((CS2ASConversion)((Object)this.context), csLambdaType);
    }

    @Override
    public Continuation<?> visitModelElementCS(@NonNull ModelElementCS csModelElement) {
        return null;
    }

    @Override
    public Continuation<?> visitModelElementRefCS(@NonNull ModelElementRefCS csModelElementRef) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityBoundsCS(@NonNull MultiplicityBoundsCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityStringCS(@NonNull MultiplicityStringCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(@NonNull OperationCS csOperation) {
        return null;
    }

    @Override
    public Continuation<?> visitPackageCS(@NonNull PackageCS csPackage) {
        return null;
    }

    @Override
    public Continuation<?> visitPackageOwnerCS(@NonNull PackageOwnerCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitParameterCS(@NonNull ParameterCS csParameter) {
        return new ParameterContinuation((CS2ASConversion)((Object)this.context), csParameter);
    }

    @Override
    public Continuation<?> visitPathElementCS(@NonNull PathElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPathNameCS(@NonNull PathNameCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(@NonNull PrimitiveTypeRefCS csPrimitiveTypeRef) {
        return new PrimitiveTypeRefContinuation((CS2ASConversion)((Object)this.context), csPrimitiveTypeRef);
    }

    @Override
    public Continuation<?> visitStructuredClassCS(@NonNull StructuredClassCS csClass) {
        Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csClass);
        if (pivotElement == null) {
            return null;
        }
        Continuations continuations = new Continuations();
        if (csClass.getOwnedSignature() != null) {
            continuations.add(new TemplateSignatureContinuation((CS2ASConversion)((Object)this.context), (NamedElement)pivotElement, csClass));
        } else {
            pivotElement.setOwnedSignature(null);
        }
        if (!(pivotElement instanceof AnyType)) {
            continuations.add(new ClassSupersContinuation((CS2ASConversion)((Object)this.context), pivotElement, csClass));
        }
        return continuations.getContinuation();
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(@NonNull StructuralFeatureCS csStructuralFeature) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(@NonNull TemplateBindingCS csTemplateBinding) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(@NonNull TemplateSignatureCS csTemplateSignature) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(@NonNull TupleTypeCS csTupleType) {
        return new TupleContinuation((CS2ASConversion)((Object)this.context), csTupleType);
    }

    @Override
    public Continuation<?> visitTypeParameterCS(@NonNull TypeParameterCS csTypeParameter) {
        TemplateParameter pivotElement = (TemplateParameter)PivotUtil.getPivot(TemplateParameter.class, (Pivotable)csTypeParameter);
        if (pivotElement == null) {
            return null;
        }
        if (csTypeParameter.getOwnedExtends().size() > 0) {
            return new TypeParameterContinuation((CS2ASConversion)((Object)this.context), csTypeParameter);
        }
        pivotElement.getConstrainingClasses().clear();
        return null;
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(@NonNull TypedTypeRefCS csTypedTypeRef) {
        if (csTypedTypeRef.getOwnedBinding() == null) {
            return new UnspecializedTypeRefContinuation((CS2ASConversion)((Object)this.context), csTypedTypeRef);
        }
        return new SpecializedTypeRefContinuation1((CS2ASConversion)((Object)this.context), csTypedTypeRef);
    }

    @Override
    public Continuation<?> visitWildcardTypeRefCS(@NonNull WildcardTypeRefCS csWildcardTypeRef) {
        return null;
    }

    protected static class ClassSupersContinuation
    extends SingleContinuation<StructuredClassCS> {
        private static Dependency[] computeDependencies(@NonNull CS2ASConversion context, @NonNull StructuredClassCS csElement) {
            EList<TypedRefCS> csSuperTypes = csElement.getOwnedSuperTypes();
            if (csSuperTypes.isEmpty()) {
                return null;
            }
            ArrayList<PivotDependency> dependencies = new ArrayList<PivotDependency>();
            for (TypedRefCS csSuperType : csSuperTypes) {
                dependencies.add(new PivotDependency(csSuperType));
            }
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public ClassSupersContinuation(@NonNull CS2ASConversion context, Class pivotParent, @NonNull StructuredClassCS csElement) {
            super(context, (Element)pivotParent, null, csElement, ClassSupersContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)((Pivotable)this.csElement));
            if (pivotElement != null) {
                List superClasses = pivotElement.getSuperClasses();
                this.context.refreshList(Class.class, superClasses, (List<? extends PivotableElementCS>)((StructuredClassCS)this.csElement).getOwnedSuperTypes());
                if (superClasses.isEmpty()) {
                    Class oclElementType = this.context.getStandardLibrary().getOclElementType();
                    pivotElement.getSuperClasses().add(oclElementType);
                }
            }
            return null;
        }
    }

    protected static class LambdaContinuation
    extends SingleContinuation<LambdaTypeCS> {
        private static Dependency[] computeDependencies(@NonNull CS2ASConversion context, @NonNull LambdaTypeCS csElement) {
            TypedRefCS ownedContextType = (TypedRefCS)ClassUtil.nonNullState((Object)csElement.getOwnedContextType());
            TypedRefCS ownedResultType = (TypedRefCS)ClassUtil.nonNullState((Object)csElement.getOwnedResultType());
            EList<TypedRefCS> csParameterTypes = csElement.getOwnedParameterTypes();
            int iMax = csParameterTypes.size();
            Dependency[] dependencies = new Dependency[2 + iMax];
            dependencies[0] = context.createTypeIsReferenceableDependency(ownedContextType);
            dependencies[1] = context.createTypeIsReferenceableDependency(ownedResultType);
            int i = 0;
            while (i < iMax) {
                TypedRefCS csParameterType = (TypedRefCS)ClassUtil.nonNullState((Object)((TypedRefCS)csParameterTypes.get(i)));
                dependencies[i + 2] = context.createTypeIsReferenceableDependency(csParameterType);
                ++i;
            }
            return dependencies;
        }

        public LambdaContinuation(@NonNull CS2ASConversion context, @NonNull LambdaTypeCS csElement) {
            super(context, null, null, csElement, LambdaContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Type contextType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedContextType());
            Type resultType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedResultType());
            String name = ((LambdaTypeCS)this.csElement).getName();
            if (contextType != null && resultType != null && name != null) {
                ArrayList<Type> parameterTypes = new ArrayList<Type>();
                for (TypedRefCS csParameterType : ((LambdaTypeCS)this.csElement).getOwnedParameterTypes()) {
                    Type parameterType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csParameterType);
                    parameterTypes.add(parameterType);
                }
                LambdaType lambdaType = this.context.getMetamodelManager().getCompleteModel().getLambdaType(name, contextType, parameterTypes, resultType, null);
                this.context.installPivotTypeWithMultiplicity((Type)lambdaType, (TypedRefCS)this.csElement);
            }
            return null;
        }
    }

    protected static abstract class OperatorExpContinuation<T extends NamedElementCS>
    extends SingleContinuation<T> {
        public OperatorExpContinuation(@NonNull CS2ASConversion context, @NonNull T csElement) {
            super(context, null, null, csElement, new Dependency[0]);
            context.getOperatorsHavePrecedenceInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            this.context.getOperatorsHavePrecedenceInterDependency().setSatisfied(this);
            return null;
        }
    }

    protected static class ParameterContinuation
    extends SingleContinuation<ParameterCS> {
        public ParameterContinuation(@NonNull CS2ASConversion context, @NonNull ParameterCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            Element pivot;
            if (!super.canExecute()) {
                return false;
            }
            TypedRefCS ownedType = ((ParameterCS)this.csElement).getOwnedType();
            Element element = pivot = ownedType != null ? ownedType.getPivot() : null;
            return pivot != null;
        }

        @Override
        public BasicContinuation<?> execute() {
            Parameter parameter = (Parameter)PivotUtil.getPivot(Parameter.class, (Pivotable)((Pivotable)this.csElement));
            if (parameter != null) {
                this.context.refreshRequiredType((TypedElement)parameter, (TypedElementCS)this.csElement);
                TypedRefCS ownedType = ((ParameterCS)this.csElement).getOwnedType();
                boolean isTypeof = false;
                if (ownedType instanceof TypedTypeRefCS) {
                    isTypeof = ((TypedTypeRefCS)ownedType).isIsTypeof();
                }
                parameter.setIsTypeof(isTypeof);
            }
            return null;
        }
    }

    protected static class PrimitiveTypeRefContinuation
    extends TypedRefContinuation<PrimitiveTypeRefCS> {
        public PrimitiveTypeRefContinuation(@NonNull CS2ASConversion context, @NonNull PrimitiveTypeRefCS csElement) {
            super(context, csElement, new Dependency[0]);
        }

        @Override
        public BasicContinuation<?> execute() {
            String name = ((PrimitiveTypeRefCS)this.csElement).getName();
            if (name != null) {
                Class pivotType = this.context.getStandardLibrary().getLibraryType(name);
                this.context.installPivotTypeWithMultiplicity((Type)pivotType, (TypedRefCS)this.csElement);
            }
            return null;
        }
    }

    protected static class SpecializedTypeRefContinuation1
    extends SingleContinuation<TypedTypeRefCS> {
        public SpecializedTypeRefContinuation1(@NonNull CS2ASConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, null, null, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedBinding() != null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getReferredType();
            return new SpecializedTypeRefContinuation2(this.context, (TypedTypeRefCS)this.csElement);
        }
    }

    protected static class SpecializedTypeRefContinuation2
    extends TypedRefContinuation<TypedTypeRefCS> {
        private static Dependency[] computeDependencies(@NonNull CS2ASConversion context, @NonNull TypedTypeRefCS csElement) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            TemplateBindingCS csTemplateBinding = csElement.getOwnedBinding();
            if (csTemplateBinding != null) {
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedSubstitutions()) {
                    Dependency dependency;
                    TypeRefCS csTemplateParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    if (csTemplateParameter == null || (dependency = context.createTypeIsReferenceableDependency(csTemplateParameter)) == null) continue;
                    dependencies.add(dependency);
                }
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedSubstitutions()) {
                    TypeRefCS csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    dependencies.add(new PivotDependency(csActualParameter));
                }
            }
            dependencies.add(new PivotHasSuperClassesDependency(csElement));
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public SpecializedTypeRefContinuation2(@NonNull CS2ASConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, csElement, SpecializedTypeRefContinuation2.computeDependencies(context, csElement));
            assert (csElement.getOwnedBinding() != null);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            if (this.context.isInReturnTypeWithUnresolvedParameters((ElementCS)this.csElement)) {
                return false;
            }
            Type pivotType = ((TypedTypeRefCS)this.csElement).getReferredType();
            if (pivotType instanceof Class) {
                if (((Class)pivotType).getSuperClasses().size() <= 0) {
                    return false;
                }
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedBinding();
                if (csTemplateBinding != null) {
                    for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedSubstitutions()) {
                        TypeRefCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                        if (ownedActualParameter instanceof WildcardTypeRefCS) {
                            return true;
                        }
                        Type actualParameterClass = (Type)ownedActualParameter.getPivot();
                        if (actualParameterClass != null) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getReferredType();
            if (pivotType != null) {
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedBinding();
                if (csTemplateBinding != null && ElementUtil.isSpecialization(csTemplateBinding)) {
                    pivotType = (Type)this.context.specializeTemplates((TypedTypeRefCS)this.csElement);
                }
                if (pivotType != null) {
                    this.context.installPivotTypeWithMultiplicity(pivotType, (TypedRefCS)this.csElement);
                }
            }
            return null;
        }
    }

    protected static class TemplateSignatureContinuation
    extends SingleContinuation<ClassCS> {
        public TemplateSignatureContinuation(@NonNull CS2ASConversion context, NamedElement pivotParent, @NonNull ClassCS csElement) {
            super(context, (Element)pivotParent, (EStructuralFeature)PivotPackage.Literals.TEMPLATEABLE_ELEMENT__OWNED_SIGNATURE, csElement, new Dependency[0]);
            context.getTypesHaveSignaturesInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((Pivotable)this.csElement));
            if (pivotElement != null) {
                if (pivotElement instanceof TemplateableElement) {
                    this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotElement);
                }
                this.context.getTypesHaveSignaturesInterDependency().setSatisfied(this);
            }
            return null;
        }
    }

    protected static class TupleContinuation
    extends TypedRefContinuation<TupleTypeCS> {
        public TupleContinuation(@NonNull CS2ASConversion context, @NonNull TupleTypeCS csElement) {
            super(context, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                TypedRefCS ownedType = csTuplePart.getOwnedType();
                Element pivot = ownedType.getPivot();
                if (pivot != null) continue;
                return false;
            }
            return !this.context.isInReturnTypeWithUnresolvedParameters((ElementCS)this.csElement);
        }

        @Override
        public BasicContinuation<?> execute() {
            String name = ((TupleTypeCS)this.csElement).getName();
            if (name != null) {
                ArrayList<ExecutorTuplePart> parts = new ArrayList<ExecutorTuplePart>();
                for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                    Type partType;
                    String partName = csTuplePart.getName();
                    if (partName == null || (partType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTuplePart.getOwnedType())) == null) continue;
                    parts.add(new ExecutorTuplePart(partType, partName));
                }
                TupleType tupleType = this.context.getMetamodelManager().getCompleteModel().getTupleType(name, parts, null);
                this.context.installPivotTypeWithMultiplicity((Type)tupleType, (TypedRefCS)this.csElement);
                List tupleParts = tupleType.getOwnedProperties();
                for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                    String partName = csTuplePart.getName();
                    Property tuplePart = (Property)NameUtil.getNameable((Iterable)tupleParts, (String)partName);
                    if (tuplePart == null) continue;
                    this.context.installPivotUsage(csTuplePart, (Element)tuplePart);
                }
            }
            return null;
        }
    }

    protected static class TypeParameterContinuation
    extends SingleContinuation<TypeParameterCS> {
        public TypeParameterContinuation(@NonNull CS2ASConversion context, @NonNull TypeParameterCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TypedRefCS csExtend : ((TypeParameterCS)this.csElement).getOwnedExtends()) {
                Class asExtend = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csExtend);
                if (asExtend != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            TemplateParameter pivotElement = (TemplateParameter)PivotUtil.getPivot(TemplateParameter.class, (Pivotable)((Pivotable)this.csElement));
            if (pivotElement != null) {
                EList<TypedRefCS> csExtends = ((TypeParameterCS)this.csElement).getOwnedExtends();
                ArrayList<Class> asExtends = new ArrayList<Class>();
                for (TypedRefCS csExtend : csExtends) {
                    Class asExtend = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csExtend);
                    if (asExtend == null) continue;
                    asExtends.add(asExtend);
                }
                PivotUtilInternal.refreshList((List)pivotElement.getConstrainingClasses(), asExtends);
            }
            return null;
        }
    }

    protected static abstract class TypedRefContinuation<T extends TypedRefCS>
    extends SingleContinuation<T> {
        public TypedRefContinuation(@NonNull CS2ASConversion context, @NonNull T csElement, Dependency ... dependencies) {
            super(context, null, null, csElement, new Dependency[0]);
        }
    }

    protected static class UnspecializedTypeRefContinuation
    extends TypedRefContinuation<TypedTypeRefCS> {
        public UnspecializedTypeRefContinuation(@NonNull CS2ASConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedBinding() == null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getReferredType();
            this.context.installPivotTypeWithMultiplicity(pivotType, (TypedRefCS)this.csElement);
            return null;
        }
    }
}

