/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.ConditionChecker;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationVisitor;
import org.eclipse.ocl.pivot.Element;

public class VMBreakpoint {
    private final long fID;
    @NonNull
    private final String fTargetURI;
    private final int fLineNumber;
    private final int fHitCount;
    @NonNull
    private final Element fElement;
    private final boolean fIsTemporary;
    @Nullable
    private final String fConditionBody;
    private int fCurrentHitCount;
    private boolean fConditionEnabled;
    private boolean fConditionSuspendOnTrue;
    private boolean fLastValue;
    private ConditionChecker fChecker;

    public VMBreakpoint(@NonNull Element element, @NonNull VMNewBreakpointData data, boolean isTemporary) {
        this.fID = data.getID();
        this.fTargetURI = data.getTargetURI();
        this.fElement = element;
        this.fLineNumber = data.getLine();
        this.fIsTemporary = isTemporary;
        this.fHitCount = data.getHitCount();
        this.fCurrentHitCount = 0;
        this.fConditionBody = data.getCondition();
        this.fConditionEnabled = data.getConditionEnabled();
        this.fConditionSuspendOnTrue = data.getConditionSuspendOnTrue();
    }

    public VMBreakpoint(@NonNull Element element, long id, int line, @NonNull String targetURI, boolean isTemporary) {
        this.fID = id;
        this.fTargetURI = targetURI;
        this.fElement = element;
        this.fLineNumber = line;
        this.fIsTemporary = isTemporary;
        this.fHitCount = 0;
        this.fCurrentHitCount = 0;
        this.fConditionBody = null;
        this.fConditionEnabled = false;
        this.fConditionSuspendOnTrue = false;
    }

    @NonNull
    public String getUri() {
        return this.fTargetURI;
    }

    public long getID() {
        return this.fID;
    }

    @NonNull
    public Element getElement() {
        return this.fElement;
    }

    public boolean isTemporary() {
        return this.fIsTemporary;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getHitCount() {
        return this.fCurrentHitCount;
    }

    public boolean expired() {
        return this.fHitCount > 0 && this.fCurrentHitCount >= this.fHitCount;
    }

    public boolean hitAndCheckIfTriggered(@NonNull IVMEvaluationVisitor visitor) throws CoreException {
        if (this.expired()) {
            return false;
        }
        if (!(this.fConditionBody == null || this.fConditionEnabled && this.checkCondition(visitor))) {
            return false;
        }
        if (this.fHitCount > 0) {
            return ++this.fCurrentHitCount == this.fHitCount;
        }
        return true;
    }

    private boolean checkCondition(@NonNull IVMEvaluationVisitor visitor) throws CoreException {
        String fConditionBody2 = this.fConditionBody;
        if (this.fChecker == null && fConditionBody2 != null) {
            this.fChecker = new ConditionChecker(fConditionBody2, this.fElement);
        }
        boolean prevValue = this.fLastValue;
        this.fLastValue = this.fChecker.checkCondition(visitor);
        if (this.fConditionSuspendOnTrue) {
            return this.fLastValue;
        }
        return this.fLastValue == prevValue;
    }

    public String toString() {
        return "VM Breakpoint:" + this.fLineNumber + ", isTemp:" + this.fIsTemporary;
    }
}

