/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitManager;
import org.eclipse.ocl.examples.debug.vm.VMBreakpoint;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.data.VMBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.pivot.Element;

public class VMBreakpointManager {
    @NonNull
    protected final VMVirtualMachine vmVirtualMachine;
    @NonNull
    private final UnitManager fUnitManager;
    @NonNull
    private final Map<EObject, VMBreakpoint> fElement2Breakpoint = new HashMap<EObject, VMBreakpoint>();
    private long fPrivateBreakpointID = 0L;

    public VMBreakpointManager(@NonNull VMVirtualMachine vmVirtualMachine, @Nullable CompiledUnit mainUnit) {
        if (mainUnit == null) {
            throw new IllegalArgumentException("null main unit");
        }
        this.vmVirtualMachine = vmVirtualMachine;
        this.fUnitManager = new UnitManager(mainUnit);
    }

    @NonNull
    public VMDebugCore getDebugCore() {
        return this.vmVirtualMachine.getDebugCore();
    }

    @NonNull
    public UnitManager getUnitManager() {
        return this.fUnitManager;
    }

    @NonNull
    public synchronized List<VMBreakpoint> getBreakpoints(Element e) {
        VMBreakpoint breakpoint = this.fElement2Breakpoint.get(e);
        return breakpoint != null ? Collections.singletonList(breakpoint) : Collections.emptyList();
    }

    @Nullable
    public synchronized VMBreakpoint createBreakpoint(VMNewBreakpointData data) {
        int line;
        Element targetElement;
        URI uri = URI.createURI((String)data.getTargetURI());
        if (uri.isPlatformResource() && this.isPlatformDeployed()) {
            uri = URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)true);
        }
        if (this.fUnitManager.getCompiledModule(uri) == null) {
            uri = URI.createURI((String)URI.decode((String)uri.toString()));
        }
        if ((targetElement = this.getBreakpointableElement(uri, line = data.getLine())) == null) {
            return null;
        }
        VMBreakpoint vmBreakpoint = new VMBreakpoint(targetElement, data, false);
        this.fElement2Breakpoint.put((EObject)targetElement, vmBreakpoint);
        return vmBreakpoint;
    }

    @NonNull
    public synchronized VMBreakpoint createVMPrivateBreakpoint(URI unitURI, @NonNull Element element, int line, boolean isTemporary) throws CoreException {
        String string = unitURI.toString();
        VMBreakpoint breakpoint = new VMBreakpoint(element, --this.fPrivateBreakpointID, line, string, isTemporary);
        this.fElement2Breakpoint.put((EObject)element, breakpoint);
        return breakpoint;
    }

    public synchronized VMBreakpoint[] getAllBreakpoints() {
        return this.fElement2Breakpoint.values().toArray(new VMBreakpoint[this.fElement2Breakpoint.size()]);
    }

    public synchronized Element getBreakpointableElement(@NonNull URI targetURI, int lineNumber) {
        LineNumberProvider lineNumberProvider = this.fUnitManager.getLineNumberProvider(targetURI);
        if (lineNumberProvider == null) {
            return null;
        }
        CompiledUnit unit = this.fUnitManager.getCompiledModule(targetURI);
        if (unit == null) {
            return null;
        }
        List<Element> elements = this.vmVirtualMachine.getRunnerFactory().getValidBreakpointLocator().getBreakpointableElementsForLine(unit, lineNumberProvider, lineNumber);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public boolean removeBreakpoint(@NonNull VMBreakpoint breakpoint) {
        return this.removeBreakpoint(breakpoint.getID());
    }

    public synchronized boolean removeBreakpoint(long breakpointID) {
        for (Map.Entry<EObject, VMBreakpoint> entry : this.fElement2Breakpoint.entrySet()) {
            VMBreakpoint next = entry.getValue();
            if (breakpointID != next.getID()) continue;
            this.fElement2Breakpoint.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public synchronized boolean changeBreakpoint(long breakpointID, @Nullable VMBreakpointData data) {
        VMNewBreakpointData newBreakpointData = null;
        for (Map.Entry<EObject, VMBreakpoint> entry : this.fElement2Breakpoint.entrySet()) {
            VMBreakpoint next = entry.getValue();
            if (breakpointID != next.getID()) continue;
            this.fElement2Breakpoint.remove(entry.getKey());
            if (data == null) break;
            newBreakpointData = new VMNewBreakpointData(data, breakpointID, next.getLineNumber(), next.getUri());
            break;
        }
        if (newBreakpointData != null) {
            this.createBreakpoint(newBreakpointData);
            return true;
        }
        return false;
    }

    private boolean isPlatformDeployed() {
        CompiledUnit mainUnit = this.getUnitManager().getMainUnit();
        return mainUnit.getURI().isPlatformPlugin();
    }
}

