/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.BreakpointError;
import org.eclipse.ocl.examples.debug.vm.IVMVirtualMachineShell;
import org.eclipse.ocl.examples.debug.vm.VMEventListener;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMThread;
import org.eclipse.ocl.examples.debug.vm.core.VMVirtualProcess;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMSuspension;
import org.eclipse.ocl.examples.debug.vm.event.VMDisconnectEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMResumeEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMStartEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMSuspendEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMTerminateEvent;
import org.eclipse.ocl.examples.debug.vm.request.VMBreakpointRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMResumeRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMStartRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMSuspendRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMTerminateRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMBreakpointResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.utils.DebugOptions;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class VMDebugTarget
extends VMDebugElement
implements IVMDebugTarget,
IDebugEventSetListener,
IBreakpointManagerListener {
    private final Map<Long, VMLineBreakpoint> fID2Breakpoint = new HashMap<Long, VMLineBreakpoint>();
    private final ILaunch fLaunch;
    private final IProcess fProcess;
    private VMThread fMainThread;
    private String fMainModuleName;
    private boolean fIsStarting;
    private boolean fIsSuspended = false;
    private final IVMVirtualMachineShell fVM;
    private final List<VMEventListener> fEventListener = new LinkedList<VMEventListener>();
    private final Object fVMStartMonitor = new Object();

    public VMDebugTarget(IProcess process, IVMVirtualMachineShell vm) {
        super(null);
        this.fLaunch = process.getLaunch();
        this.fProcess = process;
        this.fVM = vm;
        this.fIsStarting = true;
        this.fEventListener.add(this.createVMEventListener());
        EventDispatchJob dispatcher = new EventDispatchJob();
        Thread eventDispatherThread = new Thread((Runnable)dispatcher, "OCL Debug");
        eventDispatherThread.setDaemon(true);
        eventDispatherThread.start();
        try {
            this.sendRequest(new VMStartRequest(true));
        }
        catch (DebugException e) {
            this.getDebugCore().log(e.getStatus());
            return;
        }
        this.joinStartOrTerminate();
        this.installVMBreakpoints();
        DebugEvent createEvent = new DebugEvent((Object)this, 4);
        createEvent.setData(new HashMap<Long, VMLineBreakpoint>(this.fID2Breakpoint));
        this.fMainThread = new VMThread(this);
        this.fLaunch.addDebugTarget((IDebugTarget)this);
        System.setProperty(this.getDebugCore().getDebuggerActiveProperty(), Boolean.TRUE.toString());
        try {
            if (!this.fIsSuspended) {
                this.fVM.sendRequest(new VMResumeRequest(VMSuspension.UNSPECIFIED));
            }
        }
        catch (IOException e) {
            this.getDebugCore().log(e);
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fireEvent(createEvent);
    }

    @NonNull
    protected URI computeBreakpointURI(@NonNull URI sourceURI) {
        return sourceURI;
    }

    private void installVMBreakpoints() {
        HashMap<Long, VMLineBreakpoint> installedBreakpoints = new HashMap<Long, VMLineBreakpoint>();
        ArrayList<VMNewBreakpointData> allBpData = new ArrayList<VMNewBreakpointData>();
        for (VMLineBreakpoint vMLineBreakpoint : this.getDebugCore().getLineBreakpoints()) {
            boolean enabled = false;
            try {
                enabled = vMLineBreakpoint.isEnabled();
            }
            catch (CoreException e) {
                this.getDebugCore().log(e.getStatus());
            }
            if (!enabled) continue;
            installedBreakpoints.put(new Long(vMLineBreakpoint.getID()), vMLineBreakpoint);
            try {
                String unitURI = vMLineBreakpoint.getUnitURI().toString();
                String targetURI = this.computeBreakpointURI((URI)ClassUtil.nonNullEMF((Object)URI.createURI((String)unitURI, (boolean)true))).toString();
                VMNewBreakpointData data = vMLineBreakpoint.createNewBreakpointData(targetURI);
                allBpData.add(data);
            }
            catch (CoreException e) {
                this.getDebugCore().log(e.getStatus());
            }
        }
        if (!allBpData.isEmpty()) {
            VMNewBreakpointData[] vMNewBreakpointDataArray = allBpData.toArray(new VMNewBreakpointData[allBpData.size()]);
            VMBreakpointRequest breakpointRequest = VMBreakpointRequest.createAdd(vMNewBreakpointDataArray);
            try {
                VMResponse response = this.fVM.sendRequest(breakpointRequest);
                this.fID2Breakpoint.clear();
                if (response instanceof VMBreakpointResponse) {
                    VMBreakpointResponse bpResponse = (VMBreakpointResponse)response;
                    long[] lArray = bpResponse.getAddedBreakpointsIDs();
                    int n = lArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long addedID = lArray[n2];
                        Long key = new Long(addedID);
                        VMLineBreakpoint bp = (VMLineBreakpoint)((Object)installedBreakpoints.get(key));
                        if (bp != null) {
                            this.fID2Breakpoint.put(key, bp);
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                this.getDebugCore().log(e);
            }
        }
    }

    public Collection<? extends IBreakpoint> getInstalledBreakpoints() {
        return Collections.unmodifiableCollection(this.fID2Breakpoint.values());
    }

    @Override
    public VMResponse sendRequest(@NonNull VMRequest request) throws DebugException {
        try {
            VMResponse response = this.fVM.sendRequest(request);
            return response;
        }
        catch (IOException e) {
            throw new DebugException(this.getDebugCore().createDebugError("Send debug request failed", e));
        }
    }

    public synchronized boolean isSuspended() {
        return !this.isTerminated() && this.fIsSuspended;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IVMVirtualMachineShell getVM() {
        return this.fVM;
    }

    public IProcess getProcess() {
        IProcess[] processes = this.getLaunch().getProcesses();
        if (processes != null && processes.length > 0) {
            return processes[0];
        }
        return null;
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated();
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray;
        if (this.fMainThread != null) {
            IThread[] iThreadArray2 = new IThread[1];
            iThreadArray = iThreadArray2;
            iThreadArray2[0] = this.fMainThread;
        } else {
            iThreadArray = new IThread[]{};
        }
        return iThreadArray;
    }

    public String getName() throws DebugException {
        return "OCL Debug target";
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals(this.getModelIdentifier());
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fVM.isTerminated();
    }

    public void terminate() throws DebugException {
        this.sendRequest(new VMTerminateRequest());
    }

    protected void started(String mainModuleName) {
        this.setMainModuleName(mainModuleName);
        this.setStarting(false);
    }

    protected synchronized void setMainModuleName(String mainModuleName) {
        this.fMainModuleName = mainModuleName;
    }

    public synchronized String getMainModuleName() {
        return this.fMainModuleName;
    }

    protected void terminated() {
        this.getDebugCore().getTrace().trace(DebugOptions.TARGET, "Debug target terminated");
        System.setProperty(this.getDebugCore().getDebuggerActiveProperty(), Boolean.FALSE.toString());
        this.setStarting(false);
        this.fMainThread = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            IBreakpointManager breakpointManager = debugPlugin.getBreakpointManager();
            breakpointManager.removeBreakpointListener((IBreakpointListener)this);
            breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
        this.fID2Breakpoint.clear();
        this.fireTerminateEvent();
        if (this.fProcess instanceof VMVirtualProcess) {
            VMVirtualProcess vp = (VMVirtualProcess)this.fProcess;
            vp.terminated();
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public void resume() throws DebugException {
        this.sendRequest(new VMResumeRequest(VMSuspension.UNSPECIFIED));
    }

    public void suspend() throws DebugException {
        this.sendRequest(new VMSuspendRequest(VMSuspension.UNSPECIFIED));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof VMLineBreakpoint) || !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        VMLineBreakpoint vmBreakpoint = (VMLineBreakpoint)breakpoint;
        try {
            VMBreakpointResponse bpResponse;
            long[] addedIDs;
            VMNewBreakpointData bpData = vmBreakpoint.createNewBreakpointData();
            VMBreakpointRequest addBreakpointRequest = VMBreakpointRequest.createAdd(bpData);
            VMResponse response = this.sendRequest(addBreakpointRequest);
            if (response instanceof VMBreakpointResponse && (addedIDs = (bpResponse = (VMBreakpointResponse)response).getAddedBreakpointsIDs()).length > 0) {
                this.fID2Breakpoint.put(new Long(addedIDs[0]), vmBreakpoint);
            }
        }
        catch (CoreException e) {
            this.getDebugCore().log(e.getStatus());
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof VMLineBreakpoint) || !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        boolean nowEnabled = false;
        try {
            nowEnabled = breakpoint.isEnabled();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        boolean beforeEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", false);
        VMBreakpointRequest changeRequest = null;
        try {
            VMLineBreakpoint vmBreakpoint = (VMLineBreakpoint)breakpoint;
            changeRequest = nowEnabled && !beforeEnabled ? VMBreakpointRequest.createAdd(new VMNewBreakpointData[]{vmBreakpoint.createNewBreakpointData()}) : (!nowEnabled && beforeEnabled ? VMBreakpointRequest.createRemove(vmBreakpoint.getID()) : VMBreakpointRequest.createChange(vmBreakpoint.getID(), vmBreakpoint.createBreakpointData()));
        }
        catch (CoreException e) {
            this.getDebugCore().log(e);
        }
        if (changeRequest != null) {
            try {
                this.fVM.sendRequest(changeRequest);
            }
            catch (IOException e) {
                this.getDebugCore().log(e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof VMLineBreakpoint) {
            IMarker marker;
            if (delta == null && (marker = breakpoint.getMarker()).exists()) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            VMLineBreakpoint vmBreakpoint = (VMLineBreakpoint)breakpoint;
            this.fID2Breakpoint.remove(new Long(((VMLineBreakpoint)breakpoint).getID()));
            VMBreakpointRequest removeRequest = VMBreakpointRequest.createRemove(vmBreakpoint.getID());
            try {
                this.fVM.sendRequest(removeRequest);
            }
            catch (IOException e) {
                this.getDebugCore().log(e);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (this.fMainThread != null && event.getSource() == this.fMainThread || event.getSource() == this.fProcess) && !this.isTerminated()) {
                this.terminated();
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (IBreakpoint breakpoint : this.getDebugCore().getOCLBreakpoints(IBreakpoint.class)) {
            if (enabled) {
                this.breakpointAdded(breakpoint);
                continue;
            }
            this.breakpointRemoved(breakpoint, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void joinStartOrTerminate() {
        Object object = this.fVMStartMonitor;
        synchronized (object) {
            while (true) {
                if (!this.fIsStarting) {
                    return;
                }
                try {
                    this.fVMStartMonitor.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarting(boolean isStarting) {
        Object object = this.fVMStartMonitor;
        synchronized (object) {
            this.fIsStarting = isStarting;
            this.fVMStartMonitor.notify();
        }
    }

    private void handleBreakpointConditionError(VMSuspendEvent suspend) {
        BreakpointError breakpointStatus = new BreakpointError(suspend.getBreakpointID(), suspend.getReason(), suspend.getReasonDetail());
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)breakpointStatus);
        if (handler != null) {
            try {
                handler.handleStatus((IStatus)breakpointStatus, (Object)this);
            }
            catch (CoreException e) {
                this.getDebugCore().log(e.getStatus());
            }
        } else {
            this.getDebugCore().log((IStatus)breakpointStatus);
        }
    }

    private VMEventListener createVMEventListener() {
        return new VMEventListener(){

            @Override
            public void handleEvent(VMEvent event) {
                if (event instanceof VMResumeEvent) {
                    VMDebugTarget.this.fIsSuspended = false;
                    VMDebugTarget.this.fireResumeEvent(0);
                } else if (event instanceof VMSuspendEvent) {
                    VMDebugTarget.this.fIsSuspended = true;
                    VMSuspendEvent suspend = (VMSuspendEvent)event;
                    VMDebugTarget.this.fireSuspendEvent(suspend.suspension.getDebugEventDetail());
                    if (suspend.suspension == VMSuspension.BREAKPOINT_CONDITION_ERR) {
                        VMDebugTarget.this.handleBreakpointConditionError(suspend);
                    }
                } else if (event instanceof VMTerminateEvent) {
                    VMDebugTarget.this.fIsSuspended = false;
                    VMDebugTarget.this.terminated();
                } else if (event instanceof VMDisconnectEvent) {
                    VMDebugTarget.this.fIsSuspended = false;
                    VMDebugTarget.this.terminated();
                } else if (event instanceof VMStartEvent) {
                    VMStartEvent startEvent = (VMStartEvent)event;
                    VMDebugTarget.this.started(startEvent.mainModuleName);
                    VMDebugTarget.this.fIsSuspended = startEvent.suspendOnStartup;
                    if (VMDebugTarget.this.fIsSuspended) {
                        VMDebugTarget.this.fireSuspendEvent(VMSuspension.STEP_INTO.getDebugEventDetail());
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVMEventListener(@NonNull VMEventListener listener) {
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            this.fEventListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVMEventListener(@NonNull VMEventListener listener) {
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            return this.fEventListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleVMEvent(VMEvent event) {
        ArrayList<VMEventListener> listeners;
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            listeners = new ArrayList<VMEventListener>(this.fEventListener);
        }
        for (VMEventListener vmEventListener : listeners) {
            try {
                vmEventListener.handleEvent(event);
            }
            catch (Exception e) {
                this.getDebugCore().log(e);
            }
        }
    }

    public IValue evaluate(@NonNull String expressionText, long frameID) throws CoreException {
        if (this.getVM() instanceof VMVirtualMachine) {
            return ((VMVirtualMachine)this.getVM()).evaluate(expressionText, this, frameID);
        }
        return null;
    }

    private class EventDispatchJob
    implements Runnable {
        EventDispatchJob() {
        }

        @Override
        public void run() {
            while (!VMDebugTarget.this.isTerminated()) {
                VMEvent event;
                try {
                    event = VMDebugTarget.this.fVM.readVMEvent();
                }
                catch (IOException e) {
                    break;
                }
                if (VMVirtualMachine.VM_EVENT.isActive()) {
                    VMVirtualMachine.VM_EVENT.println(">[" + Thread.currentThread().getName() + "] " + event);
                }
                if (event == null) continue;
                VMDebugTarget.this.handleVMEvent(event);
            }
            VMDebugTarget.this.getDebugCore().getTrace().trace(DebugOptions.TARGET, "Debug target VMEvent dispatcher shutdown");
        }
    }
}

