/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLocalVariable;
import org.eclipse.ocl.examples.debug.vm.core.VMValue;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;

public class VMLocalValue
extends VMValue {
    private final long myFrameID;
    @NonNull
    private final IVMEvaluationEnvironment evaluationEnvironment;

    public VMLocalValue(IVMDebugTarget debugTarget, long frameID, String[] varPath, LocalValue evalResult, @NonNull IVMEvaluationEnvironment evaluationEnvironment) {
        super(debugTarget, VMLocalValue.createVmVar(varPath, evalResult, evaluationEnvironment), frameID);
        this.myFrameID = frameID;
        this.evaluationEnvironment = evaluationEnvironment;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        List<VMVariableData> variables = this.requestVariables();
        ArrayList<VMLocalVariable> result = new ArrayList<VMLocalVariable>();
        for (VMVariableData nextVar : variables) {
            result.add(new VMLocalVariable(this.getOCLDebugTarget(), nextVar, this.myFrameID, this.evaluationEnvironment));
        }
        return result.toArray(new IVariable[result.size()]);
    }

    @Override
    protected List<VMVariableData> requestVariables() throws DebugException {
        ArrayList<VMVariableData> vars = new ArrayList<VMVariableData>();
        VariableFinder.newInstance(this.evaluationEnvironment, true).collectChildVars(this.vmVar.valueObject, VariableFinder.getVariablePath(VariableFinder.parseURI(this.vmVar.variableURI)), null, vars);
        return vars;
    }

    private static VMVariableData createVmVar(String[] varPath, LocalValue evalResult, @NonNull IVMEvaluationEnvironment evalEnv) {
        String varName = String.valueOf(varPath.length > 0 ? varPath[varPath.length - 1] : null);
        VMVariableData var = new VMVariableData(varName, VariableFinder.createURI(varPath).toString());
        var.kind = 0;
        var.valueObject = evalResult.valueObject;
        EClassifier valueType = evalResult.valueType;
        String declaredTypeName = valueType != null ? valueType.getName() : null;
        VariableFinder.newInstance(evalEnv, true).setValueAndType(var, evalResult.valueObject, declaredTypeName);
        return var;
    }

    public static class LocalValue {
        public Object valueObject;
        public EClassifier valueType;
    }
}

