/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMThread;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMLocationData;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.request.VMStackFrameRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMStackFrameResponse;

public class VMStackFrame
extends VMDebugElement
implements IStackFrame {
    @NonNull
    private final VMThread fThread;
    @NonNull
    private VMStackFrameData fUnderlyingFrame;
    private boolean fDeferredExecution;

    public VMStackFrame(@NonNull VMThread thread, @NonNull VMStackFrameData frame) {
        super(thread.getOCLDebugTarget());
        if (thread == null || frame == null) {
            throw new IllegalArgumentException();
        }
        this.fThread = thread;
        this.fUnderlyingFrame = frame;
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public IValue evaluate(@NonNull String expressionText) throws CoreException {
        return ((VMDebugTarget)this.getOCLDebugTarget()).evaluate(expressionText, this.fUnderlyingFrame.id);
    }

    public int getCharEnd() throws DebugException {
        return this.getLocation().getCharEnd();
    }

    public int getCharStart() throws DebugException {
        return this.getLocation().getCharStart();
    }

    public int getLineNumber() {
        return this.getLocation().getLineNum();
    }

    public VMLocationData getLocation() {
        return this.fUnderlyingFrame.getLocation();
    }

    public String getName() throws DebugException {
        int line = this.getLineNumber();
        String fileName = this.getUnitURI().lastSegment();
        return line < -1 ? fileName : String.valueOf(fileName) + "(" + line + ")";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    @NonNull
    public IThread getThread() {
        return this.fThread;
    }

    @NonNull
    public URI getUnitURI() {
        return URI.createURI((String)this.getLocation().getURI());
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<VMVariable> result = new ArrayList<VMVariable>();
        Iterator<VMVariableData> iterator = this.fUnderlyingFrame.getVisibleVariables().iterator();
        while (iterator.hasNext()) {
            VMVariableData next;
            VMVariableData vmVar = next = iterator.next();
            result.add(new VMVariable(this.getOCLDebugTarget(), vmVar, this.fUnderlyingFrame.id));
        }
        IVariable[] allVars = result.toArray(new IVariable[result.size()]);
        Arrays.sort(allVars, new Comparator<IVariable>(){

            @Override
            public int compare(IVariable var1, IVariable var2) {
                try {
                    String n1 = var1.getName();
                    String n2 = var2.getName();
                    if (n1 == null) {
                        n1 = "";
                    }
                    if (n2 == null) {
                        n2 = "";
                    }
                    return n1.compareTo(n2);
                }
                catch (DebugException e) {
                    VMStackFrame.this.getDebugCore().log(e);
                    return 0;
                }
            }
        });
        return allVars;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return !this.fUnderlyingFrame.getVisibleVariables().isEmpty();
    }

    public boolean isDeferredExecution() {
        return this.fDeferredExecution;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    VMStackFrameData requestStackFrame() throws DebugException {
        VMStackFrameData frame = null;
        VMStackFrameRequest frameRequest = new VMStackFrameRequest(this.fUnderlyingFrame.id);
        VMResponse response = this.getOCLDebugTarget().sendRequest(frameRequest);
        if (response instanceof VMStackFrameResponse) {
            VMStackFrameResponse stackFrameResponse = (VMStackFrameResponse)response;
            this.fDeferredExecution = stackFrameResponse.isDeferredExecution;
            frame = stackFrameResponse.getFrame();
        }
        if (frame == null) {
            throw new DebugException(this.fThread.getDebugCore().createStatus(4, "VMStackFrame request failure"));
        }
        return frame;
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void setDeferredExecution(boolean isDeferred) {
        this.fDeferredExecution = isDeferred;
    }

    protected void setLocation(@NonNull VMStackFrameData frame) {
        this.fUnderlyingFrame = frame;
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }
}

