/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.launching;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.IVMVirtualMachineShell;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMVirtualProcess;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunner;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.vm.launching.SourceModificationListener;
import org.eclipse.ocl.examples.debug.vm.utils.StreamsProxy;
import org.eclipse.ocl.examples.debug.vm.utils.WriterLog;

public abstract class VMLaunchConfigurationDelegate<EC extends EvaluationContext>
extends LaunchConfigurationDelegate {
    protected void addSourceModificationListener(final @NonNull IFile unitFile, final @NonNull ITerminate terminate) {
        final SourceModificationListener listener = new SourceModificationListener(this.getDebugCore(), unitFile, terminate);
        unitFile.getProject().getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (event.getKind() == 8 && event.getSource().equals(terminate)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        unitFile.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                    }
                    ++i;
                }
            }
        });
    }

    @NonNull
    protected abstract VMDebugTarget createDebugTarget(@NonNull IVMVirtualMachineShell var1, @NonNull VMVirtualProcess var2);

    @NonNull
    protected abstract DebuggableRunnerFactory createDebuggableRunnerFactory(@NonNull EPackage.Registry var1, @NonNull List<String> var2, @Nullable String var3);

    @NonNull
    protected abstract EC createEvaluationContext(@NonNull ILaunchConfiguration var1) throws CoreException;

    @NonNull
    protected EPackage.Registry createPackageRegistry(String debuggableUri) {
        URI debuggableURI = URI.createURI((String)debuggableUri);
        try {
            IFile file;
            if (debuggableURI.isPlatformResource() && (file = this.getDebugCore().toFile(debuggableURI)) != null) {
                file.exists();
            }
        }
        catch (Exception e) {
            this.getDebugCore().log(e);
        }
        return new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    }

    private DebuggableRunner createRunner(@NonNull EC evaluationContext) throws CoreException {
        URI debuggableURI = ((EvaluationContext)((Object)evaluationContext)).getDebuggableURI();
        String uri = debuggableURI.toString();
        EPackage.Registry packageRegistry = this.createPackageRegistry(uri);
        ArrayList<String> modelURIs = new ArrayList<String>();
        DebuggableRunnerFactory runnerFactory = this.createDebuggableRunnerFactory(packageRegistry, modelURIs, null);
        try {
            return runnerFactory.createRunner((EvaluationContext)((Object)evaluationContext));
        }
        catch (DiagnosticException e) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)e.getDiagnostic()));
        }
    }

    @NonNull
    protected abstract VMVirtualMachine createVirtualMachine(@NonNull EC var1, @NonNull DebuggableRunner var2);

    @NonNull
    protected abstract VMVirtualProcess createVirtualProcess(@NonNull ILaunch var1, @NonNull IVMVirtualMachineShell var2);

    @NonNull
    protected abstract VMDebugCore getDebugCore();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        assert (configuration != null);
        assert (launch != null);
        EC evaluationContext = this.createEvaluationContext(configuration);
        StreamsProxy streamsProxy = new StreamsProxy();
        ((EvaluationContext)((Object)evaluationContext)).setLog(new WriterLog(this.getDebugCore(), streamsProxy.getOutputWriter(), true));
        DebuggableRunner runner = this.createRunner(evaluationContext);
        runner.setErrorLog(new PrintWriter(streamsProxy.getErrWriter(), true));
        Diagnostic initDiagnostic = runner.initialize();
        if (initDiagnostic.getSeverity() == 4) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)initDiagnostic));
        }
        VMVirtualMachine vm = this.createVirtualMachine(evaluationContext, runner);
        VMVirtualProcess process = this.createVirtualProcess(launch, vm);
        process.setStreamsProxy(streamsProxy);
        try {
            IFile unitFile;
            List<IFile> transformationWsFile = this.getDebugCore().toFiles(runner.getDebuggableURI());
            if (!transformationWsFile.isEmpty() && (unitFile = transformationWsFile.get(0)) != null) {
                this.addSourceModificationListener(unitFile, (ITerminate)process);
            }
        }
        catch (IllegalArgumentException transformationWsFile) {
            // empty catch block
        }
        VMDebugTarget debugTarget = this.createDebugTarget(vm, process);
        launch.addDebugTarget((IDebugTarget)debugTarget);
        debugTarget.getThreads()[0].stepInto();
    }
}

