/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.utils.Trace;

public class SocketUtil {
    @NonNull
    protected final VMDebugCore debugCore;

    public SocketUtil(@NonNull VMDebugCore debugCore) {
        this.debugCore = debugCore;
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public boolean close(Socket socket) {
        try {
            socket.close();
            return true;
        }
        catch (IOException e) {
            Trace trace = this.debugCore.getTrace();
            if (trace.shouldTraceCatching()) {
                trace.catching(SocketUtil.class, "close(Socket socket)", e);
            }
            this.debugCore.log(e);
            return false;
        }
    }

    public boolean close(ServerSocket socket) {
        try {
            socket.close();
            return true;
        }
        catch (IOException e) {
            Trace trace = this.debugCore.getTrace();
            if (trace.shouldTraceCatching()) {
                trace.catching(SocketUtil.class, "close(ServerSocket socket)", e);
            }
            this.debugCore.log(e);
            return false;
        }
    }

    public boolean close(InputStream is) {
        try {
            is.close();
            return true;
        }
        catch (IOException e) {
            Trace trace = this.debugCore.getTrace();
            if (trace.shouldTraceCatching()) {
                trace.catching(SocketUtil.class, "close(InputStream is)", e);
            }
            this.debugCore.log(e);
            return false;
        }
    }

    public boolean close(OutputStream os) {
        try {
            os.close();
            return true;
        }
        catch (IOException e) {
            Trace trace = this.debugCore.getTrace();
            if (trace.shouldTraceCatching()) {
                trace.catching(SocketUtil.class, "close(OutputStream os)", e);
            }
            this.debugCore.log(e);
            return false;
        }
    }
}

