/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceElement;
import org.eclipse.ocl.pivot.NamedElement;

public class VMStackTraceBuilder {
    @NonNull
    private static final String UNKNOWN_NAME = "<Unknown>";
    private static final int UNKNOWN_LINE_NUM = -1;
    @NonNull
    private IVMEvaluationEnvironment fEvalEnv;

    public VMStackTraceBuilder(@NonNull IVMEvaluationEnvironment evalEnv) {
        this.fEvalEnv = evalEnv;
    }

    public List<VMStackTraceElement> buildStackTrace() {
        LinkedList<VMStackTraceElement> elements = new LinkedList<VMStackTraceElement>();
        IVMEvaluationEnvironment nextEnv = this.fEvalEnv;
        while (nextEnv != null) {
            IVMEvaluationEnvironment parent = nextEnv.getVMParentEvaluationEnvironment();
            if (parent != null && parent.getDebuggableElement() != null) {
                elements.addLast(this.createStackElement(nextEnv));
            }
            nextEnv = nextEnv.getVMParentEvaluationEnvironment();
        }
        IVMEvaluationEnvironment rootEnv = this.fEvalEnv.getVMRootEvaluationEnvironment();
        return Collections.unmodifiableList(elements);
    }

    @NonNull
    private VMStackTraceElement createStackElement(@NonNull IVMEvaluationEnvironment env) {
        String unitName = null;
        String moduleName = UNKNOWN_NAME;
        String operName = UNKNOWN_NAME;
        int lineNumber = -1;
        NamedElement operation = env.getOperation();
        NamedElement currentExpressionInOCL = env.getDebuggableElement();
        moduleName = currentExpressionInOCL.getName();
        operName = operation.getName();
        return new VMStackTraceElement(moduleName, operName, unitName, lineNumber);
    }
}

