/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.core;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEnvironmentFactory;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;

public class OCLEvaluationContext
extends EvaluationContext {
    @Nullable
    private final ExpressionInOCL expressionObject;
    @Nullable
    private final EObject contextObject;
    @NonNull
    private final URI constraintURI;
    @Nullable
    private final URI contextURI;

    @NonNull
    protected static IVMEnvironmentFactory createVMEnvironmentFactory(@Nullable ExpressionInOCL expressionObject, @Nullable EObject contextObject) {
        Resource eResource;
        EObject contextObject2;
        Resource eResource2;
        EnvironmentFactoryInternal environmentFactory = null;
        ExpressionInOCL expressionObject2 = expressionObject;
        if (expressionObject2 != null && (eResource2 = expressionObject2.eResource()) != null) {
            environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)eResource2);
        }
        if (environmentFactory == null && (contextObject2 = contextObject) != null && (eResource = contextObject2.eResource()) != null) {
            environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)eResource);
        }
        if (environmentFactory == null) {
            environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(OCL.NO_PROJECTS, null);
        }
        return new OCLVMEnvironmentFactory(environmentFactory);
    }

    public OCLEvaluationContext(@NonNull ExpressionInOCL expressionObject, @Nullable EObject contextObject) {
        super(OCLEvaluationContext.createVMEnvironmentFactory(expressionObject, contextObject));
        this.expressionObject = expressionObject;
        this.contextObject = contextObject;
        this.constraintURI = (URI)ClassUtil.nonNullState((Object)EcoreUtil.getURI((EObject)expressionObject));
        this.contextURI = contextObject != null ? EcoreUtil.getURI((EObject)contextObject) : null;
    }

    public OCLEvaluationContext(@NonNull URI constraintURI, @NonNull URI contextURI) {
        super(OCLEvaluationContext.createVMEnvironmentFactory(null, null));
        this.expressionObject = null;
        this.contextObject = null;
        this.constraintURI = constraintURI;
        this.contextURI = contextURI;
    }

    @NonNull
    public URI getConstraintURI() {
        return this.constraintURI;
    }

    @Nullable
    public EObject getContextObject() {
        return this.contextObject;
    }

    @Nullable
    public URI getContextURI() {
        return this.contextURI;
    }

    @NonNull
    public URI getDebuggableURI() {
        return this.constraintURI;
    }

    @Nullable
    public ExpressionInOCL getExpressionObject() {
        return this.expressionObject;
    }
}

