/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.context.EInvocationContext;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public class OCLQueryDelegate
implements QueryDelegate {
    @NonNull
    protected OCLDelegateDomain delegateDomain;
    @NonNull
    protected final EInvocationContext parserContext;
    @NonNull
    protected final String expression;
    private ExpressionInOCL specification = null;

    public OCLQueryDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier context, @Nullable Map<String, EClassifier> parameters, @NonNull String expression) {
        this.delegateDomain = delegateDomain;
        this.parserContext = new EInvocationContext(delegateDomain.getOCL().getEnvironmentFactory(), null, context, parameters);
        this.expression = expression;
    }

    public Object execute(@Nullable Object target, Map<String, ?> arguments) throws InvocationTargetException {
        Map<String, Object> nonNullArguments = arguments != null ? arguments : Collections.emptyMap();
        try {
            int argCount;
            if (this.specification == null) {
                this.prepare();
            }
            ExpressionInOCL nonNullSpecification = this.specification;
            OCL ocl = this.delegateDomain.getOCL();
            IdResolver idResolver = ocl.getIdResolver();
            Object targetValue = idResolver.boxedValueOf(target);
            Class targetType = idResolver.getStaticTypeOf(targetValue);
            Type requiredType = nonNullSpecification.getOwnedContext().getType();
            if (requiredType == null || !targetType.conformsTo(ocl.getStandardLibrary(), requiredType)) {
                String message = StringUtil.bind((String)PivotMessagesInternal.WrongContextClassifier_ERROR_, (Object[])new Object[]{targetType, requiredType});
                throw new OCLDelegateException((Exception)new SemanticException(message));
            }
            List parameterVariables = nonNullSpecification.getOwnedParameters();
            int n = argCount = arguments != null ? arguments.size() : 0;
            if (parameterVariables.size() != argCount) {
                String message = StringUtil.bind((String)PivotMessagesInternal.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{argCount, parameterVariables.size()});
                throw new OCLDelegateException((Exception)new SemanticException(message));
            }
            Query query = ocl.createQuery(nonNullSpecification);
            EvaluationEnvironment env = query.getEvaluationEnvironment(target);
            for (Variable parameterVariable : parameterVariables) {
                String name = parameterVariable.getName();
                Object object = nonNullArguments.get(name);
                if (object == null && !nonNullArguments.containsKey(name)) {
                    String message = StringUtil.bind((String)PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{nonNullSpecification.getBody()});
                    throw new OCLDelegateException((Exception)new SemanticException(message));
                }
                Object value = idResolver.boxedValueOf(object);
                targetType = idResolver.getStaticTypeOf(value);
                requiredType = (Type)ClassUtil.nonNullModel((Object)parameterVariable.getType());
                if (!targetType.conformsTo(ocl.getStandardLibrary(), requiredType)) {
                    String message = StringUtil.bind((String)PivotMessagesInternal.MismatchedArgumentType_ERROR_, (Object[])new Object[]{name, targetType, requiredType});
                    throw new OCLDelegateException((Exception)new SemanticException(message));
                }
                env.add((TypedElement)parameterVariable, value);
            }
            Object result = query.evaluateEcore(target);
            return result;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (EvaluationException e) {
            String message = StringUtil.bind((String)PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{this.expression});
            throw new InvocationTargetException(new EvaluationException(message));
        }
        catch (WrappedException e) {
            throw new InvocationTargetException(e.getCause());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public void prepare() throws InvocationTargetException {
        try {
            this.specification = this.parserContext.parse((EObject)this.parserContext.getClassContext(), this.expression);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String toString() {
        OCLExpression bodyExpression;
        ExpressionInOCL specification2 = this.specification;
        OCLExpression oCLExpression = bodyExpression = specification2 != null ? specification2.getOwnedBody() : null;
        if (bodyExpression != null) {
            return "<" + this.delegateDomain.getURI() + ":query> " + bodyExpression;
        }
        return "<" + this.delegateDomain.getURI() + ":query> " + this.expression;
    }
}

