/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMNestedEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.VMInterruptedExecutionException;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.util.AbstractWrappingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;

public abstract class AbstractOCLVMEvaluationVisitor
extends AbstractWrappingVisitor<Object, Object, IOCLVMEvaluationVisitor, Element>
implements IOCLVMEvaluationVisitor {
    protected AbstractOCLVMEvaluationVisitor(@NonNull IOCLVMEvaluationVisitor nestedEvaluationVisitor) {
        super((Visitor)nestedEvaluationVisitor, new Object());
        ((IOCLVMEvaluationVisitor)this.delegate).setUndecoratedVisitor((EvaluationVisitor)this);
    }

    @NonNull
    public EvaluationVisitor getClonedEvaluator() {
        IOCLVMEvaluationEnvironment oldEvaluationEnvironment = this.getVMEvaluationEnvironment();
        IOCLVMEvaluationEnvironment clonedEvaluationEnvironment = oldEvaluationEnvironment.createClonedEvaluationEnvironment();
        return new OCLEvaluationVisitor((EvaluationEnvironment)clonedEvaluationEnvironment);
    }

    public abstract int getDepth();

    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getDiagnosticSeverity(severityPreference, resultValue);
    }

    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getEnvironmentFactory();
    }

    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getEvaluationEnvironment();
    }

    @NonNull
    public IOCLVMEvaluationEnvironment getVMEvaluationEnvironment() {
        return (IOCLVMEvaluationEnvironment)((IOCLVMEvaluationVisitor)this.delegate).getEvaluationEnvironment();
    }

    @NonNull
    public String getPluginId() {
        return "org.eclipse.ocl.examples.debug";
    }

    protected void processDeferredTasks() {
    }

    @Nullable
    protected Object badVisit(@NonNull Visitable visitable, @Nullable Element preState, @NonNull Throwable e) throws RuntimeException {
        if (e instanceof VMInterruptedExecutionException) {
            throw (VMInterruptedExecutionException)e;
        }
        Element element = (Element)visitable;
        IOCLVMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        Object result = this.badVisit(evalEnv, element, preState, e);
        if (VMVirtualMachine.POST_VISIT.isActive()) {
            VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
        }
        return result;
    }

    @Nullable
    protected abstract Object badVisit(@NonNull IVMEvaluationEnvironment var1, @NonNull Element var2, Object var3, @NonNull Throwable var4);

    protected void superProcessDeferredTasks() {
        IOCLVMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        evalEnv.processDeferredTasks();
    }

    protected Object postVisit(@NonNull Visitable visitable, @Nullable Element prologue, @Nullable Object result) {
        Element element = (Element)visitable;
        if (VMVirtualMachine.POST_VISIT.isActive()) {
            VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString() + " => " + result);
        }
        IOCLVMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        this.postVisit(evalEnv, element, result);
        return result;
    }

    protected abstract void postVisit(@NonNull IVMEvaluationEnvironment var1, @NonNull Element var2, @Nullable Object var3);

    @Nullable
    protected Element preVisit(@NonNull Visitable visitable) {
        Element element = (Element)visitable;
        if (VMVirtualMachine.PRE_VISIT.isActive()) {
            VMVirtualMachine.PRE_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
        }
        Element previousIP = this.setCurrentEnvInstructionPointer(null);
        IOCLVMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        this.preVisit(evalEnv, element);
        return previousIP;
    }

    protected abstract Object preVisit(@NonNull IVMEvaluationEnvironment var1, @NonNull Element var2);

    protected Element setCurrentEnvInstructionPointer(Element element) {
        IOCLVMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        if (element != null) {
            return evalEnv.setCurrentIP(element);
        }
        return evalEnv.getCurrentIP();
    }

    public Object visitVariable(@NonNull Variable vd) {
        Object result = super.visitVariable(vd);
        Type declaredType = vd.getType();
        EvaluationEnvironment env = this.getEvaluationEnvironment();
        env.replace((TypedElement)vd, (Object)declaredType);
        return result;
    }

    @Override
    @NonNull
    public IOCLVMEvaluationVisitor createNestedEvaluator() {
        return new OCLVMNestedEvaluationVisitor(this, ((IOCLVMEvaluationVisitor)this.delegate).createNestedEvaluator());
    }

    @Nullable
    public Object evaluate(@NonNull OCLExpression body) {
        return ((IOCLVMEvaluationVisitor)this.delegate).evaluate(body);
    }

    @NonNull
    public CompleteEnvironment getCompleteEnvironment() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getCompleteEnvironment();
    }

    @NonNull
    public EvaluationVisitor getEvaluator() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getEvaluator();
    }

    @NonNull
    public ModelManager getModelManager() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getModelManager();
    }

    @NonNull
    public MetamodelManager getMetamodelManager() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getMetamodelManager();
    }

    public int getSeverity(@Nullable Object validationKey) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getSeverity(validationKey);
    }

    @NonNull
    public StandardLibrary getStandardLibrary() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStandardLibrary();
    }

    public void setUndecoratedVisitor(@NonNull EvaluationVisitor evaluationVisitor) {
        ((IOCLVMEvaluationVisitor)this.delegate).setUndecoratedVisitor(evaluationVisitor);
    }

    @NonNull
    public IdResolver getIdResolver() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getIdResolver();
    }

    @Nullable
    public EvaluationLogger getLogger() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getLogger();
    }

    @Nullable
    public Monitor getMonitor() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getMonitor();
    }

    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getRegexPattern(regex);
    }

    @NonNull
    public abstract OCLVMRootEvaluationVisitor getVMRootEvaluationVisitor();

    @NonNull
    public Class getStaticTypeOf(@Nullable Object value) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value);
    }

    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value, values);
    }

    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value, values);
    }

    public boolean isCanceled() {
        return ((IOCLVMEvaluationVisitor)this.delegate).isCanceled();
    }

    public void setCanceled(boolean isCanceled) {
        ((IOCLVMEvaluationVisitor)this.delegate).setCanceled(isCanceled);
    }

    public void setLogger(@Nullable EvaluationLogger logger) {
        ((IOCLVMEvaluationVisitor)this.delegate).setLogger(logger);
    }

    public void setMonitor(@Nullable Monitor monitor) {
        ((IOCLVMEvaluationVisitor)this.delegate).setMonitor(monitor);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getDepth() + ")";
    }
}

