/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMModelManager;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluator;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class OCLVMEvaluator
implements IVMEvaluator {
    @NonNull
    protected final MetamodelManagerInternal metamodelManager;
    @NonNull
    protected final ExpressionInOCL expressionInOCL;
    @NonNull
    protected final OCLVMEnvironmentFactory vmEnvironmentFactory;
    @NonNull
    protected final OCLVMModelManager vmModelManager;
    @Nullable
    private EObject context;
    private boolean suspendOnStartup = false;

    @NonNull
    public static EObject loadContext(@NonNull MetamodelManagerInternal metamodelManager, @NonNull URI contextURI) throws IOException {
        EObject eObject = metamodelManager.getEnvironmentFactory().getResourceSet().getEObject(contextURI, true);
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + contextURI + "'");
        }
        return eObject;
    }

    @NonNull
    public static ExpressionInOCL loadExpression(@NonNull MetamodelManagerInternal metamodelManager, @NonNull URI constraintURI, boolean keepDebug) throws IOException, ParserException {
        EObject eObject = metamodelManager.getASResourceSet().getEObject(constraintURI, true);
        return OCLVMEvaluator.loadExpression(metamodelManager, eObject, constraintURI);
    }

    @NonNull
    public static ExpressionInOCL loadExpression(@NonNull MetamodelManagerInternal metamodelManager, EObject eObject, URI constraintURI) throws IOException, ParserException {
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + constraintURI + "'");
        }
        if (!(eObject instanceof Constraint)) {
            throw new IOException("Constraint rather than " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
        }
        LanguageExpression specification = ((Constraint)eObject).getOwnedSpecification();
        if (specification == null) {
            throw new IOException("Missing OCL expression " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
        }
        return metamodelManager.parseSpecification(specification);
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory vmEnvironmentFactory, @NonNull URI oclURI, @Nullable URI contextURI) throws IOException, ParserException {
        this(vmEnvironmentFactory, OCLVMEvaluator.loadExpression(vmEnvironmentFactory.getMetamodelManager(), oclURI, vmEnvironmentFactory.keepDebug()), contextURI != null ? OCLVMEvaluator.loadContext(vmEnvironmentFactory.getMetamodelManager(), contextURI) : null);
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory vmEnvironmentFactory, @NonNull Constraint constraint, @NonNull EObject context) throws IOException, ParserException {
        this(vmEnvironmentFactory, OCLVMEvaluator.loadExpression(vmEnvironmentFactory.getMetamodelManager(), (EObject)constraint, EcoreUtil.getURI((EObject)constraint)), context);
    }

    public OCLVMEvaluator(@NonNull OCLVMEnvironmentFactory vmEnvironmentFactory, @NonNull ExpressionInOCL expressionInOCL, @Nullable EObject context) throws IOException {
        this.vmEnvironmentFactory = vmEnvironmentFactory;
        this.metamodelManager = vmEnvironmentFactory.getMetamodelManager();
        this.expressionInOCL = expressionInOCL;
        this.vmModelManager = vmEnvironmentFactory.createVMModelManager(this.metamodelManager);
        this.context = context;
    }

    public void dispose() {
        this.vmModelManager.dispose();
    }

    public Object execute() {
        ExpressionInOCL expressionInOCL = this.getExpressionInOCL();
        IOCLVMEvaluationEnvironment evalEnv = this.vmEnvironmentFactory.createVMEvaluationEnvironment(expressionInOCL, (IVMModelManager)this.vmModelManager);
        Variable contextVariable = expressionInOCL.getOwnedContext();
        if (contextVariable != null) {
            evalEnv.add((TypedElement)contextVariable, this.context);
        }
        OCLVMRootEvaluationVisitor visitor = this.vmEnvironmentFactory.createVMEvaluationVisitor(evalEnv);
        visitor.start(this.suspendOnStartup);
        return expressionInOCL.accept((Visitor)visitor);
    }

    @NonNull
    public ExpressionInOCL getDebuggable() {
        return this.getExpressionInOCL();
    }

    @NonNull
    public final OCLVMEnvironmentFactory getEnvironmentFactory() {
        return this.vmEnvironmentFactory;
    }

    @NonNull
    public final MetamodelManagerInternal getMetamodelManager() {
        return this.metamodelManager;
    }

    @NonNull
    public final OCLVMModelManager getVMModelManager() {
        return this.vmModelManager;
    }

    @NonNull
    public ExpressionInOCL getExpressionInOCL() {
        return this.expressionInOCL;
    }

    public void saveModels() {
    }

    public void setSuspendOnStartUp(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }
}

