/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMNestedEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Variable;

public class OCLVMNestedEvaluationEnvironment
extends VMNestedEvaluationEnvironment
implements IOCLVMEvaluationEnvironment {
    @NonNull
    private Element myCurrentIP;
    @NonNull
    private NamedElement myOperation;
    private final int myStackDepth;
    private final long id;

    public OCLVMNestedEvaluationEnvironment(@NonNull IOCLVMEvaluationEnvironment evaluationEnvironment, @NonNull NamedElement executableObject, long id) {
        super((IVMEvaluationEnvironment)evaluationEnvironment, executableObject);
        this.myStackDepth = evaluationEnvironment.getDepth() + 1;
        this.id = id;
        this.myOperation = executableObject;
        this.myCurrentIP = executableObject;
    }

    @Override
    @NonNull
    public IOCLVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public long getID() {
        return this.id;
    }

    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        return this.getRootVMEvaluationEnvironment().getModelParameterVariables();
    }

    @NonNull
    public NamedElement getOperation() {
        return this.myOperation;
    }

    @NonNull
    public Variable getPCVariable() {
        return this.rootVMEvaluationEnvironment.getPCVariable();
    }

    @Override
    @Nullable
    public IOCLVMEvaluationEnvironment getVMParentEvaluationEnvironment() {
        return (IOCLVMEvaluationEnvironment)super.getVMParentEvaluationEnvironment();
    }

    @Override
    @NonNull
    public OCLVMRootEvaluationEnvironment getVMRootEvaluationEnvironment() {
        return (OCLVMRootEvaluationEnvironment)this.rootVMEvaluationEnvironment;
    }

    @Override
    @NonNull
    public OCLVMEnvironmentFactory getVMEnvironmentFactory() {
        return (OCLVMEnvironmentFactory)this.vmEnvironmentFactory;
    }

    public boolean isDeferredExecution() {
        return this.getVMRootEvaluationEnvironment().isDeferredExecution();
    }

    public void processDeferredTasks() {
        this.getVMRootEvaluationEnvironment().processDeferredTasks();
    }

    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setOperation(@NonNull NamedElement operation) {
        this.myCurrentIP = operation;
        this.myOperation = operation;
    }

    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.getVMRootEvaluationEnvironment().saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", (Throwable)e);
        }
        throw exception;
    }
}

