/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.core.OCLEvaluationContext;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.launching.DebuggableRunner;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class OCLVMVirtualMachine
extends VMVirtualMachine {
    public static VMStackFrameData[] createStackFrame(List<UnitLocation> stack) {
        ArrayList<VMStackFrameData> result = new ArrayList<VMStackFrameData>();
        int i = 0;
        for (UnitLocation location : stack) {
            if (location == null) continue;
            result.add(OCLVMVirtualMachine.createStackFrame(location, i++ == 0));
        }
        return result.toArray(new VMStackFrameData[result.size()]);
    }

    private static boolean appendElementSignature(@NonNull StringBuilder s, @Nullable EObject eObject) {
        if (eObject instanceof Model) {
            return false;
        }
        if (eObject instanceof Package) {
            if (OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Package)eObject).getName());
            return true;
        }
        if (eObject instanceof Type) {
            if (OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Type)eObject).getName());
            return true;
        }
        if (eObject instanceof Operation) {
            if (OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            Operation operation = (Operation)eObject;
            s.append(operation.getName());
            s.append("(");
            boolean isFirst = true;
            for (Parameter param : operation.getOwnedParameters()) {
                if (!isFirst) {
                    s.append(", ");
                }
                Type type = param.getType();
                s.append(type.getName());
                isFirst = false;
            }
            s.append(")");
            return true;
        }
        if (eObject instanceof Feature) {
            if (OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Feature)eObject).getName());
            return true;
        }
        if (eObject instanceof Constraint) {
            if (OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer())) {
                s.append("::");
            }
            s.append(((Constraint)eObject).getName());
            return true;
        }
        if (eObject != null) {
            return OCLVMVirtualMachine.appendElementSignature(s, eObject.eContainer());
        }
        return false;
    }

    public VMStackFrameData createStackFrame(@NonNull UnitLocation location) {
        return OCLVMVirtualMachine.createStackFrame(location, true);
    }

    @NonNull
    private static VMStackFrameData createStackFrame(@NonNull UnitLocation location, boolean includeVars) {
        IVMEvaluationEnvironment evalEnv = location.getEvalEnv();
        NamedElement module = location.getModule();
        String moduleName = module != null ? (String)ClassUtil.nonNullState((Object)module.getName()) : "<null>";
        NamedElement operation = location.getOperation();
        StringBuilder s = new StringBuilder();
        OCLVMVirtualMachine.appendElementSignature(s, (EObject)operation);
        String operSignature = s.toString();
        List vars = VariableFinder.getVariables((IVMEvaluationEnvironment)evalEnv);
        String uriString = (String)ClassUtil.nonNullState((Object)location.getURI().toString());
        VMVariableData[] varsArray = vars.toArray(new VMVariableData[vars.size()]);
        VMStackFrameData vmStackFrame = new VMStackFrameData(evalEnv.getID(), uriString, moduleName, operSignature, location.getLineNum(), location.getStartPosition(), location.getEndPosition(), varsArray);
        return vmStackFrame;
    }

    public OCLVMVirtualMachine(@NonNull DebuggableRunner runner, @NonNull OCLEvaluationContext evaluationContext) {
        super(runner, runner.createDebuggableAdapter((EvaluationContext)evaluationContext));
    }

    @NonNull
    public OCLDebugCore getDebugCore() {
        return OCLDebugCore.INSTANCE;
    }
}

