/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluator;
import org.eclipse.ocl.examples.debug.launching.OCLLaunchConstants;
import org.eclipse.ocl.examples.debug.vm.utils.BaseProcess;
import org.eclipse.ocl.examples.debug.vm.utils.MiscUtil;
import org.eclipse.ocl.examples.debug.vm.utils.SafeRunner;
import org.eclipse.ocl.examples.debug.vm.utils.ShallowProcess;
import org.eclipse.ocl.examples.debug.vm.utils.StreamsProxy;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.OCL;

public class OCLLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements OCLLaunchConstants {
    protected static final int LAUNCH_ERROR_CODE = 210;
    protected static final IStatus fgLaunchErrorStatus = new Status(4, "org.eclipse.ocl.examples.debug", 210, "Launch configuration error", null);

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            String oclName = configuration.getAttribute("constraint", "");
            final URI oclURI = URI.createURI((String)oclName, (boolean)true);
            String elementName = configuration.getAttribute("context", "");
            final URI elementURI = URI.createURI((String)elementName, (boolean)true);
            BasicMonitor execMonitor = new BasicMonitor();
            StreamsProxy streamsProxy = new StreamsProxy();
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    EnvironmentFactoryInternal environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(OCL.NO_PROJECTS, null);
                    OCLVMEnvironmentFactory vmEnvironmentFactory = new OCLVMEnvironmentFactory(environmentFactory);
                    OCLVMEvaluator vmEvaluator = new OCLVMEvaluator(vmEnvironmentFactory, oclURI, elementURI);
                    vmEvaluator.execute();
                }
            };
            r = SafeRunner.getSafeRunnable((BaseProcess.IRunnable)r);
            final ShallowProcess process = new ShallowProcess(launch, r, (Monitor)execMonitor){
                boolean isTerminated;
                private final /* synthetic */ Monitor val$execMonitor;
                {
                    this.val$execMonitor = monitor;
                    super($anonymous0, $anonymous1);
                    this.isTerminated = false;
                }

                public void terminate() throws DebugException {
                    this.val$execMonitor.setCanceled(true);
                    this.isTerminated = true;
                    super.terminate();
                }

                public boolean isTerminated() {
                    return this.isTerminated || super.isTerminated();
                }

                public boolean canTerminate() {
                    return !this.isTerminated();
                }
            };
            process.setStreamsProxy((IStreamsProxy)streamsProxy);
            Thread processThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            process.run();
                        }
                        catch (Exception e) {
                            if (e instanceof VMRuntimeException) break block7;
                            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(fgLaunchErrorStatus);
                            if (statusHandler != null) {
                                Status actualStatus = new Status(4, "org.eclipse.ocl.examples.debug", 210, e.getMessage(), (Throwable)(e.getMessage() == null ? e : null));
                                try {
                                    statusHandler.handleStatus((IStatus)actualStatus, (Object)configuration);
                                }
                                catch (CoreException coreExc) {
                                    OCLLaunchConfigurationDelegate.this.getDebugCore().log(coreExc.getStatus());
                                }
                            }
                            OCLLaunchConfigurationDelegate.this.getDebugCore().error(e);
                        }
                    }
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        OCLLaunchConfigurationDelegate.this.getDebugCore().log(e.getStatus());
                    }
                }
            }, "OCL Run");
            processThread.start();
        }
        catch (Exception e) {
            throw new CoreException(MiscUtil.makeErrorStatus((Exception)e));
        }
    }

    @NonNull
    protected OCLDebugCore getDebugCore() {
        return OCLDebugCore.INSTANCE;
    }
}

