/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.SetType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class DefExpressionTest
extends AbstractTestSuite {
    Resource instanceResource;
    Package instancePackage;

    public void test_defExpression_raw_operation() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit def: bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)this.getStereotype(constraint));
            DefExpressionTest.assertSame((Object)this.color, (Object)expr.getType());
            expr = this.parse("package ocltest context Fruit inv: bestColor(Color::red) = Color::red endpackage");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.fruit_color, this.color_black);
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, expr));
            this.setValue(anApple, this.fruit_color, this.color_green);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_helper_operation() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.defineOperation("bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif");
            Constraint expr = (Constraint)this.helper.createInvariant("bestColor(Color::red) = Color::red");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.fruit_color, this.color_black);
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)expr));
            this.setValue(anApple, this.fruit_color, this.color_green);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_raw_attribute() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Apple def: fallen : Boolean = tree.oclIsUndefined() endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)this.getStereotype(constraint));
            DefExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getBoolean(), (Object)expr.getType());
            expr = this.parse("package ocltest context Apple inv: not fallen endpackage");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.apple_tree, this.instantiate(this.instancePackage, (Classifier)this.tree));
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, expr));
            this.setValue(anApple, this.apple_tree, null);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_helper_attribute() {
        this.helper.setContext((Object)this.apple);
        try {
            this.helper.defineAttribute("fallen : Boolean = tree.oclIsUndefined()");
            Constraint expr = (Constraint)this.helper.createInvariant("not fallen");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.apple_tree, this.instantiate(this.instancePackage, (Classifier)this.tree));
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)expr));
            this.setValue(anApple, this.apple_tree, null);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_raw_reference() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Apple def: otherApples : Set(Apple) = Apple.allInstances()->excluding(self) endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)this.getStereotype(constraint));
            DefExpressionTest.assertTrue((boolean)(expr.getType() instanceof org.eclipse.ocl.types.SetType));
            DefExpressionTest.assertSame((Object)((SetType)expr.getType()).getElementType(), (Object)this.apple);
            expr = this.parse("package ocltest context Apple inv: self.otherApples endpackage");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            HashMap extentMap = new HashMap();
            HashSet<InstanceSpecification> allApples = new HashSet<InstanceSpecification>();
            allApples.add(anApple);
            allApples.add(anotherApple);
            extentMap.put(this.apple, allApples);
            this.ocl.setExtentMap(extentMap);
            Object otherApples = this.ocl.evaluate((Object)anApple, expr);
            DefExpressionTest.assertEquals(Collections.singleton(anotherApple), (Object)otherApples);
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_inheritance_operation() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineOperation("oclAllParents() : Set(Classifier) = self->closure(generalization.general)");
            OCLExpression expr = this.helper.createQuery("self.oclAllParents()");
            Object oclAllParents = this.ocl.evaluate((Object)this.apple, expr);
            DefExpressionTest.assertTrue((boolean)(oclAllParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)oclAllParents).contains(this.fruit));
            oclAllParents = this.ocl.evaluate((Object)this.color, expr);
            DefExpressionTest.assertTrue((boolean)(oclAllParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)oclAllParents).isEmpty());
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_inheritance_attribute() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineAttribute("oclAllParents : Set(Classifier) = self->closure(generalization.general)");
            OCLExpression expr = this.helper.createQuery("self.oclAllParents");
            Object oclAllParents = this.ocl.evaluate((Object)this.apple, expr);
            DefExpressionTest.assertTrue((boolean)(oclAllParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)oclAllParents).contains(this.fruit));
            oclAllParents = this.ocl.evaluate((Object)this.color, expr);
            DefExpressionTest.assertTrue((boolean)(oclAllParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)oclAllParents).isEmpty());
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_static() {
        try {
            Environment env = this.ocl.getEnvironment();
            UMLReflection umlReflection = env.getUMLReflection();
            ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.SUPPORT_STATIC_FEATURES, (Object)true);
            this.parseDef("package ocltest context Fruit def: bestColor1() : Color = null static def: bestColor2() : Color = null def: goodColor1 : Color = null static def: goodColor2 : Color = null endpackage");
            Operation operation1 = (Operation)env.lookupOperation((Object)this.fruit, "bestColor1", null);
            DefExpressionTest.assertNotNull((Object)operation1);
            DefExpressionTest.assertEquals((boolean)false, (boolean)umlReflection.isStatic((Object)operation1));
            Operation operation2 = (Operation)env.lookupOperation((Object)this.fruit, "bestColor2", null);
            DefExpressionTest.assertNotNull((Object)operation2);
            DefExpressionTest.assertEquals((boolean)true, (boolean)umlReflection.isStatic((Object)operation2));
            Property property1 = (Property)env.lookupProperty((Object)this.fruit, "goodColor1");
            DefExpressionTest.assertNotNull((Object)property1);
            DefExpressionTest.assertEquals((boolean)false, (boolean)umlReflection.isStatic((Object)property1));
            Property property2 = (Property)env.lookupProperty((Object)this.fruit, "goodColor2");
            DefExpressionTest.assertNotNull((Object)property2);
            DefExpressionTest.assertEquals((boolean)true, (boolean)umlReflection.isStatic((Object)property2));
            ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.SUPPORT_STATIC_FEATURES, (Object)false);
            try {
                this.ocl.parse(new OCLInput("package ocltest context Fruit def: bestColor3() : Color = null static def: bestColor4() : Color = null endpackage"));
                DefExpressionTest.fail((String)"Should have failed to parse the unsupported static");
            }
            catch (ParserException e) {
                DefExpressionTest.assertEquals((String)OCLMessages.UnsupportedStatic_ERROR_, (String)e.getMessage());
                System.out.println("Got the expected exception: " + e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_malformedDefExpression_attribute() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineAttribute("oclAllParents : Set(Classifier) = self.name");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineAttribute("myName = self.name");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_malformedDefExpression_operation() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineOperation("oclAllParents() : Set(Classifier) = self.name");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("bestName(s : String) = if self.oclIsKindOf(Class) then self.name else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("bestName(s) : String = if self.oclIsKindOf(Class) then self.name else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_duplicateDefinition_attribute() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineAttribute("name : String = if self.oclIsKindOf(Class) then 'foo' else '' endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineAttribute("generalization : Set(String) = Set{'a', 'b', 'c'}");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_duplicateDefinition_operation() {
        this.helper.setContext((Object)this.apple);
        try {
            this.helper.defineOperation("preferredLabel(s : String) : String = if s.oclIsUndefined() then 'foo' else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("preferredLabel(s : String) : Integer = if s.oclIsUndefined() then 0 else s.size() endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("preferredLabel(text : Integer) : String = if text > 0 then 'foo' else 'bar' endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_undefine_property_152018() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        Property property = null;
        try {
            property = (Property)this.helper.defineAttribute("other : Classifier = if general->notEmpty() then general->asSequence()->first() else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)property);
        this.ocl.getEnvironment().undefine((Object)property);
        DefExpressionTest.assertNull((Object)property.eContainer());
        DefExpressionTest.assertNull((Object)property.eResource());
        try {
            property = (Property)this.helper.defineAttribute("other : Classifier = if general->notEmpty() then general->asSequence()->first() else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_undefine_operation_152018() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        Operation operation = null;
        try {
            operation = (Operation)this.helper.defineOperation("other(x : Integer) : Classifier = if general->size() >= x then general->asSequence()->at(x) else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)operation);
        this.ocl.getEnvironment().undefine((Object)operation);
        DefExpressionTest.assertNull((Object)operation.eContainer());
        DefExpressionTest.assertNull((Object)operation.eResource());
        try {
            operation = (Operation)this.helper.defineOperation("other(x : Integer) : Classifier = if general->size() >= x then general->asSequence()->at(x) else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_recursive_property_152018() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        Property property = null;
        try {
            property = (Property)this.helper.defineAttribute("friend : Classifier = if general->notEmpty() then getNearestPackage() else self endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            property = (Property)this.helper.defineAttribute("friend : Classifier = if general->notEmpty() then general->asSequence()->first().friend else self endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)property);
        try {
            this.helper.createInvariant("not friend.oclIsUndefined() implies friend = self");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_recursive_operation_152018() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        Operation operation = null;
        try {
            operation = (Operation)this.helper.defineOperation("friend(x : Integer) : Classifier = if general->size() >= x then getNearestPackage() else self endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            operation = (Operation)this.helper.defineOperation("friend(x : Integer) : Classifier = if general->size() >= x then general->asSequence()->at(x).friend(x) else self endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)operation);
        try {
            this.helper.createInvariant("not friend(1).oclIsUndefined() implies friend(1) = self");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_completion_operation() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineOperation("oclAllParents() : Set(Classifier) = self->closure(generalization.general)");
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "oclAllParents");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_completion_attribute() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        try {
            this.helper.defineAttribute("oclAllParents : Set(Classifier) = self->closure(generalization.general)");
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "oclAllParents");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defAttributeOnPrimitiveType_172782() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            Property feature = (Property)this.helper.defineAttribute("reverse : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "reverse");
            OCLExpression expr = this.helper.createQuery("self.reverse");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.getUMLString())).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "reverse");
            localHelper.createQuery("self.reverse");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined attribute");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defOperationOnPrimitiveType_172782() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            Operation feature = (Operation)this.helper.defineOperation("reversed() : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "reversed");
            OCLExpression expr = this.helper.createQuery("self.reversed()");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.getUMLString())).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "reversed");
            localHelper.createQuery("self.reversed()");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined operation");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defAttributeOnPredefinedType_172782() {
        this.helper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            Property feature = (Property)this.helper.defineAttribute("reverse : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((Classifier)this.getUMLString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "reverse");
            OCLExpression expr = this.helper.createQuery("self.reverse");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.getUMLString())).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "reverse");
            localHelper.createQuery("self.reverse");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined attribute");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defOperationOnPredefinedType_172782() {
        this.helper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            Operation feature = (Operation)this.helper.defineOperation("reversed() : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((Classifier)this.getUMLString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "reversed");
            OCLExpression expr = this.helper.createQuery("self.reversed()");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((Classifier)this.getUMLString())).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "reversed");
            localHelper.createQuery("self.reversed()");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined operation");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defExpression_operation_owner() {
        this.helper.setContext((Object)this.fruit);
        try {
            Operation o = (Operation)this.helper.defineOperation("bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif");
            UMLReflection uml = this.ocl.getEnvironment().getUMLReflection();
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)this.fruit_ripen));
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)o));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_attribute_owner() {
        this.helper.setContext((Object)this.apple);
        try {
            Property p = (Property)this.helper.defineAttribute("fallen : Boolean = tree.oclIsUndefined()");
            UMLReflection uml = this.ocl.getEnvironment().getUMLReflection();
            DefExpressionTest.assertSame((Object)this.apple, (Object)uml.getOwningClassifier((Object)this.apple_label));
            DefExpressionTest.assertSame((Object)this.apple, (Object)uml.getOwningClassifier((Object)p));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_def_operation_OclAny_192892() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getOclAny()));
        try {
            this.helper.defineOperation("isBlack() : Boolean = true");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        this.helper.setContext((Object)this.fruit);
        try {
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            DefExpressionTest.assertTrue((boolean)this.check(this.helper, anApple, "self.isBlack()"));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_def_attribute_OclAny_192892() {
        this.helper.setContext((Object)((Classifier)this.getOCLStandardLibrary().getOclAny()));
        try {
            this.helper.defineAttribute("isBlack : Boolean = true");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        this.helper.setContext((Object)this.fruit);
        try {
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            DefExpressionTest.assertTrue((boolean)this.check(this.helper, anApple, "self.isBlack"));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_operation_similarParams_238050() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.defineOperation("displayName(first : String, last : String) : String = if self.color = Color::red then first else last endif");
            OCLExpression expr = this.helper.createQuery("self.displayName('Roger', 'Bacon')");
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.fruit_color, this.color_black);
            DefExpressionTest.assertEquals((Object)"Bacon", (Object)this.ocl.evaluate((Object)anApple, expr));
            this.setValue(anApple, this.fruit_color, this.color_red);
            DefExpressionTest.assertEquals((Object)"Roger", (Object)this.ocl.evaluate((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() {
        super.setUp();
        this.instanceResource = resourceSet.createResource(URI.createFileURI((String)"/tmp/instances.uml"));
        this.instancePackage = umlf.createPackage();
        this.instancePackage.setName("instances");
        this.instanceResource.getContents().add((Object)this.instancePackage);
    }
}

