/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.tests.GenericFruitTestSuite;
import org.eclipse.ocl.utilities.UMLReflection;

public class MessagesTest
extends AbstractTestSuite {
    public void test_hasSent_operation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^preferredColor()");
            this.helper.createPostcondition("self ^ newFruit()");
            this.helper.createPostcondition("Apple.allInstances()->any(true) ^ripen(Color::yellow)");
            this.helper.createPostcondition("Fruit.allInstances()->forAll(f | self^setColor(f, Color::red))");
            this.helper.createPostcondition("Apple.allInstances()->forAll(a | self^setColor(a, Color::red))");
            this.helper.createPostcondition("Apple.allInstances()->forAll(a | self^setColor(null, Color::red))");
            this.helper.createPostcondition("Apple.allInstances()->forAll(a | self^setColor(a, null))");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_hasSent_operation_validation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^label('foo')");
            MessagesTest.fail((String)"Should have failed to parse unknown operation");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createPostcondition("self^setColor(self, 'red')");
            MessagesTest.fail((String)"Should have failed to parse non-conformant arg");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_hasSent_operation_unspecifiedValue() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("Apple.allInstances()->any(true)^ripen(? : Color)");
            this.helper.createPostcondition("Fruit.allInstances()->forAll(f | self^setColor(? : Fruit, ? : Color))");
            this.helper.createPostcondition("Apple.allInstances()->any(true)^ripen(?)");
            this.helper.createPostcondition("Fruit.allInstances()->forAll(f | self^setColor(?, ?))");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_hasSent_operation_unspecifiedValue_validation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^label(?)");
            MessagesTest.fail((String)"Should have failed to parse unknown operation");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createPostcondition("self^setColor(self, ? : String)");
            MessagesTest.fail((String)"Should have failed to parse non-conformant arg");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_sentMessages_operation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^^preferredColor()->notEmpty()");
            this.helper.createPostcondition("self^^newFruit()->first().oclIsKindOf(OclMessage)");
            this.helper.createPostcondition("Apple.allInstances()->any(true)^^ripen(Color::yellow)->notEmpty()");
            this.helper.createPostcondition("Fruit.allInstances()->collect(f | self^^setColor(f, Color::red))->notEmpty()");
            this.helper.createPostcondition("Apple.allInstances()->collect(a | self^^setColor(a, Color::red))->notEmpty()");
            this.helper.createPostcondition("Apple.allInstances()->collect(a | self^^setColor(null, Color::red))->notEmpty()");
            this.helper.createPostcondition("Apple.allInstances()->collect(a | self^^setColor(a, null))->notEmpty()");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_message_access_operation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("let msgs : Sequence(OclMessage) = self^^preferredColor() in msgs->forAll(m | m.hasReturned() and m.isOperationCall() and not m.isSignalSent())");
            this.helper.createPostcondition("self^^newFruit()->first().oclIsKindOf(OclMessage)");
            this.helper.createPostcondition("Apple.allInstances()->any(true)^^ripen(Color::yellow)->notEmpty()");
            this.helper.createPostcondition("let msgs : Collection(OclMessage) = Fruit.allInstances()->collect(f | self^^setColor(?, ?)) in msgs->forAll(m | m.fruit.color = Color::black implies m.newColor = Color::black)");
            this.helper.createPostcondition("let msgs : Collection(OclMessage) = Fruit.allInstances()->collect(f | self^^newFruit()) in msgs->forAll(m | m.hasReturned() implies m.result().color = Color::green)");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_sentMessages_operation_validation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^^label('foo')->notEmpty()");
            MessagesTest.fail((String)"Should have failed to parse unknown operation");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createPostcondition("self^^setColor(self, 'red')->notEmpty()");
            MessagesTest.fail((String)"Should have failed to parse non-conformant arg");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_hasSent_signal() {
        this.helper.setOperationContext((Object)this.apple, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^Drop(3, self.stem)");
            this.helper.createPostcondition("self ^ Drop(? : Real, ? : Stem)");
            this.helper.createPostcondition("self ^Drop(? : Integer, ?)");
            this.helper.createPostcondition("self^Drop(?, ?)");
            this.helper.createPostcondition("Apple.allInstances()->any(true)^Drop(3, stem)");
            this.helper.createPostcondition("Apple.allInstances()->exists(a | a^Drop(3, stem))");
            this.helper.createPostcondition("Fruit.allInstances()->forAll(f | f^Drop(?, ?) implies self^Drop(?, ?))");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_hasSent_signal_validation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^Rot(3, stem)");
            MessagesTest.fail((String)"Should have failed to parse unknown signal");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createPostcondition("self^Drop('red', ?)");
            MessagesTest.fail((String)"Should have failed to parse non-conformant arg");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_sentMessages_signal() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^^Drop(3, self.oclAsType(Apple).stem)->notEmpty()");
            this.helper.createPostcondition("self^^Drop(?, ?)->first().oclIsKindOf(OclMessage)");
            this.helper.createPostcondition("Apple.allInstances()->any(true)^^Drop(3, ?)->notEmpty()");
            this.helper.createPostcondition("Apple.allInstances()->collect(a | self^^Drop(null, ? : Stem))->notEmpty()");
            this.helper.createPostcondition("Apple.allInstances()->collect(a | self^^Drop(3, null))->notEmpty()");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_message_access_signal() {
        this.helper.setOperationContext((Object)this.apple, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("let msgs : Sequence(OclMessage) = self^^Drop(?, ?) in msgs->forAll(m | m.isSignalSent() and not m.isOperationCall())");
            this.helper.createPostcondition("self^^Drop(?, ?)->first().oclIsKindOf(OclMessage)");
            this.helper.createPostcondition("let msgs : Collection(OclMessage) = Fruit.allInstances()->collect(f | self^^Drop(?, ?)) in msgs->forAll(m | m.delay > 0 and stem <> self.stem)");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_sentMessages_signal_validation() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPostcondition("self^^Rot('now')->notEmpty()");
            MessagesTest.fail((String)"Should have failed to parse unknown signal");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createPostcondition("self^^Drop(self, ?)->notEmpty()");
            MessagesTest.fail((String)"Should have failed to parse non-conformant arg");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_contentAssist_operations() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "newFruit");
            this.assertChoice(choices, ChoiceKind.OPERATION, "setColor");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsKindOf");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "newFruit");
            this.assertChoice(choices, ChoiceKind.OPERATION, "setColor");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsKindOf");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.VARIABLE, "color");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "Apple.allInstances()->any(true)^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "newFruit");
            this.assertChoice(choices, ChoiceKind.OPERATION, "setColor");
            this.assertChoice(choices, ChoiceKind.OPERATION, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsKindOf");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "Apple.allInstances()->collect(a : Apple | a^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.OPERATION, "newFruit");
            this.assertChoice(choices, ChoiceKind.OPERATION, "setColor");
            this.assertChoice(choices, ChoiceKind.OPERATION, "label");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsKindOf");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_contentAssist_signals() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.SIGNAL, "Drop");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.SIGNAL, "Drop");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self^^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.VARIABLE, "color");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "Apple.allInstances()->any(true)^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.SIGNAL, "Drop");
            choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "Apple.allInstances()->collect(a : Apple | a^^");
            MessagesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.SIGNAL, "Drop");
        }
        catch (Exception e) {
            MessagesTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new MessagingFruitEnvironmentFactory(this));
    }

    public void setUp() {
        super.setUp();
        this.expectModified = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessagingFruitEnvironment
    extends EcoreEnvironment
    implements GenericFruitTestSuite.InitEnvironment {
        protected final AbstractTestSuite suite;
        private EClass dropSignal;
        private EList<EClassifier> signals = new BasicEList();

        public MessagingFruitEnvironment(MessagingFruitEnvironmentFactory factory, AbstractTestSuite suite) {
            super((EcoreEnvironmentFactory)factory, null);
            this.suite = suite;
            this.setContextPackage((EPackage)suite.fruitPackage);
        }

        public MessagingFruitEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, AbstractTestSuite suite) {
            super(parent);
            this.suite = suite;
            this.init();
        }

        public void init() {
            this.dropSignal = EcoreFactory.eINSTANCE.createEClass();
            this.dropSignal.setName("Drop");
            EAttribute property = EcoreFactory.eINSTANCE.createEAttribute();
            property.setName("delay");
            property.setEType((EClassifier)this.getOCLStandardLibrary().getReal());
            this.dropSignal.getEStructuralFeatures().add((Object)property);
            property = EcoreFactory.eINSTANCE.createEReference();
            property.setName("stem");
            property.setEType((EClassifier)this.suite.stem);
            this.dropSignal.getEStructuralFeatures().add((Object)property);
            this.signals.add((Object)this.dropSignal);
            ((EPackage)this.suite.fruitPackage).getEClassifiers().add((Object)this.dropSignal);
        }

        public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
            return new UMLReflectionImpl(){

                public List<EClassifier> getSignals(EClassifier owner) {
                    if (owner == MessagingFruitEnvironment.this.suite.fruit || owner == MessagingFruitEnvironment.this.suite.apple) {
                        return MessagingFruitEnvironment.this.signals;
                    }
                    return super.getSignals(owner);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessagingFruitEnvironmentFactory
    extends EcoreEnvironmentFactory {
        protected final AbstractTestSuite suite;

        public MessagingFruitEnvironmentFactory(AbstractTestSuite suite) {
            this.suite = suite;
        }

        public EcoreEnvironment createEnvironment() {
            return new MessagingFruitEnvironment(this, this.suite);
        }

        public EcoreEnvironment createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            return new MessagingFruitEnvironment(parent, this.suite);
        }
    }
}

