/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.validity.locator.PivotConstraintLocator;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;

public class CompleteOCLCSConstraintLocator
extends PivotConstraintLocator {
    @NonNull
    public static CompleteOCLCSConstraintLocator INSTANCE = new CompleteOCLCSConstraintLocator();

    @Override
    @Nullable
    public Map<EObject, List<LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (Resource resource : resources) {
            EnvironmentFactoryInternal environmentFactory;
            if (monitor.isCanceled()) {
                return null;
            }
            if (!(resource instanceof CSResource) || (environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)resource)) == null) continue;
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject esObject;
                ConstraintCS csConstraint;
                Constraint asConstraint;
                if (monitor.isCanceled()) {
                    return null;
                }
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof ConstraintCS) || (asConstraint = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)(csConstraint = (ConstraintCS)eObject))) == null || (esObject = this.getConstrainedESObject((EnvironmentFactory)environmentFactory, asConstraint)) == null) continue;
                String label = String.valueOf(asConstraint.getName());
                map = this.createLeafConstrainingNode(map, validityModel, esObject, csConstraint, label);
            }
        }
        return map;
    }

    @NonNull
    public EObject getConstrainingType(@NonNull EObject constrainedType, @NonNull Object constrainingObject) {
        EObject eContainer = ((EObject)constrainingObject).eContainer();
        return eContainer != null ? eContainer : constrainedType;
    }

    @Override
    @NonNull
    public ConstraintLocator getInstance() {
        return INSTANCE;
    }

    @Override
    @NonNull
    public String getName() {
        return "Complete OCL CS constraints";
    }

    @Override
    @Nullable
    public String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof ConstraintCS)) {
            return null;
        }
        ConstraintCS csElement = (ConstraintCS)constrainingObject;
        return ElementUtil.getText((ElementCS)csElement);
    }

    @Override
    @Nullable
    public Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof ConstraintCS)) {
            return null;
        }
        ConstraintCS csElement = (ConstraintCS)constrainingObject;
        return csElement.eResource();
    }

    @Override
    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        block6: {
            Severity severity = Severity.UNKNOWN;
            try {
                ConstraintCS csConstraint = (ConstraintCS)result.getLeafConstrainingNode().getConstrainingObject();
                Constraint constraint = (Constraint)csConstraint.getPivot();
                if (constraint == null) break block6;
                EObject eObject = result.getValidatableNode().getConstrainedObject();
                try {
                    PivotEObjectValidator.ValidationAdapter validationAdapter;
                    ResourceSet resourceSet = eObject.eResource().getResourceSet();
                    if (resourceSet != null && (validationAdapter = PivotEObjectValidator.ValidationAdapter.findAdapter((ResourceSet)resourceSet)) != null) {
                        Map context = validityManager.createDefaultContext();
                        context.put(Monitor.class, monitor);
                        Diagnostic diagnostic = validationAdapter.validate(constraint, (Object)eObject, context);
                        result.setDiagnostic((Object)diagnostic);
                        severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
                    }
                }
                catch (Throwable e) {
                    result.setException(e);
                    severity = Severity.FATAL;
                }
            }
            finally {
                result.setSeverity(severity);
            }
        }
    }
}

