/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.locator.ConstraintUILocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.validity.locator.DelegateConstraintLocator;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DelegateUIConstraintLocator
extends DelegateConstraintLocator
implements ConstraintUILocator {
    @NonNull
    public static DelegateUIConstraintLocator INSTANCE = new DelegateUIConstraintLocator();

    public boolean debug(@NonNull ResultConstrainingNode resultConstrainingNode, @NonNull ValidityView validityView, @NonNull IProgressMonitor monitor) throws CoreException {
        EObject constrainedObject = this.getConstrainedObject(resultConstrainingNode);
        Resource eResource = constrainedObject.eResource();
        if (eResource == null) {
            return false;
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)eResource);
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Constraint asConstraint = null;
        try {
            asConstraint = this.getConstraint(metamodelManager, resultConstrainingNode);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        if (asConstraint == null) {
            throw new IllegalStateException("no Pivot Constraint");
        }
        LanguageExpression specification = asConstraint.getOwnedSpecification();
        String expression = specification != null ? PrettyPrinter.print((Element)specification) : "";
        ValidatableNode parent = resultConstrainingNode.getResultValidatableNode().getParent();
        if (parent == null) {
            return false;
        }
        EObject eObject = parent.getConstrainedObject();
        Shell shell = validityView.getSite().getShell();
        if (shell == null) {
            return false;
        }
        DebugStarter runnable = new DebugStarter(shell, environmentFactory, eObject, expression);
        runnable.run(monitor);
        return runnable.getLaunch() != null;
    }

    @Override
    @NonNull
    public ConstraintLocator getInstance() {
        return INSTANCE;
    }

    protected static class DebugStarter
    implements IRunnableWithProgress {
        @NonNull
        protected final Shell shell;
        @NonNull
        protected final EnvironmentFactoryInternal environmentFactory;
        @Nullable
        protected final EObject contextObject;
        @NonNull
        protected final String expression;
        @Nullable
        private ILaunch launch = null;

        public DebugStarter(@NonNull Shell shell, @NonNull EnvironmentFactoryInternal environmentFactory, @Nullable EObject contextObject, @NonNull String expression) {
            this.shell = shell;
            this.environmentFactory = environmentFactory;
            this.contextObject = contextObject;
            this.expression = expression;
        }

        @NonNull
        protected URI createDocument(IProgressMonitor monitor) throws IOException, CoreException {
            IdResolver idResolver = this.environmentFactory.getIdResolver();
            Class staticType = idResolver.getStaticTypeOf((Object)this.contextObject);
            Class contextType = this.environmentFactory.getMetamodelManager().getPrimaryClass(staticType);
            Package contextPackage = contextType.getOwningPackage();
            IPath documentPath = XtextConsolePlugin.getInstance().getStateLocation().append("debug" + EcoreUtil.generateUUID() + ".ocl");
            IFileStore documentStore = EFS.getLocalFileSystem().getStore(documentPath);
            OutputStream documentStream = documentStore.openOutputStream(0, monitor);
            PrettyPrintOptions.Global printOptions = PrettyPrinter.createOptions(null);
            printOptions.addReservedNames((Iterable)PrettyPrinter.restrictedNameList);
            OutputStreamWriter s = new OutputStreamWriter(documentStream);
            String externalURI = null;
            if (contextPackage != null) {
                Model containingRoot = PivotUtil.getContainingModel((EObject)contextPackage);
                if (containingRoot == null) {
                    externalURI = contextPackage.getURI();
                } else if (containingRoot != PivotUtil.getContainingModel((EObject)this.environmentFactory.getStandardLibrary().getOclAnyType()) && PivotUtilInternal.isASURI((String)(externalURI = containingRoot.getExternalURI()))) {
                    URI uri = URI.createURI((String)externalURI);
                    externalURI = PivotUtilInternal.getNonASURI((URI)uri).toString();
                }
                if (externalURI != null) {
                    ((Writer)s).append("import '" + externalURI + "'\n\n");
                }
            }
            ((Writer)s).append("context ");
            if (externalURI == null) {
                ((Writer)s).append("ocl::");
            }
            ((Writer)s).append(String.valueOf(PrettyPrinter.printName((Element)contextType, (PrettyPrintOptions)printOptions)) + "\n");
            ((Writer)s).append("def: oclDebuggerExpression() : OclAny = \n\t");
            ((Writer)s).append(this.expression.replace("\n", "\n\t"));
            ((Writer)s).append("\n");
            ((Writer)s).close();
            java.net.URI documentURI1 = documentStore.toURI();
            URI documentURI2 = URI.createURI((String)documentURI1.toString());
            return documentURI2;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        protected ILaunch launchDebugger(IProgressMonitor monitor, @Nullable EObject contextObject, @NonNull ExpressionInOCL expressionInOCL) throws CoreException {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, "test");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("expressionObject", expressionInOCL);
            attributes.put("contextObject", contextObject);
            launchConfiguration.setAttributes(attributes);
            return launchConfiguration.launch("debug", monitor);
        }

        @Nullable
        protected BaseCSResource loadDocument(IProgressMonitor monitor, @NonNull URI documentURI) throws Exception {
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            Resource resource = resourceSet.getResource(documentURI, true);
            if (resource instanceof BaseCSResource) {
                return (BaseCSResource)resource;
            }
            return null;
        }

        protected void openError(final String message) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)DebugStarter.this.shell, (String)ConsoleMessages.Debug_Starter, (String)message);
                }
            });
        }

        protected void openError(final String message, final @NonNull Exception e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", e.getLocalizedMessage(), (Throwable)e);
                    ErrorDialog.openError((Shell)DebugStarter.this.shell, (String)ConsoleMessages.Debug_Starter, (String)message, (IStatus)status);
                }
            });
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Debug_Starter, (Object)this.expression), 3);
            try {
                ExpressionInOCL query;
                BaseCSResource csResource;
                URI documentURI;
                monitor.subTask(ConsoleMessages.Debug_ProgressCreate);
                try {
                    documentURI = this.createDocument(monitor);
                }
                catch (Exception e) {
                    this.openError(ConsoleMessages.Debug_FailCreate, e);
                    monitor.done();
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                String debug_FailLoad = ConsoleMessages.Debug_FailLoad;
                try {
                    csResource = this.loadDocument(monitor, documentURI);
                }
                catch (Exception e) {
                    this.openError(debug_FailLoad, e);
                    monitor.done();
                    return;
                }
                if (csResource == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)csResource.getErrors())), (String)debug_FailLoad, (String)"\n\t");
                if (message != null) {
                    this.openError(message);
                    return;
                }
                try {
                    query = ElementUtil.getFirstQuery((PivotMetamodelManager)this.environmentFactory.getMetamodelManager(), (BaseCSResource)csResource);
                }
                catch (ParserException e) {
                    this.openError(debug_FailLoad, (Exception)((Object)e));
                    monitor.done();
                    return;
                }
                if (query == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                try {
                    this.launch = this.launchDebugger(monitor, this.contextObject, query);
                }
                catch (CoreException e) {
                    this.openError(ConsoleMessages.Debug_FailLaunch, (Exception)((Object)e));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

