/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.core.OCLLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.actions.BreakpointLocationVerifier;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class VMRunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String invalidLocationMessage;
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        if (input == null) {
            throw new CoreException(DebugVMUIPlugin.createErrorStatus(DebugVMUIMessages.RunToLineAdapter_NoInput));
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocumentProvider provider = textEditor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)input);
        if (document == null) {
            throw new CoreException(DebugVMUIPlugin.createErrorStatus(DebugVMUIMessages.RunToLineAdapter_NoDocument));
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            throw new CoreException(DebugVMUIPlugin.createErrorStatus(DebugVMUIMessages.RunToLineAdapter_NoFile));
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        URI resourceURI = VMDebugCore.getResourceURI((IResource)file);
        OCLLineBreakpoint vmBreakpoint = OCLLineBreakpoint.createRunToLineBreakpoint((URI)resourceURI, (int)lineNumber);
        IStatus verifyStatus = new BreakpointLocationVerifier(textEditor, (ILineBreakpoint)vmBreakpoint, invalidLocationMessage = DebugVMUIMessages.RunToLineAdapter_invalidLocation).run();
        if (!verifyStatus.isOK()) {
            new ErrorDialog(part.getSite().getShell(), null, DebugVMUIMessages.RunToLineAdapter_runFailed, verifyStatus, 8).open();
            return;
        }
        IAdaptable adaptableTarget = (IAdaptable)target;
        IDebugTarget debugTarget = (IDebugTarget)adaptableTarget.getAdapter(IDebugTarget.class);
        if (debugTarget != null) {
            RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)vmBreakpoint);
            handler.run((IProgressMonitor)new NullProgressMonitor());
            return;
        }
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return target instanceof VMDebugElement;
    }
}

