/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.core.OCLLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.actions.BreakpointLocationVerifier;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class VMToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        final ITextEditor oclEditor = (ITextEditor)part;
        IFile unitFile = (IFile)oclEditor.getEditorInput().getAdapter(IResource.class);
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        List breakpoints = OCLDebugCore.INSTANCE.getOCLBreakpoints(ILineBreakpoint.class);
        for (ILineBreakpoint next : breakpoints) {
            if (!unitFile.equals((Object)next.getMarker().getResource()) || next.getLineNumber() != lineNumber) continue;
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)next, true);
            }
            catch (CoreException e) {
                DebugVMUIPlugin.log(e.getStatus());
            }
            next.delete();
            return;
        }
        URI sourceURI = URI.createPlatformResourceURI((String)unitFile.getFullPath().toString(), (boolean)true);
        OCLLineBreakpoint lineBreakpoint = new OCLLineBreakpoint(sourceURI, lineNumber);
        lineBreakpoint.register(true);
        Job job = new Job(DebugVMUIMessages.ToggleBreakpointAdapter_VerifyBreakpointJob, (VMLineBreakpoint)lineBreakpoint){
            private final /* synthetic */ VMLineBreakpoint val$lineBreakpoint;
            {
                this.val$lineBreakpoint = vMLineBreakpoint;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                return new BreakpointLocationVerifier(oclEditor, (ILineBreakpoint)this.val$lineBreakpoint, DebugVMUIMessages.ToggleBreakpointAdapter_CannotSetBreakpoint).run();
            }

            public boolean belongsTo(Object family) {
                return OCLLineBreakpoint.OCL_BREAKPOINT_JOBFAMILY == family;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

