/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.xtext.base.ui.model.DeferredDocumentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.xtext.resource.XtextResource;

public class BaseDocumentProvider
extends DeferredDocumentProvider {
    @Nullable
    private OCLInternal ocl;

    @NonNull
    protected OCLInternal createOCL() {
        return OCLInternal.newInstance();
    }

    protected void disconnected() {
        OCLInternal ocl2 = this.ocl;
        if (ocl2 != null) {
            this.ocl = null;
            ocl2.dispose();
        }
        super.disconnected();
    }

    @NonNull
    protected EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.getOCL().getEnvironmentFactory();
    }

    @NonNull
    protected OCLInternal getOCL() {
        OCLInternal ocl2 = this.ocl;
        if (ocl2 == null) {
            this.ocl = ocl2 = this.createOCL();
        }
        return ocl2;
    }

    protected void loadResource(XtextResource resource, String document, String encoding) throws CoreException {
        ResourceSet resourceSet;
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            this.getEnvironmentFactory().adapt((Notifier)resourceSet);
        }
        super.loadResource(resource, document, encoding);
    }

    @Override
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        IResource resource;
        if (editorInput != null && (resource = (IResource)editorInput.getAdapter(IResource.class)) != null) {
            IProject project = resource.getProject();
            EnvironmentFactoryInternal environmentFactory = this.getEnvironmentFactory();
            environmentFactory.setProject(project);
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }
}

