/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ocl.xtext.base.ui.BaseEditor;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DeferredDocumentProvider
extends XtextDocumentProvider {
    @NonNull
    private Map<IDocument, IEditorInput> document2element = new HashMap<IDocument, IEditorInput>();
    @NonNull
    private Map<IDocument, IDocument> document2document = new HashMap<IDocument, IDocument>();
    @NonNull
    private Map<IDocument, DeferredSetTextJob> document2job = new HashMap<IDocument, DeferredSetTextJob>();
    @NonNull
    private Map<IDocument, TextViewer> document2viewer = new HashMap<IDocument, TextViewer>();

    @NonNull
    protected String getPleaseWaitText() {
        return "/* " + BaseUIMessages.DeferredDocumentProvider_PleaseWait + " */";
    }

    protected void handleElementContentChanged(IFileEditorInput editorInput) {
        super.handleElementContentChanged(editorInput);
        IDocument document = this.getDocument(editorInput);
        DeferredSetTextJob deferredLoadingJob = this.document2job.get(document);
        if (deferredLoadingJob != null) {
            deferredLoadingJob.schedule(100L);
        }
    }

    public void scheduleDeferredSetTextJob(@NonNull BaseEditor baseEditor) {
        TextViewer sourceViewer = baseEditor.getTextViewer();
        IEditorInput editorInput = baseEditor.getEditorInput();
        IDocument document = this.getDocument(editorInput);
        DeferredSetTextJob deferredLoadingJob = this.document2job.get(document);
        if (deferredLoadingJob != null) {
            this.document2viewer.put(document, sourceViewer);
            deferredLoadingJob.schedule(100L);
        }
    }

    @Deprecated
    public void scheduleDeferredSetTextJob(IEditorInput input) {
        IDocument document = this.getDocument(input);
        DeferredSetTextJob deferredLoadingJob = this.document2job.get(document);
        if (deferredLoadingJob != null) {
            deferredLoadingJob.schedule(100L);
        }
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        this.document2element.put(document, editorInput);
        IDocument oldDocument = this.getDocument(editorInput);
        if (oldDocument != null) {
            this.document2document.put(document, oldDocument);
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        assert (document instanceof XtextDocument);
        try {
            int len;
            StringBuilder s = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(contentStream, encoding);
            char[] cbuf = new char[16384];
            while ((len = reader.read(cbuf)) > 0) {
                s.append(cbuf, 0, len);
            }
            String string = s.toString();
            IDocument document2 = this.document2document.get(document);
            if (document2 != null) {
                document = document2;
            }
            DeferredSetTextJob deferredLoadingJob = new DeferredSetTextJob((XtextDocument)document, string);
            this.document2job.put(document, deferredLoadingJob);
            String loading = this.getPleaseWaitText();
            ByteArrayInputStream is = new ByteArrayInputStream(loading.getBytes());
            super.setDocumentContent(document, (InputStream)is, encoding);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.ocl.xtext.base.ui", 0, "Failed to read document", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void setDocumentText(@NonNull XtextDocument document, @NonNull String text) throws CoreException {
        DeferredSetTextRunnable displayRefresh = new DeferredSetTextRunnable(document, text);
        Display.getDefault().asyncExec((Runnable)displayRefresh);
    }

    protected class DeferredSetTextJob
    extends Job {
        @NonNull
        protected final XtextDocument document;
        @NonNull
        protected final String sourceText;

        public DeferredSetTextJob(@NonNull XtextDocument document, String sourceText) {
            super("Deferred Editor SetText");
            this.document = document;
            this.sourceText = sourceText;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Boolean didIt = (Boolean)this.document.modify((IUnitOfWork)new DeferredSetTextUnitOfWork(this.document, this.sourceText));
            if (didIt != Boolean.TRUE) {
                this.schedule(250L);
            }
            return Status.OK_STATUS;
        }
    }

    protected class DeferredSetTextRunnable
    implements Runnable {
        @NonNull
        protected final XtextDocument document;
        @NonNull
        protected final String displayText;

        public DeferredSetTextRunnable(@NonNull XtextDocument document, String displayText) {
            this.displayText = displayText;
            this.document = document;
        }

        @Override
        public void run() {
            this.document.set(this.displayText);
            IEditorInput element = (IEditorInput)DeferredDocumentProvider.this.document2element.get(this.document);
            AbstractDocumentProvider.ElementInfo elementInfo = DeferredDocumentProvider.this.getElementInfo(element);
            if (elementInfo != null) {
                elementInfo.fCanBeSaved = false;
            }
            DeferredDocumentProvider.this.document2element.remove(this.document);
            DeferredDocumentProvider.this.document2job.remove(this.document);
            TextViewer sourceViewer = (TextViewer)DeferredDocumentProvider.this.document2viewer.remove(this.document);
            DeferredDocumentProvider.this.fireElementDirtyStateChanged(element, false);
            if (this.document instanceof BaseDocument && sourceViewer != null) {
                sourceViewer.getUndoManager().connect((ITextViewer)sourceViewer);
            }
        }
    }

    public class DeferredSetTextUnitOfWork
    implements IUnitOfWork<Boolean, XtextResource> {
        @NonNull
        protected final XtextDocument document;
        @NonNull
        protected final String sourceText;

        public DeferredSetTextUnitOfWork(@NonNull XtextDocument document, String sourceText) {
            this.document = document;
            this.sourceText = sourceText;
        }

        public Boolean exec(XtextResource state) throws Exception {
            if (state == null) {
                return Boolean.FALSE;
            }
            DeferredDocumentProvider.this.setDocumentText(this.document, this.sourceText);
            return Boolean.TRUE;
        }
    }
}

