/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.outline;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.actions.OutlineWithEditorLinker;
import org.eclipse.xtext.util.ITextRegion;

public class BaseOutlineWithEditorLinker
extends OutlineWithEditorLinker {
    @NonNull
    public static final TracingOption LOCATE = new TracingOption("org.eclipse.ocl.xtext.base.ui", "outline/locate");
    private static final Logger logger = Logger.getLogger(BaseOutlineWithEditorLinker.class);
    private int depth = 0;

    protected IOutlineNode findBestNode(IOutlineNode input, ITextRegion selectedTextRegion) {
        int savedDepth = this.depth++;
        try {
            if (this.depth > 100) {
                StringBuilder s = new StringBuilder();
                s.append("FindBest limit at ");
                ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)selectedTextRegion, (boolean)true);
                s.append(" " + NameUtil.debugSimpleName((Object)input));
                logger.error((Object)s.toString());
                return null;
            }
            if (LOCATE.isActive()) {
                StringBuilder s = new StringBuilder();
                s.append("FindBest " + this.depth + " at ");
                ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)selectedTextRegion, (boolean)true);
                s.append(" for ");
                ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)input.getFullTextRegion(), (boolean)false);
                s.append(" ");
                ElementUtil.appendTextRegion((StringBuilder)s, (ITextRegion)input.getSignificantTextRegion(), (boolean)true);
                s.append(" ");
                s.append(input);
                LOCATE.println(s.toString());
            }
            IOutlineNode iOutlineNode = super.findBestNode(input, selectedTextRegion);
            return iOutlineNode;
        }
        finally {
            this.depth = savedDepth;
        }
    }
}

