/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ocl.xtext.base.ui.BaseUiPluginHelper;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractFileNewWizard
extends Wizard
implements INewWizard {
    private AbstractFileNewWizardPage wizardPage;

    protected AbstractFileNewWizard() {
        this.setDefaultPageImageDescriptor(BaseUiPluginHelper.getImageDescriptor("icons/OCLModelFile.gif"));
        this.setWindowTitle(this.getPageTitle());
    }

    @NonNull
    protected abstract AbstractFileDialog createDialog(@NonNull AbstractFileNewWizardPage var1, @Nullable IResource var2);

    @NonNull
    public AbstractFileNewWizardPage createNewWizardPage(@Nullable IResource initialSelection) {
        return new AbstractFileNewWizardPage(this, initialSelection);
    }

    protected abstract String getEditorId();

    @NonNull
    public abstract String getInitialContentsAsString(@NonNull IFile var1, @NonNull AbstractFileDialog var2);

    @NonNull
    public abstract String getNewFileExtension();

    @NonNull
    public abstract String getNewFileName();

    @NonNull
    public abstract String getNewFileLabel();

    @NonNull
    public abstract String getPageDescription();

    @NonNull
    public abstract String getPageSummary();

    @NonNull
    public abstract String getPageTitle();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource selectedResource = null;
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                IResource adapter;
                selectedResource = adapter = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
        }
        this.wizardPage = this.createNewWizardPage(selectedResource);
        this.addPage((IWizardPage)this.wizardPage);
    }

    private void openCreatedFile(IFile file) throws PartInitException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage currentPage = activeWorkbenchWindow.getActivePage();
        IDE.openEditor((IWorkbenchPage)currentPage, (IFile)file, (String)this.getEditorId(), (boolean)true);
    }

    public boolean performFinish() {
        IFile file = this.wizardPage.createNewFile();
        try {
            this.openCreatedFile(file);
        }
        catch (PartInitException e) {
            BaseUiPluginHelper.log((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

