/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.IDEValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityViewRefreshJob;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.validity.test.ecoreTest.EcoreTestPackage;
import org.eclipse.ocl.examples.validity.test.ecoreTest2.EcoreTest2Package;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLCSResource;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;

public abstract class AbstractValidityTestCase
extends TestCase {
    @NonNull
    public static final String PLUGIN_ID = "org.eclipse.ocl.examples.validity.test";
    @NonNull
    public static final TracingOption TEST_PROGRESS = new TracingOption("org.eclipse.ocl.examples.validity.test", "test/progress");
    @NonNull
    protected static String TEST_PROJECT_LOCATION;
    @NonNull
    protected static final String OCL_CONSTRAINTS_MODEL = "model/ecore.ocl";
    @NonNull
    protected static final String OCL_CONSTRAINTS_MODEL2 = "model/ecoreTest.ocl";
    @NonNull
    protected static final String ECORE_MODEL_NAME = "model/ecoreTest.ecore";
    @NonNull
    protected static final String ECORE_MODEL_NAME2 = "model/validityModelTest.ecoretest";
    @NonNull
    protected static final String ECORE_MODEL_NAME3 = "model/ecoreTest2.ecore";
    protected static final Integer EXPECTED_SUCCESSES;
    protected static final Integer EXPECTED_INFOS;
    protected static final Integer EXPECTED_WARNINGS;
    protected static final Integer EXPECTED_ERRORS;
    protected static final Integer EXPECTED_FAILURES;
    protected static final Integer EXPECTED_RESULTS;
    @NonNull
    protected static final String CONSTRAINABLE_ECORE = "ecore in http://www.eclipse.org/emf/2002/Ecore";
    @NonNull
    protected static final String CONSTRAINABLE_ECORE_OCL_ECORE = "ecore.ocl";
    @NonNull
    protected static final String CONSTRAINABLE_ECORETEST = "ecoreTest in ecoreTest.ecore";
    @NonNull
    protected static final String CONSTRAINABLE_ECORETEST_OCL_ECORE = "ecoreTest.ocl";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS1_E1_ATT1 = "Eclass1 in validityModelTest.ecoretest";
    @NonNull
    protected static final String CONSTRAINABLE_EATTRIBUTE_CONSTRAINT = "ecore.ocl::ecore::EAttribute::eattribute_constraint";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS_CONSTRAINT = "ecore.ocl::ecore::EClass::eclass_constraint";
    @NonNull
    protected static final String CONSTRAINABLE_EPACKAGE_CONSTRAINT_2 = "ecore.ocl::ecore::EPackage::epackage_constraint_2";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS1_CONSTRAINT = "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint";
    @NonNull
    protected static final String CONSTRAINABLE_EPACKAGE_CONSTRAINT = "ecore.ocl::ecore::EPackage::epackage_constraint";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS2_CONSTRAINT = "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS1 = "ecoreTest::Eclass1";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS2 = "ecoreTest::EClass2";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS3 = "ecoreTest::EClass3";
    @NonNull
    protected static final String CONSTRAINABLE_ECLASS5 = "ecoreTest2::Eclass5";
    @NonNull
    protected static final String VALIDATABLE_ECORE_TEST = "ecoreTest in ecoreTest.ecore";
    @NonNull
    protected static final String VALIDATABLE_ECORETEST2 = "ecoreTest2 in ecoreTest2.ecore";
    @NonNull
    protected static final String VALIDATABLE_ECLASS1_E1_ATT1 = "Eclass1 in validityModelTest.ecoretest";
    @NonNull
    protected static final String VALIDATABLE_E_CLASS3_ECLASS5 = "ecoreTest::EClass3";
    @NonNull
    protected static final String VALIDATABLE_ECLASS2 = "EClass2";
    @NonNull
    protected static final String VALIDATABLE_E_CLASS5 = "Eclass5";
    @NonNull
    protected static final String VALIDATABLE_E_CLASS2 = "Eclass1::EClass2";
    @NonNull
    protected static final String VALIDATABLE_E_ATTRIBUTE4_E_STRING = "ecoreTest::EClass2::eAttribute4";
    @NonNull
    protected static final String VALIDATABLE_E_ATTRIBUTE2_E_STRING = "ecoreTest::Eclass1::eAttribute2";
    @NonNull
    protected static final String VALIDATABLE_E_ATTRIBUTE1_E_STRING = "ecoreTest::Eclass1::eAttribute1";
    @NonNull
    protected static final String VALIDATABLE_E_ATTRIBUTE3_E_SHORT = "ecoreTest::EClass2::eAttribute3";
    @NonNull
    protected static final String VALIDATABLE_E_ATTRIBUTE5_E_STRING = "ecoreTest2::Eclass5::eAttribute5";
    @NonNull
    protected static final String TITLE_E_ATTRIBUTE5_E_STRING = "eAttribute5";
    private static ProjectMap projectMap;
    protected OCL ocl;
    protected Resource ecoreResource;
    protected Resource ecoreResource2;
    protected Resource ecoreResource3;
    protected Resource oclResource;
    protected Resource oclResource2;
    protected PivotEObjectValidator.ValidationAdapter validationAdapter;
    protected ValidityModel validityModel;
    protected ValidityManager validityManager;
    protected RootNode rootNode;
    protected ResultSet resultSet;

    static {
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            TEST_PROJECT_LOCATION = "platform:/plugin/org.eclipse.ocl.examples.validity.test";
        } else {
            StandaloneProjectMap projectMap = new StandaloneProjectMap(false);
            ProjectManager.IProjectDescriptor projectDescriptor = projectMap.getProjectDescriptor(PLUGIN_ID);
            TEST_PROJECT_LOCATION = projectDescriptor.getLocationURI().toString();
            if (TEST_PROJECT_LOCATION.endsWith("/")) {
                TEST_PROJECT_LOCATION = TEST_PROJECT_LOCATION.substring(0, TEST_PROJECT_LOCATION.length() - 1);
            }
        }
        EXPECTED_SUCCESSES = 145;
        EXPECTED_INFOS = 2;
        EXPECTED_WARNINGS = 2;
        EXPECTED_ERRORS = 2;
        EXPECTED_FAILURES = 2;
        EXPECTED_RESULTS = EXPECTED_SUCCESSES + EXPECTED_INFOS + EXPECTED_WARNINGS + EXPECTED_ERRORS + EXPECTED_FAILURES;
        projectMap = null;
    }

    public static ConstrainingNode getConstrainingNodeByLabel(@NonNull Iterable<? extends ConstrainingNode> rootNodeChildren, @NonNull String label) {
        boolean matchPrefix = label.endsWith(" -> ");
        String labelSpace = String.valueOf(label) + " ";
        for (ConstrainingNode constrainingNode : rootNodeChildren) {
            String nodeLabel = constrainingNode.getLabel();
            if (!(matchPrefix ? nodeLabel.startsWith(labelSpace) : label.equals(nodeLabel))) continue;
            return constrainingNode;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ConstrainingNode constrainingNode : rootNodeChildren) {
            arrayList.add("'" + constrainingNode.getLabel() + "'");
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("No '" + label + "' label found in");
        for (String stringResult : arrayList) {
            stringBuilder.append("\n\t" + stringResult);
        }
        AbstractValidityTestCase.fail((String)stringBuilder.toString());
        return null;
    }

    public static ProjectMap getProjectMap() {
        if (projectMap == null) {
            projectMap = new ProjectMap(false);
        }
        return projectMap;
    }

    public static Result getResultFromResultValidatableNode(@NonNull Iterable<Result> validatableNodeResults, @NonNull String label) {
        for (Result resultIterated : validatableNodeResults) {
            if (!label.equals(resultIterated.getResultValidatableNode().getLabel())) continue;
            return resultIterated;
        }
        return null;
    }

    public static Result getResultOfValidatableNodeFromLabel(@NonNull Iterable<Result> results, @NonNull String labelValidatableNode, @NonNull String labelResultConstrainingNode) {
        for (Result resultIter : results) {
            if (!labelValidatableNode.equals(resultIter.getResultValidatableNode().getLabel()) || !labelResultConstrainingNode.equals(resultIter.getResultConstrainingNode().getLabel())) continue;
            return resultIter;
        }
        ArrayList<String> stringResults = new ArrayList<String>();
        for (Result resultIter : results) {
            stringResults.add("'" + resultIter.getResultValidatableNode().getLabel() + "' + '" + resultIter.getResultConstrainingNode().getLabel() + "'");
        }
        Collections.sort(stringResults);
        StringBuilder s = new StringBuilder();
        s.append("No '" + labelValidatableNode + "' + '" + labelResultConstrainingNode + "' label combination found in");
        for (String stringResult : stringResults) {
            s.append("\n\t" + stringResult);
        }
        AbstractValidityTestCase.fail((String)s.toString());
        return null;
    }

    @NonNull
    public static URI getTestModelURI(@NonNull String localFileName) {
        ProjectMap projectMap = AbstractValidityTestCase.getProjectMap();
        String urlString = projectMap.getLocation(PLUGIN_ID).toString();
        return (URI)ClassUtil.nonNullEMF((Object)URI.createURI((String)(String.valueOf(urlString) + localFileName)));
    }

    public static ValidatableNode getValidatableNodeByLabel(@NonNull Iterable<? extends ValidatableNode> validatableNodes, @NonNull String label) {
        for (ValidatableNode validatableNode : validatableNodes) {
            if (!label.equals(validatableNode.getLabel())) continue;
            return validatableNode;
        }
        return null;
    }

    public static boolean isCompleteOCLCSResourcePresent(@NonNull Iterable<Resource> resources) {
        for (Resource resource : resources) {
            if (!(resource instanceof CompleteOCLCSResource)) continue;
            return true;
        }
        return false;
    }

    public void initTestModels() throws Exception {
        ResourceSet resourceSet = this.ocl.getResourceSet();
        URI ecoreURI = AbstractValidityTestCase.getTestModelURI(ECORE_MODEL_NAME);
        URI ecoreURI2 = AbstractValidityTestCase.getTestModelURI(ECORE_MODEL_NAME2);
        URI ecoreURI3 = AbstractValidityTestCase.getTestModelURI(ECORE_MODEL_NAME3);
        URI oclURI = AbstractValidityTestCase.getTestModelURI(OCL_CONSTRAINTS_MODEL);
        URI oclURI2 = AbstractValidityTestCase.getTestModelURI(OCL_CONSTRAINTS_MODEL2);
        this.ecoreResource = resourceSet.getResource(ecoreURI, true);
        this.ecoreResource2 = resourceSet.getResource(ecoreURI2, true);
        this.ecoreResource3 = resourceSet.getResource(ecoreURI3, true);
        CompleteOCLLoader helper = new CompleteOCLLoader(this.ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                return false;
            }
        };
        this.oclResource = helper.loadResource(oclURI);
        this.oclResource2 = helper.loadResource(oclURI2);
        AbstractValidityTestCase.assertTrue((boolean)helper.loadMetamodels());
        helper.installPackages();
        this.validationAdapter = PivotEObjectValidator.ValidationAdapter.findAdapter((ResourceSet)resourceSet);
        AbstractValidityTestCase.assertNotNull((Object)this.validationAdapter);
        helper.dispose();
    }

    protected void initValidityManager(@Nullable ValidityManager validityManager) {
        if (validityManager == null) {
            validityManager = new IDEValidityManager(new ValidityViewRefreshJob());
        }
        this.validityManager = validityManager;
        validityManager.setInput((Object)this.ocl.getResourceSet());
        this.rootNode = validityManager.getRootNode();
        this.validityModel = validityManager.getModel();
        this.resultSet = this.validityModel.createResultSet((IProgressMonitor)new NullProgressMonitor());
    }

    protected void setUp() throws Exception {
        if (TEST_PROGRESS.isActive()) {
            TEST_PROGRESS.println("-----Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "-----");
        }
        super.setUp();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompleteOCLStandaloneSetup.doSetup();
            EcoreTestPackage.eINSTANCE.getClass();
            EcoreTest2Package.eINSTANCE.getClass();
            ValidityExporterRegistry.initialize((ValidityExporterRegistry)ValidityExporterRegistry.INSTANCE);
            AbstractPivotConstraintLocator.initialize();
        }
        this.ocl = OCL.newInstance((ProjectManager)OCL.NO_PROJECTS);
    }

    public void tearDown() throws Exception {
        this.ocl.dispose();
        this.ocl = null;
        this.validationAdapter = null;
        this.rootNode = null;
        this.ecoreResource = null;
        this.validityModel = null;
        if (this.validityManager != null) {
            this.validityManager.dispose();
            this.validityManager = null;
            TEST_PROGRESS.println("-validityManager");
        }
        if (TEST_PROGRESS.isActive()) {
            TEST_PROGRESS.println("==> Finish " + this.getName());
        }
    }
}

