/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.validity.test.AbstractValidityTestCase;
import org.eclipse.ocl.examples.validity.test.ecoreTest.EClass2;
import org.eclipse.ocl.examples.validity.test.ecoreTest.impl.Eclass1Impl;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.completeoclcs.PackageDeclarationCS;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ValidityModelTests
extends AbstractValidityTestCase {
    @NonNull
    protected ConstrainingNode assertHasConstrainingNodeByLabel(@NonNull ConstrainingNode constrainingNode, @NonNull String label, @NonNull Class<?> constrainingClass) {
        ConstrainingNode containedConstrainingNode = ValidityModelTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)constrainingNode.getChildren(), label);
        ValidityModelTests.assertNotNull((Object)containedConstrainingNode);
        Class<?> constrainingObjectClass = containedConstrainingNode.getConstrainingObject().getClass();
        if (!constrainingClass.isAssignableFrom(constrainingObjectClass)) {
            ValidityModelTests.fail((String)(String.valueOf(constrainingClass.getName()) + " is not assignable from " + constrainingObjectClass.getName()));
        }
        return containedConstrainingNode;
    }

    @NonNull
    protected ConstrainingNode assertHasConstrainingNodeByLabel(@NonNull RootNode rootNode, @NonNull String label, @NonNull Class<?> constrainingClass) {
        ConstrainingNode containedConstrainingNode = ValidityModelTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)rootNode.getConstrainingNodes(), label);
        ValidityModelTests.assertNotNull((Object)containedConstrainingNode);
        Class<?> constrainingObjectClass = containedConstrainingNode.getConstrainingObject().getClass();
        if (!constrainingClass.isAssignableFrom(constrainingObjectClass)) {
            ValidityModelTests.fail((String)(String.valueOf(constrainingClass.getName()) + " is not assignable from " + constrainingObjectClass.getName()));
        }
        return containedConstrainingNode;
    }

    @NonNull
    protected List<? extends ConstrainingNode> assertHasConstrainingNodes(@NonNull ConstrainingNode constrainingNode, int expectedChildCount) {
        EList children = constrainingNode.getChildren();
        ValidityModelTests.assertEquals((String)("Expected child count for " + constrainingNode), (int)expectedChildCount, (int)children.size());
        return children;
    }

    @NonNull
    protected List<? extends ConstrainingNode> assertHasConstrainingNodes(@NonNull RootNode rootNode, int expectedChildCount) {
        EList children = rootNode.getConstrainingNodes();
        ValidityModelTests.assertEquals((String)("Expected child count for " + rootNode), (int)expectedChildCount, (int)children.size());
        return children;
    }

    @NonNull
    protected LeafConstrainingNode assertHasLeafConstrainingNodeByLabel(@NonNull ConstrainingNode constrainingNode, @NonNull String label) {
        ConstrainingNode containedConstrainingNode = ValidityModelTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)constrainingNode.getChildren(), label);
        ValidityModelTests.assertTrue((boolean)(containedConstrainingNode instanceof LeafConstrainingNode));
        return (LeafConstrainingNode)containedConstrainingNode;
    }

    @NonNull
    protected ResultConstrainingNode assertHasResultConstrainingNodeByLabel(@NonNull ConstrainingNode constrainingNode, @NonNull String label) {
        ConstrainingNode containedConstrainingNode = ValidityModelTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)constrainingNode.getChildren(), label);
        ValidityModelTests.assertTrue((boolean)(containedConstrainingNode instanceof ResultConstrainingNode));
        ValidityModelTests.assertTrue((containedConstrainingNode.getConstrainingObject() == null ? 1 : 0) != 0);
        return (ResultConstrainingNode)containedConstrainingNode;
    }

    @NonNull
    protected List<? extends ValidatableNode> assertHasValidatableNodes(@NonNull RootNode rootNode, int expectedChildCount) {
        EList children = rootNode.getValidatableNodes();
        ValidityModelTests.assertEquals((String)("Expected child count for " + rootNode), (int)expectedChildCount, (int)children.size());
        return children;
    }

    @NonNull
    protected List<? extends ValidatableNode> assertHasValidatableNodes(@NonNull ValidatableNode validatableNode, int expectedChildCount) {
        EList children = validatableNode.getChildren();
        ValidityModelTests.assertEquals((String)("Expected child count for " + validatableNode), (int)expectedChildCount, (int)children.size());
        return children;
    }

    @NonNull
    protected ValidatableNode assertHasValidatableNodeByLabel(@NonNull RootNode rootNode, @NonNull String label, @NonNull Class<?> constrainingClass) {
        ValidatableNode containedValidatableNode = ValidityModelTests.getValidatableNodeByLabel((Iterable<? extends ValidatableNode>)rootNode.getValidatableNodes(), label);
        ValidityModelTests.assertNotNull((Object)containedValidatableNode);
        ValidityModelTests.assertTrue((boolean)constrainingClass.isAssignableFrom(containedValidatableNode.getConstrainedObject().getClass()));
        return containedValidatableNode;
    }

    @NonNull
    protected ValidatableNode assertHasValidatableNodeByLabel(@NonNull ValidatableNode validatableNode, @NonNull String label, @NonNull Class<?> constrainingClass) {
        ValidatableNode containedValidatableNode = ValidityModelTests.getValidatableNodeByLabel((Iterable<? extends ValidatableNode>)validatableNode.getChildren(), label);
        ValidityModelTests.assertNotNull((Object)containedValidatableNode);
        ValidityModelTests.assertTrue((boolean)constrainingClass.isAssignableFrom(containedValidatableNode.getConstrainedObject().getClass()));
        return containedValidatableNode;
    }

    @NonNull
    protected ResultValidatableNode assertHasResultValidatableNodeByLabel(@NonNull ValidatableNode validatableNode, @NonNull String label) {
        ValidatableNode containedValidatableNode = ValidityModelTests.getValidatableNodeByLabel((Iterable<? extends ValidatableNode>)validatableNode.getChildren(), label);
        ValidityModelTests.assertTrue((boolean)(containedValidatableNode instanceof ResultValidatableNode));
        ValidityModelTests.assertNull((Object)containedValidatableNode.getConstrainedObject());
        return (ResultValidatableNode)containedValidatableNode;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initTestModels();
        this.initValidityManager(EMFPlugin.IS_ECLIPSE_RUNNING ? null : new ValidityManager());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testValidityModel_AllResourcesArePresent() {
        Collection resources = this.validityModel.getResources();
        ValidityModelTests.assertEquals((Object)5, (Object)resources.size());
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource));
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource2));
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource3));
        ValidityModelTests.assertTrue((boolean)ValidityModelTests.isCompleteOCLCSResourcePresent(resources));
    }

    @Test
    public void testValidityModelInitialization_RootValidatableNodesArePresent() {
        ValidatableNode _e1Att1 = this.assertHasValidatableNodeByLabel(this.rootNode, "Eclass1 in validityModelTest.ecoretest", Eclass1Impl.class);
        this.assertHasValidatableNodes(_e1Att1, 3);
        this.assertHasResultValidatableNodeByLabel(_e1Att1, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint");
        ValidatableNode _e1Att1__EClass2 = this.assertHasValidatableNodeByLabel(_e1Att1, "EClass2", EClass2.class);
        this.assertHasValidatableNodes(_e1Att1__EClass2, 1);
        this.assertHasResultValidatableNodeByLabel(_e1Att1__EClass2, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint");
        ValidatableNode containedValidatableNode2 = this.assertHasValidatableNodeByLabel(_e1Att1, "EClass2", EClass2.class);
        this.assertHasValidatableNodes(containedValidatableNode2, 1);
        this.assertHasResultValidatableNodeByLabel(containedValidatableNode2, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint");
        ValidatableNode _ecoreTest2 = this.assertHasValidatableNodeByLabel(this.rootNode, "ecoreTest2 in ecoreTest2.ecore", EPackage.class);
        this.assertHasValidatableNodes(_ecoreTest2, 9);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2, "ecore.ocl::ecore::EPackage::epackage_constraint_2");
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2, "ecore.ocl::ecore::EPackage::epackage_constraint");
        ValidatableNode _ecoreTest2__Eclass5 = this.assertHasValidatableNodeByLabel(_ecoreTest2, "Eclass5", EClass.class);
        this.assertHasValidatableNodes(_ecoreTest2__Eclass5, 13);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2__Eclass5, "ecore.ocl::ecore::EClass::eclass_constraint");
        ValidatableNode _ecoreTest2__Eclass5__eAttribute5 = this.assertHasValidatableNodeByLabel(_ecoreTest2__Eclass5, "eAttribute5", EAttribute.class);
        this.assertHasValidatableNodes(_ecoreTest2__Eclass5__eAttribute5, 9);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2__Eclass5__eAttribute5, "ecore.ocl::ecore::EAttribute::eattribute_constraint");
    }

    @Test
    public void testValidityModelInitializationModelElements() {
        ValidatableNode _e1Att1 = this.assertHasValidatableNodeByLabel(this.rootNode, "Eclass1 in validityModelTest.ecoretest", Eclass1Impl.class);
        this.assertHasValidatableNodes(_e1Att1, 3);
        this.assertHasResultValidatableNodeByLabel(_e1Att1, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint");
        ValidatableNode _e1Att1__EClass2 = this.assertHasValidatableNodeByLabel(_e1Att1, "EClass2", EClass2.class);
        ValidityModelTests.assertTrue((boolean)(_e1Att1__EClass2.getConstrainedObject() instanceof EClass2));
        this.assertHasValidatableNodes(_e1Att1__EClass2, 1);
        this.assertHasResultValidatableNodeByLabel(_e1Att1__EClass2, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint");
        ValidatableNode containedValidatableNode2 = this.assertHasValidatableNodeByLabel(_e1Att1, "EClass2", EClass2.class);
        this.assertHasValidatableNodes(containedValidatableNode2, 1);
        this.assertHasResultValidatableNodeByLabel(containedValidatableNode2, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint");
        ValidatableNode _ecoreTest2 = this.assertHasValidatableNodeByLabel(this.rootNode, "ecoreTest2 in ecoreTest2.ecore", EPackage.class);
        this.assertHasValidatableNodes(_ecoreTest2, 9);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2, "ecore.ocl::ecore::EPackage::epackage_constraint_2");
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2, "ecore.ocl::ecore::EPackage::epackage_constraint");
        ValidatableNode _ecoreTest2__Eclass5 = this.assertHasValidatableNodeByLabel(_ecoreTest2, "Eclass5", EClass.class);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2__Eclass5, "ecore.ocl::ecore::EClass::eclass_constraint");
        ValidatableNode _ecoreTest2__Eclass5__eAttribute5 = this.assertHasValidatableNodeByLabel(_ecoreTest2__Eclass5, "eAttribute5", EAttribute.class);
        this.assertHasValidatableNodes(_ecoreTest2__Eclass5__eAttribute5, 9);
        this.assertHasResultValidatableNodeByLabel(_ecoreTest2__Eclass5__eAttribute5, "ecore.ocl::ecore::EAttribute::eattribute_constraint");
    }

    @Test
    public void testValidityModelInitializationConstraints() {
        Collection resources = this.validityModel.getResources();
        ValidityModelTests.assertEquals((Object)5, (Object)resources.size());
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource));
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource2));
        ValidityModelTests.assertTrue((boolean)resources.contains(this.ecoreResource3));
        ValidityModelTests.assertTrue((boolean)ValidityModelTests.isCompleteOCLCSResourcePresent(resources));
        this.assertHasConstrainingNodes(this.rootNode, 3);
        ConstrainingNode _ecore = this.assertHasConstrainingNodeByLabel(this.rootNode, "ecore in http://www.eclipse.org/emf/2002/Ecore", EPackage.class);
        this.assertHasConstrainingNodes(_ecore, 45);
        ConstrainingNode _ecore__EClass = this.assertHasConstrainingNodeByLabel(_ecore, "EClass", EClass.class);
        this.assertHasConstrainingNodes(_ecore__EClass, 8);
        ConstrainingNode _ecore__EPackage = this.assertHasConstrainingNodeByLabel(_ecore, "EPackage", EClass.class);
        this.assertHasConstrainingNodes(_ecore__EPackage, 5);
        ConstrainingNode _ecore_ocl = this.assertHasConstrainingNodeByLabel(this.rootNode, "ecore.ocl", CompleteOCLDocumentCS.class);
        this.assertHasConstrainingNodes(_ecore_ocl, 1);
        ConstrainingNode _ecore_ocl_ecore = this.assertHasConstrainingNodeByLabel(_ecore_ocl, "ecore", PackageDeclarationCS.class);
        this.assertHasConstrainingNodes(_ecore_ocl_ecore, 3);
        ConstrainingNode _ecore_ocl_ecore__EClass = this.assertHasConstrainingNodeByLabel(_ecore_ocl_ecore, "EClass", ClassifierContextDeclCS.class);
        this.assertHasConstrainingNodes(_ecore_ocl_ecore__EClass, 1);
        LeafConstrainingNode _ecore_ocl_ecore__EClass__eclass_constraint = this.assertHasLeafConstrainingNodeByLabel(_ecore_ocl_ecore__EClass, "eclass_constraint");
        ValidityModelTests.assertTrue((boolean)(_ecore_ocl_ecore__EClass__eclass_constraint.getConstrainingObject() instanceof ConstraintCS));
        this.assertHasConstrainingNodes((ConstrainingNode)_ecore_ocl_ecore__EClass__eclass_constraint, 4);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EClass__eclass_constraint, "ecoreTest::Eclass1");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EClass__eclass_constraint, "ecoreTest2::Eclass5");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EClass__eclass_constraint, "ecoreTest::EClass2");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EClass__eclass_constraint, "ecoreTest::EClass3");
        ConstrainingNode _ecore_ocl_ecore__EPackage = this.assertHasConstrainingNodeByLabel(_ecore_ocl_ecore, "EPackage", ClassifierContextDeclCS.class);
        this.assertHasConstrainingNodes(_ecore_ocl_ecore__EPackage, 2);
        LeafConstrainingNode _ecore_ocl_ecore__EPackage__epackage_constraint = this.assertHasLeafConstrainingNodeByLabel(_ecore_ocl_ecore__EPackage, "epackage_constraint");
        this.assertHasConstrainingNodes((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint, 2);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint, "ecoreTest in ecoreTest.ecore");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint, "ecoreTest2 in ecoreTest2.ecore");
        LeafConstrainingNode _ecore_ocl_ecore__EPackage__epackage_constraint_2 = this.assertHasLeafConstrainingNodeByLabel(_ecore_ocl_ecore__EPackage, "epackage_constraint_2");
        this.assertHasConstrainingNodes((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint_2, 2);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint_2, "ecoreTest in ecoreTest.ecore");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EPackage__epackage_constraint_2, "ecoreTest2 in ecoreTest2.ecore");
        ConstrainingNode _ecore_ocl_ecore__EAttribute = this.assertHasConstrainingNodeByLabel(_ecore_ocl_ecore, "EAttribute", ClassifierContextDeclCS.class);
        this.assertHasConstrainingNodes(_ecore_ocl_ecore__EAttribute, 1);
        LeafConstrainingNode _ecore_ocl_ecore__EAttribute__eattribute_constraint = this.assertHasLeafConstrainingNodeByLabel(_ecore_ocl_ecore__EAttribute, "eattribute_constraint");
        this.assertHasConstrainingNodes((ConstrainingNode)_ecore_ocl_ecore__EAttribute__eattribute_constraint, 5);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EAttribute__eattribute_constraint, "ecoreTest::Eclass1::eAttribute1");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EAttribute__eattribute_constraint, "ecoreTest::Eclass1::eAttribute2");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EAttribute__eattribute_constraint, "ecoreTest::EClass2::eAttribute3");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecore_ocl_ecore__EAttribute__eattribute_constraint, "ecoreTest2::Eclass5::eAttribute5");
        ConstrainingNode _ecoreTest = this.assertHasConstrainingNodeByLabel(this.rootNode, "ecoreTest.ocl", CompleteOCLDocumentCS.class);
        this.assertHasConstrainingNodes(_ecoreTest, 1);
        ConstrainingNode _ecoreTest_ecoreTest = this.assertHasConstrainingNodeByLabel(_ecoreTest, "ecoreTest", PackageDeclarationCS.class);
        this.assertHasConstrainingNodes(_ecoreTest_ecoreTest, 2);
        ConstrainingNode _ecoreTest__Eclass1 = this.assertHasConstrainingNodeByLabel(_ecoreTest_ecoreTest, "Eclass1", ClassifierContextDeclCS.class);
        this.assertHasConstrainingNodes(_ecoreTest__Eclass1, 1);
        LeafConstrainingNode _ecoreTest__Eclass1__eclass1_constraint = this.assertHasLeafConstrainingNodeByLabel(_ecoreTest__Eclass1, "eclass1_constraint");
        this.assertHasConstrainingNodes((ConstrainingNode)_ecoreTest__Eclass1__eclass1_constraint, 1);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecoreTest__Eclass1__eclass1_constraint, "Eclass1 in validityModelTest.ecoretest");
        ConstrainingNode _ecoreTest__EClass2 = this.assertHasConstrainingNodeByLabel(_ecoreTest_ecoreTest, "EClass2", ClassifierContextDeclCS.class);
        this.assertHasConstrainingNodes(_ecoreTest__EClass2, 1);
        LeafConstrainingNode _ecoreTest__EClass2__eclass2_constraint = this.assertHasLeafConstrainingNodeByLabel(_ecoreTest__EClass2, "eclass2_constraint");
        this.assertHasConstrainingNodes((ConstrainingNode)_ecoreTest__EClass2__eclass2_constraint, 2);
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecoreTest__EClass2__eclass2_constraint, "Eclass1::EClass2");
        this.assertHasResultConstrainingNodeByLabel((ConstrainingNode)_ecoreTest__EClass2__eclass2_constraint, "Eclass1::EClass2");
    }

    @Test
    public void testValidityModelCreateResultSet() {
        ResultSet resultSet = this.validityManager.createResultSet((IProgressMonitor)new NullProgressMonitor());
        EList results = resultSet.getResults();
        for (Result result : results) {
            ResultValidatableNode resultValidatableNode = result.getResultValidatableNode();
            ValidityModelTests.assertNotNull((Object)resultValidatableNode);
            ResultConstrainingNode resultConstrainingNode = resultValidatableNode.getResultConstrainingNode();
            ValidityModelTests.assertNotNull((Object)resultConstrainingNode);
            ValidityModelTests.assertEquals((Object)resultValidatableNode, (Object)resultConstrainingNode.getResultValidatableNode());
        }
        ValidityModelTests.assertEquals((Object)EXPECTED_RESULTS, (Object)results.size());
    }
}

