/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqual2Exp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsEqualExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class AnalysisVisitor
extends AbstractExtendingCGModelVisitor<Object, CodeGenAnalyzer> {
    public AnalysisVisitor(@NonNull CodeGenAnalyzer analyzer) {
        super(analyzer);
    }

    @Override
    @Nullable
    public Object visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        super.visitCGCollectionExp(cgCollectionExp);
        CGInvalid cgInvalidValue = cgCollectionExp.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgCollectionExp, cgInvalidValue);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIfExp(@NonNull CGIfExp cgIfExp) {
        super.visitCGIfExp(cgIfExp);
        CGValuedElement cgCondition = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getCondition());
        CGInvalid cgInvalidValue = cgCondition.getInvalidValue();
        if (cgInvalidValue != null) {
            CGUtil.replace(cgIfExp, cgInvalidValue);
        } else if (cgCondition.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIfExp, ((CodeGenAnalyzer)this.context).getInvalid("Null cgCondition", new Object[0]));
        } else if (cgCondition.isTrue()) {
            CGValuedElement cgThen = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getThenExpression());
            ((CodeGenAnalyzer)this.context).replace(cgIfExp, cgThen, "Null then-expression", new Object[0]);
        } else if (cgCondition.isFalse()) {
            CGValuedElement cgElse = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getElseExpression());
            ((CodeGenAnalyzer)this.context).replace(cgIfExp, cgElse, "Null else-expression", new Object[0]);
        } else if (cgCondition.isConstant()) {
            ElementId asTypeId = cgCondition.getTypeId().getElementId();
            ((CodeGenAnalyzer)this.context).setConstant(cgIfExp, ((CodeGenAnalyzer)this.context).getInvalid(PivotMessages.TypedValueRequired, "Boolean", asTypeId));
        } else {
            CGValuedElement cgElse;
            CGValuedElement cgThen = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getThenExpression());
            if (cgThen.isEquivalentTo(cgElse = ((CodeGenAnalyzer)this.context).getExpression(cgIfExp.getElseExpression())) == Boolean.TRUE) {
                ((CodeGenAnalyzer)this.context).replace(cgIfExp, cgThen, "Null then/else-expression", new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsEqualExp(@NonNull CGIsEqualExp cgIsEqualExp) {
        super.visitCGIsEqualExp(cgIsEqualExp);
        CGValuedElement cgSource = cgIsEqualExp.getSource();
        if (cgSource == null) {
            return null;
        }
        CGValuedElement cgArgument = cgIsEqualExp.getArgument();
        if (cgArgument == null) {
            return null;
        }
        CGInvalid cgInvalidValue = cgSource.getInvalidValue();
        if (cgInvalidValue == null) {
            cgInvalidValue = cgArgument.getInvalidValue();
        }
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqualExp, cgInvalidValue);
        } else {
            CGValuedElement cgArgumentValue;
            CGValuedElement cgSourceValue = cgSource.getNamedValue();
            Boolean isEqual = cgSourceValue.isEquivalentTo(cgArgumentValue = cgArgument.getNamedValue());
            if (isEqual == Boolean.TRUE) {
                ((CodeGenAnalyzer)this.context).setConstant(cgIsEqualExp, ((CodeGenAnalyzer)this.context).getBoolean(!cgIsEqualExp.isNotEquals()));
            } else if (isEqual == Boolean.FALSE) {
                ((CodeGenAnalyzer)this.context).setConstant(cgIsEqualExp, ((CodeGenAnalyzer)this.context).getBoolean(cgIsEqualExp.isNotEquals()));
            } else if (cgSource.isTrue() && cgArgument.isNonNull() && cgArgument.getASTypeId() == TypeId.BOOLEAN) {
                ((CodeGenAnalyzer)this.context).replace(cgIsEqualExp, cgArgument, "Null term", new Object[0]);
            } else if (cgArgument.isTrue() && cgSource.isNonNull() && cgSource.getASTypeId() == TypeId.BOOLEAN) {
                ((CodeGenAnalyzer)this.context).replace(cgIsEqualExp, cgSource, "Null term", new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsEqual2Exp(@NonNull CGIsEqual2Exp cgIsEqual2Exp) {
        CGValuedElement cgArgumentValue;
        super.visitCGIsEqual2Exp(cgIsEqual2Exp);
        CGValuedElement cgSource = cgIsEqual2Exp.getSource();
        if (cgSource == null) {
            return null;
        }
        CGValuedElement cgArgument = cgIsEqual2Exp.getArgument();
        if (cgArgument == null) {
            return null;
        }
        CGInvalid cgInvalidValue1 = cgSource.getInvalidValue();
        CGInvalid cgInvalidValue2 = cgArgument.getInvalidValue();
        if (cgInvalidValue1 != null && cgInvalidValue2 != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(true));
            return null;
        }
        if (cgInvalidValue1 != null && cgArgument.isNonInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(false));
            return null;
        }
        if (cgInvalidValue2 != null && cgSource.isNonInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(false));
            return null;
        }
        boolean isNull1 = cgSource.isNull();
        boolean isNull2 = cgArgument.isNull();
        if (isNull1 && isNull2) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(true));
            return null;
        }
        if (isNull1 && cgArgument.isNonNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(false));
            return null;
        }
        if (isNull2 && cgSource.isNonNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(false));
            return null;
        }
        CGValuedElement cgSourceValue = cgSource.getNamedValue();
        Boolean isEqual = cgSourceValue.isEquivalentTo(cgArgumentValue = cgArgument.getNamedValue());
        if (isEqual == Boolean.TRUE) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(true));
        } else if (isEqual == Boolean.FALSE) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsEqual2Exp, ((CodeGenAnalyzer)this.context).getBoolean(false));
        } else if (cgSource.isTrue() && cgArgument.isNonNull() && cgArgument.getASTypeId() == TypeId.BOOLEAN) {
            ((CodeGenAnalyzer)this.context).replace(cgIsEqual2Exp, cgArgument, "Null term", new Object[0]);
        } else if (cgArgument.isTrue() && cgSource.isNonNull() && cgSource.getASTypeId() == TypeId.BOOLEAN) {
            ((CodeGenAnalyzer)this.context).replace(cgIsEqual2Exp, cgSource, "Null term", new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgIsInvalidExp) {
        super.visitCGIsInvalidExp(cgIsInvalidExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgIsInvalidExp.getSource());
        if (cgSource.isInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsInvalidExp, ((CodeGenAnalyzer)this.context).getBoolean(true));
        } else if (cgSource.isNonInvalid()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsInvalidExp, ((CodeGenAnalyzer)this.context).getBoolean(false));
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgIsUndefinedExp) {
        super.visitCGIsUndefinedExp(cgIsUndefinedExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgIsUndefinedExp.getSource());
        if (cgSource.isInvalid() || cgSource.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsUndefinedExp, ((CodeGenAnalyzer)this.context).getBoolean(true));
        } else if (cgSource.isNonInvalid() && cgSource.isNonNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIsUndefinedExp, ((CodeGenAnalyzer)this.context).getBoolean(false));
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        super.visitCGLetExp(cgLetExp);
        CGValuedElement cgIn = ((CodeGenAnalyzer)this.context).getExpression(cgLetExp.getIn());
        if (cgIn.isConstant()) {
            ((CodeGenAnalyzer)this.context).replace(cgLetExp, cgIn.getNamedValue(), "Null let-expression", new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIterationCallExp(@NonNull CGIterationCallExp cgIterationCallExp) {
        super.visitCGIterationCallExp(cgIterationCallExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgIterationCallExp.getSource());
        CGInvalid cgInvalidValue = cgSource.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIterationCallExp, cgInvalidValue);
            return null;
        }
        if (cgSource.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgIterationCallExp, ((CodeGenAnalyzer)this.context).getInvalid(PivotMessages.TypedValueRequired, "Collection", ValueUtil.getTypeName(null)));
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGMapExp(@NonNull CGMapExp cgMapExp) {
        super.visitCGMapExp(cgMapExp);
        CGInvalid cgInvalidValue = cgMapExp.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgMapExp, cgInvalidValue);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgOperation) {
        super.visitCGOperation(cgOperation);
        CGValuedElement cgBody = ((CodeGenAnalyzer)this.context).getExpression(cgOperation.getBody());
        for (CGVariable cGVariable : cgOperation.getParameters()) {
            CGInvalid cgInvalidValue = cGVariable.getInvalidValue();
            if (cgInvalidValue == null) continue;
            ((CodeGenAnalyzer)this.context).setConstant(cgBody, cgInvalidValue);
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperationCallExp(@NonNull CGOperationCallExp cgOperationCallExp) {
        super.visitCGOperationCallExp(cgOperationCallExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgOperationCallExp.getSource());
        if (!cgOperationCallExp.isValidating()) {
            CGInvalid cgInvalidValue = cgSource.getInvalidValue();
            if (cgInvalidValue == null) {
                for (CGValuedElement cgArgument : cgOperationCallExp.getArguments()) {
                    cgInvalidValue = cgArgument.getInvalidValue();
                    if (cgInvalidValue != null) break;
                }
            }
            if (cgInvalidValue != null) {
                ((CodeGenAnalyzer)this.context).setConstant(cgOperationCallExp, cgInvalidValue);
                return null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOppositePropertyCallExp(@NonNull CGOppositePropertyCallExp cgPropertyCallExp) {
        super.visitCGOppositePropertyCallExp(cgPropertyCallExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgPropertyCallExp.getSource());
        CGInvalid cgInvalidValue = cgSource.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, cgInvalidValue);
        } else if (cgSource.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, ((CodeGenAnalyzer)this.context).getInvalid());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGParameter(@NonNull CGParameter object) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPropertyCallExp(@NonNull CGPropertyCallExp cgPropertyCallExp) {
        super.visitCGPropertyCallExp(cgPropertyCallExp);
        CGValuedElement cgSource = ((CodeGenAnalyzer)this.context).getExpression(cgPropertyCallExp.getSource());
        CGInvalid cgInvalidValue = cgSource.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, cgInvalidValue);
        } else if (cgSource.isNull()) {
            ((CodeGenAnalyzer)this.context).setConstant(cgPropertyCallExp, ((CodeGenAnalyzer)this.context).getInvalid());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGShadowExp(@NonNull CGShadowExp cgShadowExp) {
        CGInvalid cgInvalidValue = cgShadowExp.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgShadowExp, cgInvalidValue);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        CGInvalid cgInvalidValue = cgTupleExp.getInvalidValue();
        if (cgInvalidValue != null) {
            ((CodeGenAnalyzer)this.context).setConstant(cgTupleExp, cgInvalidValue);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        LocalContext localContext;
        TypeExp pTypeExp = (TypeExp)cgTypeExp.getAst();
        Type referredType = pTypeExp.getReferredType();
        if (referredType != null && (localContext = ((CodeGenAnalyzer)this.context).getCodeGenerator().getGlobalContext().getLocalContext(cgTypeExp)) != null) {
            CGExecutorType cgExecutorType = cgTypeExp.getExecutorType();
            cgTypeExp.setTypeId(cgExecutorType.getUnderlyingTypeId());
            cgTypeExp.getDependsOn().add(cgExecutorType);
        }
        return super.visitCGTypeExp(cgTypeExp);
    }

    @Override
    @Nullable
    public Object visitCGVariable(@NonNull CGVariable cgVariable) {
        CGValuedElement cgInit = cgVariable.getInit();
        if (cgInit != null) {
            cgInit.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        super.visitCGVariableExp(cgVariableExp);
        if (cgVariableExp.isConstant() && !(cgVariableExp.getReferredVariable() instanceof CGParameter)) {
            ((CodeGenAnalyzer)this.context).setConstant(cgVariableExp, cgVariableExp.getNamedValue());
        }
        return null;
    }

    @Override
    @Nullable
    public CGElement visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }
}

