/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.ReferencesVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.CommonAnalysis;
import org.eclipse.ocl.examples.codegen.cse.CommonSubexpressionEliminator;
import org.eclipse.ocl.examples.codegen.cse.ControlPlace;
import org.eclipse.ocl.examples.codegen.cse.HashedAnalyses;
import org.eclipse.ocl.examples.codegen.cse.OuterStackPlace;
import org.eclipse.ocl.examples.codegen.cse.SimpleAnalysis;
import org.eclipse.ocl.examples.codegen.cse.StackPlace;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class GlobalPlace
extends AbstractPlace {
    @NonNull
    protected final CodeGenAnalyzer analyzer;
    @NonNull
    protected final ReferencesVisitor referencesVisitor;
    @NonNull
    private final Map<CGElement, AbstractPlace> element2place = new HashMap<CGElement, AbstractPlace>();
    @NonNull
    private final Set<OuterStackPlace> stackPlaces = new HashSet<OuterStackPlace>();
    @NonNull
    private final Map<CGElement, SimpleAnalysis> element2simpleAnalysis = new HashMap<CGElement, SimpleAnalysis>();
    @NonNull
    protected final HashedAnalyses globalAnalyses = new HashedAnalyses();

    @NonNull
    public static AbstractPlace createGlobalPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGElement cgElement) {
        return element2place.get(null);
    }

    public GlobalPlace(@NonNull CodeGenAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.referencesVisitor = analyzer.getCodeGenerator().createReferencesVisitor();
    }

    public void addSimpleAnalysis(@NonNull SimpleAnalysis simpleAnalysis) {
        CGValuedElement cgElement = simpleAnalysis.getElement();
        this.element2simpleAnalysis.put(cgElement, simpleAnalysis);
        if (cgElement.isGlobal() && !cgElement.isInlined()) {
            assert (cgElement.isConstant());
            this.globalAnalyses.addSimpleAnalysis(simpleAnalysis);
        }
    }

    void addStackPlace(@NonNull OuterStackPlace stackPlace) {
        this.stackPlaces.add(stackPlace);
    }

    @Nullable
    protected SimpleAnalysis buildSimpleAnalysisTree(@NonNull CGElement cgElement, int depth) {
        SimpleAnalysis structuralAnalysis;
        AbstractPlace abstractPlace;
        if (CommonSubexpressionEliminator.CSE_BUILD.isActive()) {
            CommonSubexpressionEliminator.CSE_BUILD.println(String.valueOf(StringUtil.getIndentation((int)depth, (String)"  ")) + "Build " + NameUtil.debugSimpleName((Object)cgElement) + " " + StringUtil.convertToOCLString((String)cgElement.toString()));
        }
        if ((abstractPlace = cgElement.getPlace(this.element2place)) == null) {
            return null;
        }
        if (this.element2place.get(cgElement) == null) {
            this.element2place.put(cgElement, abstractPlace);
        }
        if (CommonSubexpressionEliminator.CSE_BUILD.isActive()) {
            CommonSubexpressionEliminator.CSE_BUILD.println(String.valueOf(StringUtil.getIndentation((int)depth, (String)"  ")) + " ==> " + NameUtil.debugSimpleName((Object)abstractPlace));
        }
        int structuralHashCode = this.getStructuralHashCode(cgElement, "");
        Iterable<? extends CGElement> childElements = cgElement.getChildren();
        ArrayList<SimpleAnalysis> childAnalyses = null;
        for (CGElement cGElement : childElements) {
            SimpleAnalysis childAnalysis;
            if (cGElement == null || (childAnalysis = this.buildSimpleAnalysisTree(cGElement, depth + 1)) == null) continue;
            structuralHashCode = 3 * structuralHashCode + childAnalysis.getStructuralHashCode();
            if (childAnalyses == null) {
                childAnalyses = new ArrayList<SimpleAnalysis>();
            }
            childAnalyses.add(childAnalysis);
        }
        if (!(cgElement instanceof CGValuedElement)) {
            return null;
        }
        CGValuedElement cGValuedElement = (CGValuedElement)cgElement;
        if (CommonSubexpressionEliminator.CSE_BUILD.isActive()) {
            CommonSubexpressionEliminator.CSE_BUILD.println(String.valueOf(StringUtil.getIndentation((int)depth, (String)"  ")) + "=> " + NameUtil.debugSimpleName((Object)abstractPlace) + " " + structuralHashCode);
        }
        if (abstractPlace != this) {
            StackPlace stackPlace = abstractPlace.getStackPlace();
            if (stackPlace == null) {
                return null;
            }
            if (cGValuedElement == stackPlace.getStackElement() && stackPlace instanceof OuterStackPlace) {
                return null;
            }
        }
        if (childAnalyses != null) {
            SimpleAnalysis[] childArray = childAnalyses.toArray(new SimpleAnalysis[childAnalyses.size()]);
            structuralAnalysis = new SimpleAnalysis(this, cGValuedElement, depth, structuralHashCode, childArray);
        } else {
            structuralAnalysis = new SimpleAnalysis(this, cGValuedElement, depth, structuralHashCode, SimpleAnalysis.EMPTY_LIST);
        }
        if (CommonSubexpressionEliminator.CSE_BUILD.isActive()) {
            CommonSubexpressionEliminator.CSE_BUILD.println(String.valueOf(StringUtil.getIndentation((int)depth, (String)"  ")) + "=> " + NameUtil.debugSimpleName((Object)structuralAnalysis) + " " + structuralAnalysis.toString());
        }
        return structuralAnalysis;
    }

    @NonNull
    public CodeGenAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @NonNull
    public ControlPlace getControlPlace(@NonNull CGValuedElement cgElement) {
        AbstractPlace abstractPlace = this.element2place.get(cgElement);
        if (abstractPlace instanceof ControlPlace) {
            return (ControlPlace)abstractPlace;
        }
        throw new IllegalStateException("Not ControlPlace " + abstractPlace);
    }

    @Override
    @NonNull
    public GlobalPlace getGlobalPlace() {
        return this;
    }

    @Override
    @NonNull
    public GlobalPlace getParentPlace() {
        return this;
    }

    @Nullable
    public AbstractPlace getPlace(@NonNull CGElement cgElement) {
        return this.element2place.get(cgElement);
    }

    @NonNull
    public ReferencesVisitor getReferencesVisitor() {
        return this.referencesVisitor;
    }

    @Nullable
    public SimpleAnalysis getSimpleAnalysis(@NonNull Object anObject) {
        return this.element2simpleAnalysis.get(anObject);
    }

    @Nullable
    public List<CGValuedElement> getSortedGlobals(@NonNull DependencyVisitor dependencyVisitor) {
        if (this.globalAnalyses.isEmpty()) {
            return null;
        }
        HashSet<CGValuedElement> sortedGlobals = new HashSet<CGValuedElement>();
        for (AbstractAnalysis analysis : this.globalAnalyses) {
            CGValuedElement value = analysis.getPrimaryElement().getNamedValue();
            assert (value.isGlobal());
            sortedGlobals.add(value);
        }
        dependencyVisitor.visitAll(sortedGlobals);
        return dependencyVisitor.getSortedDependencies(true);
    }

    @Override
    @Nullable
    public StackPlace getStackPlace() {
        return null;
    }

    protected int getStructuralHashCode(@NonNull CGElement cgElement, @NonNull String prefix) {
        int structuralHashCode = cgElement.getClass().getName().hashCode();
        List<Object> referencedObjects = cgElement.accept(this.referencesVisitor);
        if (referencedObjects != null) {
            for (Object referencedObject : referencedObjects) {
                int referenceHashCode = 0;
                if (referencedObject != null) {
                    referenceHashCode = referencedObject instanceof CGElement ? this.getStructuralHashCode((CGElement)referencedObject, String.valueOf(prefix) + "  ") : referencedObject.hashCode();
                }
                structuralHashCode = 3 * structuralHashCode + referenceHashCode;
            }
        }
        return structuralHashCode;
    }

    public void optimize(@NonNull CGElement cgRoot) {
        this.element2place.put(null, this);
        this.element2place.put(cgRoot, this);
        this.buildSimpleAnalysisTree(cgRoot, 0);
        if (CommonSubexpressionEliminator.CSE_PLACES.isActive()) {
            CommonSubexpressionEliminator.CSE_PLACES.println("Places");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_PLACES, "");
        }
        for (OuterStackPlace stackPlace : this.stackPlaces) {
            stackPlace.optimize();
        }
        this.optimizeGlobals(cgRoot);
    }

    public void optimizeGlobals(@NonNull CGElement cgRoot) {
        if (!this.globalAnalyses.isEmpty()) {
            HashMultimap depth2commonAnalyses = HashMultimap.create();
            for (AbstractAnalysis analysis : this.globalAnalyses) {
                if (!(analysis instanceof CommonAnalysis)) continue;
                CommonAnalysis commonAnalysis = (CommonAnalysis)analysis;
                int maxDepth = commonAnalysis.getMaxDepth();
                depth2commonAnalyses.put((Object)maxDepth, (Object)commonAnalysis);
            }
            ArrayList sortedMaxDepths = new ArrayList(depth2commonAnalyses.keySet());
            Collections.sort(sortedMaxDepths);
            Collections.reverse(sortedMaxDepths);
            Iterator iterator = sortedMaxDepths.iterator();
            while (iterator.hasNext()) {
                int maxDepth = (Integer)iterator.next();
                ArrayList commonAnalyses = new ArrayList(depth2commonAnalyses.get((Object)maxDepth));
                Collections.sort(commonAnalyses);
                for (CommonAnalysis commonAnalysis : commonAnalyses) {
                    commonAnalysis.rewriteGlobal(this.analyzer);
                }
            }
        }
        if (CommonSubexpressionEliminator.CSE_REWRITE.isActive()) {
            CommonSubexpressionEliminator.CSE_REWRITE.println("Places after rewrite");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_REWRITE, "");
            String string = String.valueOf(cgRoot);
            TracingOption.println((Appendable)CommonSubexpressionEliminator.CSE_REWRITE, (String)string);
        }
    }

    @Override
    public void printHierarchy(@NonNull Appendable appendable, @NonNull String indentation) {
        TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + "GlobalPlace"));
        if (!this.globalAnalyses.isEmpty()) {
            for (AbstractAnalysis analysis : this.globalAnalyses) {
                TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + "    " + analysis.getStructuralHashCode() + "," + analysis));
            }
        } else {
            TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + "    <empty>"));
        }
        for (OuterStackPlace stackPlace : this.stackPlaces) {
            stackPlace.printHierarchy(appendable, String.valueOf(indentation) + "  ");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

