/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.ReferencesVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.CommonAnalysis;
import org.eclipse.ocl.examples.codegen.cse.ControlPlace;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;

public class SimpleAnalysis
extends AbstractAnalysis {
    static final Logger logger = Logger.getLogger(SimpleAnalysis.class);
    @NonNull
    public static final SimpleAnalysis[] EMPTY_LIST = new SimpleAnalysis[0];
    @NonNull
    protected final GlobalPlace globalPlace;
    @NonNull
    protected final CGValuedElement cgElement;
    protected final int depth;
    protected final int structuralHashCode;
    @NonNull
    protected final SimpleAnalysis[] children;
    @Nullable
    private SimpleAnalysis parent = null;
    @Nullable
    private CommonAnalysis commonAnalysis = null;

    public SimpleAnalysis(@NonNull GlobalPlace globalPlace, @NonNull CGValuedElement cgElement, int depth, int structuralHashCode, @NonNull SimpleAnalysis[] children) {
        this.globalPlace = globalPlace;
        this.cgElement = cgElement;
        this.depth = depth;
        this.structuralHashCode = structuralHashCode;
        this.children = children;
        SimpleAnalysis[] simpleAnalysisArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleAnalysis child = simpleAnalysisArray[n2];
            child.parent = this;
            ++n2;
        }
        if (cgElement.isCommonable() && !cgElement.isGlobal()) {
            ControlPlace controlPlace = globalPlace.getControlPlace(cgElement);
            if (!cgElement.isUncommonable()) {
                controlPlace.addAnalysis(this.addAnalysis(this));
            } else {
                controlPlace.addAnalysis(this);
            }
        }
        globalPlace.addSimpleAnalysis(this);
    }

    @Override
    @NonNull
    public CommonAnalysis addAnalysis(@NonNull AbstractAnalysis anAnalysis) {
        return anAnalysis.addSimpleAnalysis(this);
    }

    @Override
    @NonNull
    public CommonAnalysis addCommonAnalysis(@NonNull CommonAnalysis commonAnalysis) {
        return commonAnalysis.addSimpleAnalysis(this);
    }

    @Override
    @NonNull
    public CommonAnalysis addSimpleAnalysis(@NonNull SimpleAnalysis simpleAnalysis) {
        assert (simpleAnalysis.commonAnalysis == null);
        CommonAnalysis thisSharedAnalysis = this.commonAnalysis;
        if (thisSharedAnalysis != null) {
            return thisSharedAnalysis.addSimpleAnalysis(this);
        }
        return new CommonAnalysis(this, simpleAnalysis);
    }

    public void dispose() {
        if (this.commonAnalysis != null) {
            this.commonAnalysis.removedSimpleAnalysis(this);
            this.commonAnalysis = null;
        }
        SimpleAnalysis[] simpleAnalysisArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleAnalysis simpleAnalysis = simpleAnalysisArray[n2];
            simpleAnalysis.dispose();
            ++n2;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    @NonNull
    public CGValuedElement getElement() {
        return this.cgElement;
    }

    @Override
    public int getMaxDepth() {
        return this.depth;
    }

    @Override
    public int getMinDepth() {
        return this.depth;
    }

    @Nullable
    public SimpleAnalysis getParent() {
        return this.parent;
    }

    @Override
    @NonNull
    public CGValuedElement getPrimaryElement() {
        if (this.commonAnalysis != null) {
            return this.commonAnalysis.getPrimaryElement();
        }
        return this.cgElement;
    }

    @Override
    public int getStructuralHashCode() {
        return this.structuralHashCode;
    }

    @Override
    public boolean isStructurallyEqualTo(@NonNull AbstractAnalysis thatAnalysis) {
        return thatAnalysis.isStructurallyEqualTo(this);
    }

    @Override
    public boolean isStructurallyEqualTo(@NonNull SimpleAnalysis that) {
        if (this == that) {
            return true;
        }
        if (this.structuralHashCode != that.structuralHashCode) {
            return false;
        }
        if (this.cgElement.getClass() != that.cgElement.getClass()) {
            return false;
        }
        SimpleAnalysis[] theseChildren = this.children;
        SimpleAnalysis[] thoseChildren = that.children;
        if (theseChildren.length != thoseChildren.length) {
            return false;
        }
        int i = 0;
        while (i < theseChildren.length) {
            SimpleAnalysis thisChild = theseChildren[i];
            SimpleAnalysis thatChild = thoseChildren[i];
            if (thisChild == null || thatChild == null) {
                return false;
            }
            if (!thisChild.isStructurallyEqualTo(thatChild)) {
                return false;
            }
            ++i;
        }
        ReferencesVisitor referencesVisitor = this.globalPlace.getReferencesVisitor();
        List<Object> theseObjects = this.cgElement.accept(referencesVisitor);
        List<Object> thoseObjects = that.cgElement.accept(referencesVisitor);
        if (theseObjects == null) {
            if (thoseObjects != null) {
                return false;
            }
        } else {
            if (thoseObjects == null) {
                return false;
            }
            if (theseObjects.size() != thoseObjects.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < theseObjects.size()) {
                Object thisObject = theseObjects.get(i2);
                Object thatObject = thoseObjects.get(i2);
                if (thisObject == null) {
                    if (thatObject != null) {
                        return false;
                    }
                } else {
                    if (thatObject == null) {
                        return false;
                    }
                    if (thisObject instanceof CGElement && thatObject instanceof CGElement) {
                        SimpleAnalysis thisAnalysis = this.globalPlace.getSimpleAnalysis(thisObject);
                        SimpleAnalysis thatAnalysis = this.globalPlace.getSimpleAnalysis(thatObject);
                        if (thisAnalysis != null && thatAnalysis != null && !thisAnalysis.isStructurallyEqualTo(thatAnalysis)) {
                            return false;
                        }
                    } else if (!thisObject.equals(thatObject)) {
                        return false;
                    }
                }
                ++i2;
            }
        }
        return true;
    }

    public void setCommonAnalysis(@NonNull CommonAnalysis commonAnalysis) {
        if (this.commonAnalysis != null) {
            this.commonAnalysis.removedSimpleAnalysis(this);
        }
        this.commonAnalysis = commonAnalysis;
        this.commonAnalysis.addedSimpleAnalysis(this);
    }

    public String toString() {
        CGValuedElement cgValue = this.cgElement.getNamedValue();
        if (cgValue == this.cgElement) {
            return String.valueOf(this.depth) + ",\"" + String.valueOf(this.cgElement) + "\":" + this.cgElement.eClass().getName();
        }
        return String.valueOf(this.depth) + ",\"" + String.valueOf(this.cgElement) + "\":" + this.cgElement.eClass().getName() + "=>" + cgValue.eClass().getName();
    }
}

