/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.generator.CodeGenOptions;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public abstract class AbstractCodeGenerator
implements CodeGenerator {
    @NonNull
    public static final String ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL = "org.eclipse.jdt.annotation.NonNull";
    @NonNull
    public static final String ORG_ECLIPSE_JDT_ANNOTATION_NULLABLE = "org.eclipse.jdt.annotation.Nullable";
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;
    @NonNull
    protected final NameManager nameManager;
    @NonNull
    protected final GenModelHelper genModelHelper;
    private CodeGenOptions options = null;
    private List<Exception> problems = null;
    @NonNull
    private String defaultIndent = "    ";

    protected AbstractCodeGenerator(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.nameManager = this.createNameManager();
        this.genModelHelper = this.createGenModelHelper();
    }

    protected AbstractCodeGenerator(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull NameManager nameManager, @NonNull GenModelHelper genModelHelper) {
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.nameManager = nameManager;
        this.genModelHelper = genModelHelper;
    }

    @Override
    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public void addProblem(@NonNull Exception problem) {
        List<Exception> problems2 = this.problems;
        if (problems2 == null) {
            this.problems = problems2 = new ArrayList<Exception>();
        }
        problems2.add(problem);
    }

    @Override
    @NonNull
    public AnalysisVisitor createAnalysisVisitor() {
        return new AnalysisVisitor(this.getAnalyzer());
    }

    @NonNull
    protected abstract GenModelHelper createGenModelHelper();

    @NonNull
    protected abstract NameManager createNameManager();

    @NonNull
    protected CodeGenOptions createOptions() {
        return new CodeGenOptions();
    }

    @Override
    @NonNull
    public String getDefaultIndent() {
        return this.defaultIndent;
    }

    @Override
    @NonNull
    public GenModelHelper getGenModelHelper() {
        return this.genModelHelper;
    }

    @Override
    @NonNull
    public NameManager getNameManager() {
        return this.nameManager;
    }

    @Override
    @NonNull
    public CodeGenOptions getOptions() {
        CodeGenOptions options2 = this.options;
        if (options2 == null) {
            this.options = options2 = this.createOptions();
        }
        return options2;
    }

    @Override
    @Nullable
    public Operation isFinal(@NonNull Operation anOperation, @NonNull Class staticType) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        FinalAnalysis finalAnalysis = metamodelManager.getFinalAnalysis();
        return finalAnalysis.isFinal(anOperation, (CompleteClass)metamodelManager.getCompleteClass((Type)staticType));
    }
}

