/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OclInvalidTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.SpecializedId;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.UnspecifiedId;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class Id2JavaExpressionVisitor
implements IdVisitor<Object> {
    @NonNull
    protected final JavaStream js;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;

    public Id2JavaExpressionVisitor(@NonNull JavaStream js) {
        this.js = js;
        this.metamodelManager = js.getCodeGenerator().getEnvironmentFactory().getMetamodelManager();
    }

    @Nullable
    public Object visitClassId(@NonNull ClassId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getClassId(");
        this.js.appendString(id.getName());
        this.js.append(", " + id.getTemplateParameters() + ")");
        return null;
    }

    @Nullable
    public Object visitCollectionTypeId(@NonNull CollectionTypeId id) {
        this.js.appendClassReference(TypeId.class);
        CollectionTypeId generalizedId = id.getGeneralizedId();
        String idName = generalizedId.getLiteralName();
        if (idName == null) {
            idName = "COLLECTION";
        }
        this.js.append("." + idName);
        if (id instanceof SpecializedId) {
            this.js.append(".getSpecializedId(");
            BindingsId templateBindings = ((SpecializedId)id).getTemplateBindings();
            int i = 0;
            while (i < templateBindings.size()) {
                if (i > 0) {
                    this.js.append(", ");
                }
                ElementId elementId = (ElementId)ClassUtil.nonNullModel((Object)((ElementId)templateBindings.get(i)));
                this.js.appendIdReference(elementId);
                ++i;
            }
            this.js.append(")");
        }
        return null;
    }

    @Nullable
    public Object visitDataTypeId(@NonNull DataTypeId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getDataTypeId(");
        this.js.appendString(id.getName());
        this.js.append(", " + id.getTemplateParameters() + ")");
        return null;
    }

    @Nullable
    public Object visitEnumerationId(@NonNull EnumerationId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getEnumerationId(");
        this.js.appendString(id.getName());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        this.js.appendIdReference((ElementId)id.getParentId());
        this.js.append(".getEnumerationLiteralId(");
        this.js.appendString(id.getName());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitInvalidId(@NonNull OclInvalidTypeId id) {
        this.js.appendClassReference(TypeId.class);
        this.js.append(".");
        this.js.append(id.getLiteralName());
        return null;
    }

    @Nullable
    public Object visitLambdaTypeId(@NonNull LambdaTypeId id) {
        return this.visiting((ElementId)id);
    }

    @Nullable
    public Object visitMapTypeId(@NonNull MapTypeId id) {
        this.js.appendClassReference(TypeId.class);
        MapTypeId generalizedId = id.getGeneralizedId();
        String idName = generalizedId.getLiteralName();
        if (idName == null) {
            idName = "MAP";
        }
        this.js.append("." + idName);
        if (id instanceof SpecializedId) {
            this.js.append(".getSpecializedId(");
            BindingsId templateBindings = ((SpecializedId)id).getTemplateBindings();
            int i = 0;
            while (i < templateBindings.size()) {
                if (i > 0) {
                    this.js.append(", ");
                }
                ElementId elementId = (ElementId)ClassUtil.nonNullModel((Object)((ElementId)templateBindings.get(i)));
                this.js.appendIdReference(elementId);
                ++i;
            }
            this.js.append(")");
        }
        return null;
    }

    @Nullable
    public Object visitNestedPackageId(@NonNull NestedPackageId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getNestedPackageId(");
        this.js.appendString(id.getName());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitNsURIPackageId(@NonNull NsURIPackageId id) {
        String nsURI = id.getNsURI();
        String nsPrefix = id.getNsPrefix();
        GenPackage genPackage = this.metamodelManager.getGenPackage(nsURI);
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getNsURIPackageId(");
        this.js.appendString(nsURI);
        this.js.append(", ");
        if (nsPrefix != null) {
            this.js.appendString(nsPrefix);
        } else {
            this.js.append("null");
        }
        this.js.append(", ");
        if (genPackage != null) {
            this.js.appendClassReference(genPackage.getQualifiedPackageInterfaceName());
            this.js.append(".eINSTANCE");
        } else {
            this.js.append("null");
        }
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitNullId(@NonNull OclVoidTypeId id) {
        this.js.appendClassReference(TypeId.class);
        this.js.append(".");
        this.js.append(id.getLiteralName());
        return null;
    }

    @Nullable
    public Object visitOperationId(@NonNull OperationId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getOperationId(" + id.getTemplateParameters() + ", ");
        this.js.appendString(id.getName());
        this.js.append(", ");
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getParametersId(");
        boolean isFirst = true;
        for (TypeId parameterId : id.getParametersId()) {
            if (!isFirst) {
                this.js.append(", ");
            }
            this.js.appendIdReference((ElementId)parameterId);
            isFirst = false;
        }
        this.js.append("))");
        return null;
    }

    @Nullable
    public Object visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        this.js.appendClassReference(TypeId.class);
        this.js.append(".");
        this.js.append(id.getLiteralName());
        return null;
    }

    @Nullable
    public Object visitPropertyId(@NonNull PropertyId id) {
        this.js.appendIdReference((ElementId)id.getParent());
        this.js.append(".getPropertyId(");
        this.js.appendString(id.getName());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitRootPackageId(@NonNull RootPackageId id) {
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getRootPackageId(");
        this.js.appendString(id.getName());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitTemplateBinding(@NonNull TemplateBinding id) {
        return this.visiting((ElementId)id);
    }

    @Nullable
    public Object visitTemplateParameterId(@NonNull TemplateParameterId id) {
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getTemplateParameterId(" + id.getIndex() + ")");
        return null;
    }

    @Nullable
    public Object visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return this.visiting((ElementId)id);
    }

    @Nullable
    public Object visitTuplePartId(@NonNull TuplePartId id) {
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getTuplePartId(" + id.getIndex() + ", ");
        this.js.appendString(id.getName());
        this.js.append(", ");
        this.js.appendIdReference((ElementId)id.getTypeId());
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitTupleTypeId(@NonNull TupleTypeId id) {
        this.js.appendClassReference(IdManager.class);
        this.js.append(".getTupleTypeId(");
        this.js.appendString(id.getName());
        TuplePartId[] tuplePartIdArray = id.getPartIds();
        int n = tuplePartIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            this.js.append(", ");
            this.js.appendIdReference((ElementId)partId);
            ++n2;
        }
        this.js.append(")");
        return null;
    }

    @Nullable
    public Object visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return this.visiting((ElementId)id);
    }

    @Nullable
    public Object visiting(@NonNull ElementId id) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
    }
}

