/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.AbstractCodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GlobalContext;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.codegen.java.AbstractJavaContext;
import org.eclipse.ocl.examples.codegen.java.Id2EClassVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdVisitor;

public class JavaGlobalContext<CG extends JavaCodeGenerator>
extends AbstractJavaContext<CG>
implements GlobalContext {
    @NonNull
    protected final NameManager nameManager;
    @NonNull
    private Map<CGElement, JavaLocalContext<? extends CG>> localContexts = new HashMap<CGElement, JavaLocalContext<? extends CG>>();
    @NonNull
    private Set<CGValuedElement> globals = new HashSet<CGValuedElement>();
    @NonNull
    private Set<String> imports = new HashSet<String>();
    @NonNull
    protected final String eName;
    @NonNull
    protected final String evaluateName;
    @NonNull
    protected final String instanceName;
    @NonNull
    protected final String selfName;

    public JavaGlobalContext(@NonNull CG codeGenerator) {
        super(codeGenerator);
        this.nameManager = ((AbstractCodeGenerator)codeGenerator).getNameManager();
        this.eName = this.nameManager.reserveName("e", null);
        this.evaluateName = this.nameManager.reserveName("evaluate", null);
        this.instanceName = this.nameManager.reserveName("INSTANCE", null);
        this.selfName = this.nameManager.reserveName("self", null);
    }

    protected void addGlobal(@NonNull CGValuedElement cgGlobal) {
        this.globals.add(cgGlobal);
    }

    public void addImport(@NonNull String className) {
        this.imports.add(className);
    }

    @NonNull
    protected JavaLocalContext<? extends CG> createNestedContext(@NonNull CGElement cgScope) {
        return new JavaLocalContext(this, cgScope);
    }

    @Nullable
    public EClass getEClass(@NonNull ElementId elementId) {
        Id2EClassVisitor id2EClassVisitor = this.codeGenerator.getId2EClassVisitor();
        return (EClass)elementId.accept((IdVisitor)id2EClassVisitor);
    }

    @NonNull
    public String getEName() {
        return this.eName;
    }

    @NonNull
    public String getEvaluateName() {
        return this.evaluateName;
    }

    @NonNull
    public Collection<CGValuedElement> getGlobals() {
        return this.globals;
    }

    @NonNull
    public Set<String> getImports() {
        return this.imports;
    }

    @NonNull
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    @Nullable
    public JavaLocalContext<? extends CG> getLocalContext(@NonNull CGElement cgElement) {
        JavaLocalContext<Object> localContext = this.localContexts.get(cgElement);
        if (localContext == null) {
            CGElement cgScope = cgElement;
            CGIterationCallExp cgIterationScope = null;
            while (cgScope != null) {
                if (cgScope instanceof CGIterationCallExp) {
                    cgIterationScope = (CGIterationCallExp)cgScope;
                    localContext = this.localContexts.get(cgScope);
                    if (localContext != null) break;
                }
                if (cgScope.isContext()) break;
                cgScope = cgScope.getParent();
            }
            if (cgScope == null) {
                return null;
            }
            if (localContext == null) {
                localContext = this.localContexts.get(cgScope);
                if (localContext == null) {
                    localContext = this.createNestedContext(cgScope);
                    this.localContexts.put(cgScope, localContext);
                }
                if (cgIterationScope != null) {
                    this.localContexts.put(cgIterationScope, localContext);
                }
            }
            this.localContexts.put(cgElement, localContext);
        }
        return localContext;
    }

    @NonNull
    public NameManager getNameManager() {
        return this.nameManager;
    }

    @NonNull
    public String getSelfName() {
        return this.selfName;
    }

    @NonNull
    public String getValueName(@NonNull CGValuedElement cgValuedElement) {
        LocalContext localContext = this.getLocalContext(cgValuedElement);
        if (localContext != null && !cgValuedElement.isGlobal()) {
            return ((JavaLocalContext)localContext).getValueName(cgValuedElement);
        }
        CGValuedElement cgValue = cgValuedElement.getNamedValue();
        String valueName = cgValue.getValueName();
        if (valueName == null) {
            valueName = this.nameManager.getGlobalSymbolName(cgValue, cgValue.getName());
            cgValue.setValueName(valueName);
        }
        return valueName;
    }
}

