/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BooleanObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedMapDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedValuesDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EnumerationValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.FutureEObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.FutureEObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.IntegerValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.examples.codegen.java.types.RealValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.RootObjectDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleDataTypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.SimpleValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedElementsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedMapDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnlimitedNaturalValueDescriptor;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OclInvalidTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.UnspecifiedId;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapEntry;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.TupleValue;

public class Id2BoxedDescriptorVisitor
implements IdVisitor<BoxedDescriptor> {
    @NonNull
    protected final GenModelHelper genModelHelper;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;
    @NonNull
    protected final IdResolver idResolver;

    public Id2BoxedDescriptorVisitor(@NonNull JavaCodeGenerator javaCodeGenerator) {
        this.genModelHelper = javaCodeGenerator.getGenModelHelper();
        this.metamodelManager = javaCodeGenerator.getEnvironmentFactory().getMetamodelManager();
        this.idResolver = this.metamodelManager.getEnvironmentFactory().getIdResolver();
    }

    protected EClassifier getEClassifier(@NonNull Type type) {
        for (Class dType : this.metamodelManager.getPartialClasses(type)) {
            EClassifier eClass = (EClassifier)dType.getESObject();
            if (eClass == null) continue;
            return eClass;
        }
        return null;
    }

    @NonNull
    public BoxedDescriptor visitClassId(@NonNull ClassId id) {
        Package asPackage;
        Class type;
        block5: {
            type = this.idResolver.getClass((TypeId)id, null);
            EClassifier eClassifier = this.getEClassifier((Type)type);
            if (eClassifier != null) {
                try {
                    java.lang.Class<?> javaClass = this.genModelHelper.getEcoreInterfaceClassifier(eClassifier);
                    return new EObjectDescriptor((ElementId)id, eClassifier, javaClass);
                }
                catch (Exception e) {
                    String instanceClassName = type.getInstanceClassName();
                    if (instanceClassName == null) {
                        instanceClassName = this.genModelHelper.getEcoreInterfaceClassifierName(eClassifier);
                    }
                    if (instanceClassName == null) break block5;
                    return new FutureEObjectDescriptor((ElementId)id, eClassifier, instanceClassName);
                }
            }
        }
        if ((asPackage = type.getOwningPackage()) != null && asPackage.eContainer() instanceof Orphanage) {
            return new SimpleDataTypeDescriptor((ElementId)id, String.valueOf(asPackage.getName()) + "." + type.getName());
        }
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitCollectionTypeId(@NonNull CollectionTypeId id) {
        AbstractCollectionDescriptor unboxedDescriptor;
        Class type;
        CollectionTypeId generalizedId;
        block8: {
            generalizedId = id.getGeneralizedId();
            if (generalizedId == id) {
                type = this.idResolver.getClass((TypeId)id, null);
            } else {
                TypeId typeId = id.getElementTypeId();
                if (typeId instanceof TemplateParameterId) {
                    typeId = TypeId.OCL_ANY;
                }
                type = this.idResolver.getClass(typeId, null);
            }
            unboxedDescriptor = null;
            EClassifier eClassifier = this.getEClassifier((Type)type);
            if (eClassifier != null) {
                try {
                    java.lang.Class<?> javaClass = this.genModelHelper.getEcoreInterfaceClassifier(eClassifier);
                    unboxedDescriptor = new EObjectsDescriptor(id, eClassifier, javaClass);
                }
                catch (Exception e) {
                    String instanceClassName = type.getInstanceClassName();
                    if (instanceClassName == null) {
                        instanceClassName = this.genModelHelper.getEcoreInterfaceClassifierName(eClassifier);
                    }
                    if (instanceClassName == null) break block8;
                    unboxedDescriptor = new FutureEObjectsDescriptor(id, eClassifier, instanceClassName);
                }
            }
        }
        if (unboxedDescriptor == null) {
            unboxedDescriptor = new UnboxedElementsDescriptor(id, (StandardLibrary)this.metamodelManager.getStandardLibrary(), (Type)type);
        }
        java.lang.Class boxedClass = generalizedId == TypeId.BAG ? BagValue.class : (generalizedId == TypeId.COLLECTION ? CollectionValue.class : (generalizedId == TypeId.ORDERED_SET ? OrderedSetValue.class : (generalizedId == TypeId.SEQUENCE ? SequenceValue.class : (generalizedId == TypeId.SET ? SetValue.class : CollectionValue.class))));
        return new BoxedValuesDescriptor((ElementId)id, boxedClass, unboxedDescriptor);
    }

    @NonNull
    public BoxedDescriptor visitDataTypeId(@NonNull DataTypeId id) {
        Class type = this.idResolver.getClass((TypeId)id, null);
        String instanceClassName = type.getInstanceClassName();
        if (instanceClassName != null) {
            if (BigDecimal.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, BigDecimal.class));
            }
            if (BigInteger.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, BigInteger.class));
            }
            if (Byte.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Byte.class));
            }
            if (Double.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Double.class));
            }
            if (Float.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Float.class));
            }
            if (Integer.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Integer.class));
            }
            if (Long.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Long.class));
            }
            if (Short.class.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Short.class));
            }
            if (Byte.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Byte.TYPE));
            }
            if (Character.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Character.TYPE));
            }
            if (Double.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Double.TYPE));
            }
            if (Float.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, RealValue.class, new UnboxedValueDescriptor((ElementId)id, Float.TYPE));
            }
            if (Integer.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Integer.TYPE));
            }
            if (Long.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Long.TYPE));
            }
            if (Short.TYPE.getName().equals(instanceClassName)) {
                return new BoxedValueDescriptor((ElementId)id, IntegerValue.class, new UnboxedValueDescriptor((ElementId)id, Short.TYPE));
            }
            return new SimpleDataTypeDescriptor((ElementId)id, instanceClassName);
        }
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitEnumerationId(@NonNull EnumerationId id) {
        return new EnumerationValueDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitInvalidId(@NonNull OclInvalidTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, InvalidValueException.class);
    }

    @NonNull
    public BoxedDescriptor visitLambdaTypeId(@NonNull LambdaTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, LambdaType.class);
    }

    @NonNull
    public BoxedDescriptor visitMapTypeId(@NonNull MapTypeId id) {
        Class valueType;
        Class keyType;
        MapTypeId generalizedId = id.getGeneralizedId();
        if (generalizedId == id) {
            keyType = this.idResolver.getClass((TypeId)id, null);
            valueType = this.idResolver.getClass((TypeId)id, null);
        } else {
            TypeId keyTypeId = id.getKeyTypeId();
            if (keyTypeId instanceof TemplateParameterId) {
                keyTypeId = TypeId.OCL_ANY;
            }
            keyType = this.idResolver.getClass(keyTypeId, null);
            TypeId valueTypeId = id.getValueTypeId();
            if (valueTypeId instanceof TemplateParameterId) {
                valueTypeId = TypeId.OCL_ANY;
            }
            valueType = this.idResolver.getClass(valueTypeId, null);
        }
        UnboxedMapDescriptor unboxedDescriptor = null;
        unboxedDescriptor = new UnboxedMapDescriptor(id, (StandardLibrary)this.metamodelManager.getStandardLibrary(), (Type)valueType, (Type)keyType);
        java.lang.Class<MapValue> boxedClass = MapValue.class;
        return new BoxedMapDescriptor(id, boxedClass, unboxedDescriptor);
    }

    @NonNull
    public BoxedDescriptor visitNestedPackageId(@NonNull NestedPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, Package.class);
    }

    @NonNull
    public BoxedDescriptor visitNsURIPackageId(@NonNull NsURIPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, Package.class);
    }

    @NonNull
    public BoxedDescriptor visitNullId(@NonNull OclVoidTypeId id) {
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitOperationId(@NonNull OperationId id) {
        return new SimpleValueDescriptor((ElementId)id, Operation.class);
    }

    @NonNull
    public BoxedDescriptor visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        if (id instanceof JavaTypeId) {
            java.lang.Class<?> javaClass = ((JavaTypeId)id).getJavaClass();
            if (javaClass == Object.class) {
                return new RootObjectDescriptor((ElementId)id);
            }
            return new SimpleValueDescriptor((ElementId)id, javaClass);
        }
        if (id == TypeId.BOOLEAN) {
            return new BooleanObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.INTEGER) {
            return new IntegerValueDescriptor((ElementId)id);
        }
        if (id == TypeId.INTEGER_RANGE) {
            return new SimpleValueDescriptor((ElementId)id, IntegerRange.class);
        }
        if (id == TypeId.MAP_ENTRY) {
            return new SimpleValueDescriptor((ElementId)id, MapEntry.class);
        }
        if (id == TypeId.OCL_ANY) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.OCL_COMPARABLE) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.OCL_SUMMABLE) {
            return new RootObjectDescriptor((ElementId)id);
        }
        if (id == TypeId.REAL) {
            return new RealValueDescriptor((ElementId)id);
        }
        if (id == TypeId.STRING) {
            return new SimpleValueDescriptor((ElementId)id, String.class);
        }
        if (id == TypeId.UNLIMITED_NATURAL) {
            return new UnlimitedNaturalValueDescriptor((ElementId)id);
        }
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitPropertyId(@NonNull PropertyId id) {
        return new SimpleValueDescriptor((ElementId)id, Property.class);
    }

    @NonNull
    public BoxedDescriptor visitRootPackageId(@NonNull RootPackageId id) {
        return new SimpleValueDescriptor((ElementId)id, Package.class);
    }

    @NonNull
    public BoxedDescriptor visitTemplateBinding(@NonNull TemplateBinding id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitTemplateParameterId(@NonNull TemplateParameterId id) {
        return new RootObjectDescriptor((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, Type.class);
    }

    @NonNull
    public BoxedDescriptor visitTuplePartId(@NonNull TuplePartId id) {
        return new SimpleValueDescriptor((ElementId)id, Property.class);
    }

    @NonNull
    public BoxedDescriptor visitTupleTypeId(@NonNull TupleTypeId id) {
        return new SimpleValueDescriptor((ElementId)id, TupleValue.class);
    }

    @NonNull
    public BoxedDescriptor visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return this.visiting((ElementId)id);
    }

    @NonNull
    public BoxedDescriptor visiting(@NonNull ElementId id) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + id.getClass().getName());
    }
}

