/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedElementsDescriptor
extends AbstractCollectionDescriptor
implements UnboxedDescriptor {
    @NonNull
    protected final StandardLibrary standardLibrary;
    @NonNull
    protected final Type type;

    public UnboxedElementsDescriptor(@NonNull CollectionTypeId collectionTypeId, @NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        super(collectionTypeId);
        this.standardLibrary = standardLibrary;
        this.type = type;
    }

    @Override
    public void append(@NonNull JavaStream javaStream) {
        javaStream.appendClassReference(List.class, true, Object.class);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(this.getJavaClass());
    }

    @Override
    @NonNull
    public String getClassName() {
        return (String)ClassUtil.nonNullModel((Object)this.type.getName());
    }

    @Override
    @NonNull
    public Class<?> getJavaClass() {
        return Object.class;
    }

    @Override
    @NonNull
    public UnboxedDescriptor getUnboxedDescriptor() {
        return this;
    }

    @Override
    @Nullable
    public Class<?> hasJavaClass() {
        return null;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof UnboxedElementsDescriptor)) {
            return false;
        }
        Type thatType = ((UnboxedElementsDescriptor)typeDescriptor).type;
        return thatType.conformsTo(this.standardLibrary, this.type);
    }

    @Override
    @NonNull
    public String toString() {
        return this.elementId + " => List<Object/*" + this.type.getName() + "*/>";
    }
}

