/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.MapDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedMapDescriptor
extends AbstractDescriptor
implements UnboxedDescriptor,
MapDescriptor {
    @NonNull
    protected final StandardLibrary standardLibrary;
    @NonNull
    protected final Type keyType;
    @NonNull
    protected final Type valueType;

    public UnboxedMapDescriptor(@NonNull MapTypeId mapTypeId, @NonNull StandardLibrary standardLibrary, @NonNull Type keyType, @NonNull Type valueType) {
        super((ElementId)mapTypeId);
        this.standardLibrary = standardLibrary;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public void append(@NonNull JavaStream javaStream) {
        javaStream.appendClassReference(List.class, true, Object.class);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(this.getJavaClass());
    }

    @Override
    @NonNull
    public String getClassName() {
        return (String)ClassUtil.nonNullModel((Object)this.keyType.getName());
    }

    @Override
    @NonNull
    public MapTypeId getElementId() {
        return (MapTypeId)this.elementId;
    }

    @Override
    @NonNull
    public Class<?> getJavaClass() {
        return Object.class;
    }

    @Override
    @NonNull
    public UnboxedDescriptor getUnboxedDescriptor() {
        return this;
    }

    @Override
    @Nullable
    public Class<?> hasJavaClass() {
        return null;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof UnboxedMapDescriptor)) {
            return false;
        }
        Type thatType = ((UnboxedMapDescriptor)typeDescriptor).keyType;
        return thatType.conformsTo(this.standardLibrary, this.keyType);
    }

    @Override
    @NonNull
    public String toString() {
        return this.elementId + " => Map<Object/*" + this.keyType.getName() + ",Object/*" + this.valueType.getName() + "*/>";
    }

    @Override
    public void append(@NonNull JavaStream javaStream, boolean reClass) {
    }
}

