/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGlobalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreLocalContext;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public final class OCLinEcoreAS2CGVisitor
extends AS2CGVisitor {
    @NonNull
    protected final OCLinEcoreGlobalContext globalContext;

    public OCLinEcoreAS2CGVisitor(@NonNull CodeGenAnalyzer analyzer, @NonNull OCLinEcoreGlobalContext globalContext) {
        super(analyzer);
        this.globalContext = globalContext;
        this.createSeverityOperations(analyzer.getCodeGenerator().getEnvironmentFactory());
    }

    private void createSeverityOperations(@NonNull EnvironmentFactoryInternal environmentFactory) {
    }

    @Override
    protected void addParameter(@NonNull Variable aParameter, @NonNull CGParameter cgParameter) {
        GenParameter genParameter;
        super.addParameter(aParameter, cgParameter);
        Parameter representedParameter = aParameter.getRepresentedParameter();
        if (representedParameter != null && (genParameter = this.genModelHelper.getGenParameter(representedParameter)) != null) {
            String name = (String)ClassUtil.nonNullState((Object)genParameter.getName());
            cgParameter.setValueName(name);
        }
    }

    @Override
    @NonNull
    public CGParameter getParameter(@NonNull Variable aParameter, @Nullable String name) {
        CGParameter cgParameter = super.getParameter(aParameter, name);
        if ("self".equals(aParameter.getName())) {
            cgParameter.setValueName("this");
        }
        return cgParameter;
    }

    @Override
    @Nullable
    public CGConstraint visitConstraint(@NonNull Constraint element) {
        String oclExpression;
        CGConstraint cgConstraint = CGModelFactory.eINSTANCE.createCGConstraint();
        this.setAst((CGNamedElement)cgConstraint, (NamedElement)element);
        LanguageExpression specification = element.getOwnedSpecification();
        if (specification != null && (oclExpression = specification.getBody()) != null) {
            try {
                String containerName;
                EObject eContainer;
                String constraintName;
                EObject contextElement = (EObject)ClassUtil.nonNullState((Object)specification.eContainer());
                ParserContext parserContext = this.metamodelManager.createParserContext((Element)specification, new Object[0]);
                if (parserContext == null) {
                    throw new ParserException(PivotMessagesInternal.UnknownContextType_ERROR_, new Object[]{NameUtil.qualifiedNameFor((Object)contextElement), PivotUtilInternal.getSpecificationRole((LanguageExpression)specification)});
                }
                parserContext.setRootElement((Element)specification);
                if (specification instanceof ExpressionInOCL) {
                    Variable diagnosticsVariable = PivotUtil.createVariable((String)"diagnostics", (Type)this.metamodelManager.getStandardLibrary().getOclAnyType(), (boolean)false, null);
                    ((ExpressionInOCL)specification).getOwnedParameters().add(diagnosticsVariable);
                    Variable contextVariable = PivotUtil.createVariable((String)"context", (Type)this.metamodelManager.getStandardLibrary().getOclAnyType(), (boolean)false, null);
                    ((ExpressionInOCL)specification).getOwnedParameters().add(contextVariable);
                }
                if ((constraintName = element.getName()).startsWith("validate")) {
                    constraintName = constraintName.substring(8);
                }
                if ((eContainer = element.eContainer()) instanceof NamedElement && (containerName = ((NamedElement)eContainer).getName()) != null) {
                    constraintName = String.valueOf(containerName) + "::" + constraintName;
                }
                String statusExpression = oclExpression;
                String messageExpression = null;
                String severityExpression = null;
                ExpressionInOCL originalQuery = parserContext.parse(contextElement, oclExpression);
                OCLExpression ownedBody = originalQuery.getOwnedBody();
                if (ownedBody instanceof PropertyCallExp) {
                    TupleLiteralExp asTupleLiteralExp;
                    List asTupleParts;
                    TupleLiteralPart asStatusPart;
                    PropertyCallExp asPropertyCallExp = (PropertyCallExp)ownedBody;
                    OCLExpression asSource = asPropertyCallExp.getOwnedSource();
                    Property asReferredProperty = asPropertyCallExp.getReferredProperty();
                    if (asReferredProperty != null && "status".equals(asReferredProperty.getName()) && asSource instanceof TupleLiteralExp && (asStatusPart = (TupleLiteralPart)NameUtil.getNameable((Iterable)(asTupleParts = (asTupleLiteralExp = (TupleLiteralExp)asSource).getOwnedParts()), (String)"status")) != null) {
                        OCLExpression asSeverityInit;
                        TupleLiteralPart asSeverityPart;
                        OCLExpression asMessageInit;
                        TupleLiteralPart asMessagePart;
                        OCLExpression asStatusInit = asStatusPart.getOwnedInit();
                        if (asStatusInit != null) {
                            statusExpression = PrettyPrinter.print((Element)asStatusInit);
                        }
                        if ((asMessagePart = (TupleLiteralPart)NameUtil.getNameable((Iterable)asTupleParts, (String)"message")) != null && (asMessageInit = asMessagePart.getOwnedInit()) != null) {
                            messageExpression = PrettyPrinter.print((Element)asMessageInit);
                        }
                        if ((asSeverityPart = (TupleLiteralPart)NameUtil.getNameable((Iterable)asTupleParts, (String)"severity")) != null && (asSeverityInit = asSeverityPart.getOwnedInit()) != null) {
                            severityExpression = PrettyPrinter.print((Element)asSeverityInit);
                        }
                    }
                }
                StringBuilder s = new StringBuilder();
                if (severityExpression != null) {
                    s.append("let severity : Integer = " + severityExpression + " in\n");
                } else {
                    s.append("let severity : Integer = '" + constraintName + "'.getSeverity() in\n" + "if severity <= 0 then true\n" + "else ");
                }
                s.append("let status : OclAny = " + statusExpression + " in\n");
                if (messageExpression != null) {
                    s.append("let message : String = if status <> true then " + messageExpression + " else null endif in\n");
                }
                s.append("'" + constraintName + "'.logDiagnostic(self, null, diagnostics, context, ");
                s.append(messageExpression != null ? "message" : "null");
                s.append(", severity, status, 0)\n");
                if (severityExpression == null) {
                    s.append("endif\n");
                }
                String cgExpression = s.toString();
                ExpressionInOCL query = parserContext.parse(contextElement, cgExpression);
                OCLinEcoreLocalContext localContext = (OCLinEcoreLocalContext)this.globalContext.getLocalContext(cgConstraint);
                Variable contextVariable = query.getOwnedContext();
                if (contextVariable != null) {
                    CGParameter cgParameter = this.getParameter(contextVariable, null);
                    cgConstraint.getParameters().add(cgParameter);
                }
                for (Variable parameterVariable : query.getOwnedParameters()) {
                    String contextName;
                    String diagnosticsName = localContext != null ? localContext.getDiagnosticsName() : null;
                    String string = contextName = localContext != null ? localContext.getContextName() : null;
                    CGParameter cgParameter = diagnosticsName != null && diagnosticsName.equals(parameterVariable.getName()) ? this.getParameter(parameterVariable, diagnosticsName) : (contextName != null && contextName.equals(parameterVariable.getName()) ? this.getParameter(parameterVariable, contextName) : this.getParameter(parameterVariable, null));
                    cgConstraint.getParameters().add(cgParameter);
                }
                cgConstraint.setBody(this.doVisit(CGValuedElement.class, (Element)query.getOwnedBody()));
            }
            catch (ParserException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
        return cgConstraint;
    }
}

