/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGlobalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreLocalContext;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class OCLinEcoreCG2JavaVisitor
extends CG2JavaVisitor<OCLinEcoreCodeGenerator> {
    @NonNull
    protected final GenPackage genPackage;
    @NonNull
    protected final CGPackage cgPackage;
    protected ExpressionInOCL expInOcl;
    protected Feature feature;

    public OCLinEcoreCG2JavaVisitor(@NonNull OCLinEcoreCodeGenerator codeGenerator, @NonNull GenPackage genPackage, @NonNull CGPackage cgPackage) {
        super(codeGenerator);
        this.genPackage = genPackage;
        this.cgPackage = cgPackage;
    }

    @Override
    protected void appendGlobalPrefix() {
        this.js.append(this.getGlobalContext().getTablesClassName());
        this.js.append(".");
    }

    @NonNull
    public Map<String, String> generateBodies() {
        HashMap<String, String> bodies = new HashMap<String, String>();
        for (CGClass cgClass : this.cgPackage.getClasses()) {
            String fragmentURI;
            String bodyText;
            String returnClassName;
            CGValuedElement cgBody;
            for (CGConstraint cgConstraint : cgClass.getInvariants()) {
                cgBody = cgConstraint.getBody();
                Element pivotClass = cgClass.getAst();
                Element asElement = cgConstraint.getAst();
                if (cgBody == null || !(pivotClass instanceof Class) || !(asElement instanceof Constraint)) continue;
                Constraint asConstraint = (Constraint)asElement;
                this.localContext = this.globalContext.getLocalContext(cgConstraint);
                String bodyText2 = this.generateValidatorBody(cgBody, asConstraint, (Class)pivotClass);
                String fragmentURI2 = String.valueOf(this.getFragmentURI(pivotClass)) + "==" + this.getRuleName(asConstraint);
                bodies.put(fragmentURI2, bodyText2);
            }
            for (CGOperation cgOperation : cgClass.getOperations()) {
                cgBody = cgOperation.getBody();
                Element asOperation = cgOperation.getAst();
                if (cgBody == null || !(asOperation instanceof Operation)) continue;
                returnClassName = this.genModelHelper.getOperationReturnType((Operation)asOperation);
                this.localContext = this.globalContext.getLocalContext(cgOperation);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI(asOperation);
                bodies.put(fragmentURI, bodyText);
            }
            for (CGProperty cgProperty : cgClass.getProperties()) {
                cgBody = cgProperty.getBody();
                Element asProperty = cgProperty.getAst();
                if (cgBody == null || !(asProperty instanceof Property)) continue;
                returnClassName = this.genModelHelper.getPropertyResultType((Property)asProperty);
                this.localContext = this.globalContext.getLocalContext(cgProperty);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI(asProperty);
                bodies.put(fragmentURI, bodyText);
            }
        }
        this.localContext = null;
        return bodies;
    }

    @NonNull
    protected String generateBody(@NonNull CGValuedElement cgBody, @NonNull String returnClassName) {
        this.js.resetStream();
        this.js.appendCommentWithOCL(null, cgBody.getAst());
        this.js.appendLocalStatements(cgBody);
        CGInvalid cgInvalidValue = cgBody.getInvalidValue();
        if (cgInvalidValue != null) {
            this.js.append("throw new ");
            this.js.appendValueName(cgInvalidValue);
        } else {
            this.js.append("return ");
            this.js.appendEcoreValue(returnClassName, cgBody);
        }
        this.js.append(";");
        return this.toString();
    }

    @NonNull
    public String generateConstants(List<CGValuedElement> sortedGlobals) {
        this.js.resetStream();
        this.js.pushIndentation(null);
        if (sortedGlobals != null) {
            this.generateGlobals(sortedGlobals);
        }
        return this.toString();
    }

    @NonNull
    protected String generateValidatorBody(@NonNull CGValuedElement cgBody, @NonNull Constraint asConstraint, @NonNull Class asType) {
        GenClassifier genClassifier;
        String genClassifierName;
        String ecoreConstraintName;
        this.js.resetStream();
        String constraintName = ecoreConstraintName = asConstraint.getName();
        if (constraintName.startsWith("validate")) {
            constraintName = constraintName.substring(8);
        }
        String string = genClassifierName = (genClassifier = this.genModelHelper.getGenClassifier(asType)) != null ? genClassifier.getName() : null;
        if (genClassifierName == null) {
            genClassifierName = "";
        }
        this.js.appendCommentWithOCL(null, (Element)asConstraint);
        this.js.appendLocalStatements(cgBody);
        this.js.append("return Boolean.TRUE == ");
        this.js.appendEcoreValue("boolean", cgBody);
        this.js.append(";");
        return this.toString();
    }

    protected String getFragmentURI(@NonNull Element element) {
        return EcoreUtil.getURI((EObject)element).fragment().toString();
    }

    @NonNull
    protected OCLinEcoreGlobalContext getGlobalContext() {
        return (OCLinEcoreGlobalContext)this.globalContext;
    }

    @NonNull
    protected OCLinEcoreLocalContext getLocalContext() {
        return (OCLinEcoreLocalContext)ClassUtil.nonNullState((Object)((OCLinEcoreLocalContext)this.localContext));
    }

    protected String getRuleName(@NonNull Constraint constraint) {
        String name = constraint.getName();
        return name != null ? name : "";
    }

    @Override
    @NonNull
    public Boolean visitCGClass(@NonNull CGClass cgClass) {
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement globalConstant = cgConstantExp.getReferredConstant();
        if (globalConstant instanceof CGExecutorType) {
            return true;
        }
        if (globalConstant != null) {
            if (!cgConstantExp.isInlined()) {
                this.appendGlobalPrefix();
            }
            this.js.appendValueName(globalConstant);
        }
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGOperation(@NonNull CGOperation cgOperation) {
        return true;
    }

    @Override
    @NonNull
    public Boolean visitCGPackage(@NonNull CGPackage cgPackage) {
        return true;
    }
}

