/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.as2es;

import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UML;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.UMLFactory;

public class AS2UMLDeclarationVisitor
extends AbstractExtendingVisitor<EModelElement, AS2UML> {
    public AS2UMLDeclarationVisitor(@NonNull AS2UML context) {
        super((Object)context);
    }

    protected void copyClassifier(@NonNull Classifier umlClassifier, @NonNull Class pivotType) {
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlClassifier, (NamedElement)pivotType);
        TemplateSignature pivotTemplateSignature = pivotType.getOwnedSignature();
        if (pivotTemplateSignature != null) {
            umlClassifier.setOwnedTemplateSignature((org.eclipse.uml2.uml.TemplateSignature)this.safeVisit((Visitable)pivotTemplateSignature));
        }
        this.safeVisitAll((List)umlClassifier.getEAnnotations(), pivotType.getOwnedAnnotations());
        StringBuilder s = null;
        for (Constraint pivotConstraint : pivotType.getOwnedInvariants()) {
            this.safeVisit((Visitable)pivotConstraint);
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(" ");
            }
            s.append(pivotConstraint.getName());
        }
    }

    protected void copyDataTypeOrEnum(@NonNull org.eclipse.uml2.uml.DataType umlDataType, @NonNull DataType pivotDataType) {
        this.copyClassifier((Classifier)umlDataType, (Class)pivotDataType);
    }

    protected void copyDetails(@NonNull EAnnotation umlAnnotation, @NonNull Annotation pivotAnnotation) {
        this.copyEModelElement((EModelElement)umlAnnotation, (Element)pivotAnnotation);
        this.safeVisitAll((List)umlAnnotation.getEAnnotations(), pivotAnnotation.getOwnedAnnotations());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetails()) {
            String name = pivotDetail.getName();
            String value = StringUtil.splice((List)pivotDetail.getValues(), (String)"");
            umlAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyEModelElement(@NonNull EModelElement umlElement, @NonNull Element pivotModelElement) {
        ((AS2UML)((Object)this.context)).putCreated(pivotModelElement, umlElement);
    }

    protected void copyModelElement(@NonNull org.eclipse.uml2.uml.Element umlElement, @NonNull Element pivotModelElement) {
        this.copyEModelElement((EModelElement)umlElement, pivotModelElement);
        this.safeVisitAll((List)umlElement.getOwnedComments(), pivotModelElement.getOwnedComments());
    }

    protected void copyNamedElement(@NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement, @NonNull NamedElement pivotNamedElement) {
        this.copyModelElement((org.eclipse.uml2.uml.Element)umlNamedElement, (Element)pivotNamedElement);
        umlNamedElement.setName(pivotNamedElement.getName());
        this.safeVisitAll((List)umlNamedElement.getOwnedComments(), pivotNamedElement.getOwnedComments());
    }

    protected void copyTypedElement(@NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement, @NonNull TypedElement pivotTypedElement) {
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlTypedElement, (NamedElement)pivotTypedElement);
        ((AS2UML)((Object)this.context)).defer((Element)pivotTypedElement);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit((Visitable)element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    public org.eclipse.uml2.uml.Element visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for AS2UML Declaration pass");
    }

    public EAnnotation visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation umlAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(umlAnnotation, pivotAnnotation);
        umlAnnotation.setSource(pivotAnnotation.getName());
        this.safeVisitAll((List)umlAnnotation.getContents(), pivotAnnotation.getOwnedContents());
        if (!pivotAnnotation.getReferences().isEmpty()) {
            ((AS2UML)((Object)this.context)).defer((Element)pivotAnnotation);
        }
        return umlAnnotation;
    }

    public Classifier visitClass(@NonNull Class pivotClass) {
        Interface umlClassifier;
        if (pivotClass.getOwnedBindings().size() > 0) {
            return null;
        }
        if (pivotClass.isIsInterface()) {
            Interface umlInterface = UMLFactory.eINSTANCE.createInterface();
            this.safeVisitAll((List)umlInterface.getOwnedOperations(), pivotClass.getOwnedOperations());
            this.safeVisitAll((List)umlInterface.getOwnedAttributes(), pivotClass.getOwnedProperties());
            umlClassifier = umlInterface;
        } else {
            org.eclipse.uml2.uml.Class umlClass = UMLFactory.eINSTANCE.createClass();
            this.safeVisitAll((List)umlClass.getOwnedOperations(), pivotClass.getOwnedOperations());
            this.safeVisitAll((List)umlClass.getOwnedAttributes(), pivotClass.getOwnedProperties());
            umlClassifier = umlClass;
        }
        this.copyClassifier((Classifier)umlClassifier, pivotClass);
        ((AS2UML)((Object)this.context)).defer((Element)pivotClass);
        umlClassifier.setIsAbstract(pivotClass.isIsAbstract());
        return umlClassifier;
    }

    public EModelElement visitComment(@NonNull Comment pivotComment) {
        org.eclipse.uml2.uml.Comment umlComment = UMLFactory.eINSTANCE.createComment();
        umlComment.setBody(pivotComment.getBody());
        return umlComment;
    }

    public org.eclipse.uml2.uml.Constraint visitConstraint(@NonNull Constraint pivotConstraint) {
        LanguageExpression specification = pivotConstraint.getOwnedSpecification();
        if (specification == null) {
            return null;
        }
        String exprString = specification.getBody();
        if (exprString == null) {
            return null;
        }
        return null;
    }

    public org.eclipse.uml2.uml.DataType visitDataType(@NonNull DataType pivotDataType) {
        if (pivotDataType.getOwnedBindings().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.DataType umlDataType = UMLFactory.eINSTANCE.createDataType();
        this.copyDataTypeOrEnum(umlDataType, pivotDataType);
        return umlDataType;
    }

    public org.eclipse.uml2.uml.Enumeration visitEnumeration(@NonNull Enumeration pivotEnumeration) {
        if (pivotEnumeration.getOwnedBindings().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.Enumeration umlEnumeration = UMLFactory.eINSTANCE.createEnumeration();
        this.copyDataTypeOrEnum((org.eclipse.uml2.uml.DataType)umlEnumeration, (DataType)pivotEnumeration);
        this.safeVisitAll((List)umlEnumeration.getOwnedLiterals(), pivotEnumeration.getOwnedLiterals());
        return umlEnumeration;
    }

    public org.eclipse.uml2.uml.EnumerationLiteral visitEnumerationLiteral(@NonNull EnumerationLiteral pivotEnumLiteral) {
        org.eclipse.uml2.uml.EnumerationLiteral umlEnumLiteral = UMLFactory.eINSTANCE.createEnumerationLiteral();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlEnumLiteral, (NamedElement)pivotEnumLiteral);
        return umlEnumLiteral;
    }

    public org.eclipse.uml2.uml.Operation visitOperation(@NonNull Operation pivotOperation) {
        if (pivotOperation.getOwnedBindings().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.Operation umlOperation = UMLFactory.eINSTANCE.createOperation();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlOperation, (NamedElement)pivotOperation);
        ((AS2UML)((Object)this.context)).defer((Element)pivotOperation);
        TemplateSignature pivotTemplateSignature = pivotOperation.getOwnedSignature();
        umlOperation.setOwnedTemplateSignature((org.eclipse.uml2.uml.TemplateSignature)this.safeVisit((Visitable)pivotTemplateSignature));
        this.safeVisitAll((List)umlOperation.getOwnedParameters(), pivotOperation.getOwnedParameters());
        this.safeVisitAll((List)umlOperation.getRaisedExceptions(), pivotOperation.getRaisedExceptions());
        for (Constraint pivotConstraint : pivotOperation.getOwnedConstraints()) {
            this.safeVisit((Visitable)pivotConstraint);
        }
        return umlOperation;
    }

    public org.eclipse.uml2.uml.Package visitPackage(@NonNull Package pivotPackage) {
        org.eclipse.uml2.uml.Package umlPackage = UMLFactory.eINSTANCE.createPackage();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlPackage, (NamedElement)pivotPackage);
        ((AS2UML)((Object)this.context)).defer((Element)pivotPackage);
        this.safeVisitAll((List)umlPackage.getNestedPackages(), pivotPackage.getOwnedPackages());
        this.safeVisitAll((List)umlPackage.getOwnedTypes(), pivotPackage.getOwnedClasses());
        return umlPackage;
    }

    public org.eclipse.uml2.uml.Parameter visitParameter(@NonNull Parameter pivotParameter) {
        org.eclipse.uml2.uml.Parameter umlParameter = UMLFactory.eINSTANCE.createParameter();
        this.copyTypedElement((org.eclipse.uml2.uml.TypedElement)umlParameter, (TypedElement)pivotParameter);
        return umlParameter;
    }

    public org.eclipse.uml2.uml.Element visitPrimitiveType(@NonNull PrimitiveType pivotPrimitiveType) {
        if (pivotPrimitiveType.getOwnedBindings().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.PrimitiveType umlPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
        this.copyDataTypeOrEnum((org.eclipse.uml2.uml.DataType)umlPrimitiveType, (DataType)pivotPrimitiveType);
        return umlPrimitiveType;
    }

    public org.eclipse.uml2.uml.Property visitProperty(@NonNull Property pivotProperty) {
        org.eclipse.uml2.uml.Property umlProperty = UMLFactory.eINSTANCE.createProperty();
        this.copyTypedElement((org.eclipse.uml2.uml.TypedElement)umlProperty, (TypedElement)pivotProperty);
        umlProperty.setIsComposite(pivotProperty.isIsComposite());
        umlProperty.setIsReadOnly(pivotProperty.isIsReadOnly());
        umlProperty.setIsDerived(pivotProperty.isIsDerived());
        if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
            ((AS2UML)((Object)this.context)).defer((Element)pivotProperty);
        }
        return umlProperty;
    }

    public org.eclipse.uml2.uml.TemplateSignature visitTemplateSignature(@NonNull TemplateSignature pivotTemplateSignature) {
        RedefinableTemplateSignature umlTemplateSignature = UMLFactory.eINSTANCE.createRedefinableTemplateSignature();
        this.safeVisitAll((List)umlTemplateSignature.getOwnedParameters(), pivotTemplateSignature.getOwnedParameters());
        return umlTemplateSignature;
    }

    public ClassifierTemplateParameter visitTemplateParameter(@NonNull TemplateParameter pivotTemplateParameter) {
        ClassifierTemplateParameter umlTypeParameter = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
        org.eclipse.uml2.uml.Class umlClass = UMLFactory.eINSTANCE.createClass();
        umlClass.setName(pivotTemplateParameter.getName());
        umlTypeParameter.setOwnedParameteredElement((ParameterableElement)umlClass);
        ((AS2UML)((Object)this.context)).putCreated((Element)pivotTemplateParameter, (EModelElement)umlTypeParameter);
        if (!pivotTemplateParameter.getConstrainingClasses().isEmpty()) {
            ((AS2UML)((Object)this.context)).defer((Element)pivotTemplateParameter);
        }
        return umlTypeParameter;
    }
}

